/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.gui;

import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import info.gridworld.gui.DisplayMap;
import info.gridworld.gui.GUIController;
import info.gridworld.gui.GridPanel;
import info.gridworld.gui.MenuMaker;
import info.gridworld.gui.PseudoInfiniteViewport;
import info.gridworld.world.World;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorldFrame<T>
extends JFrame {
    private GUIController<T> control;
    private GridPanel display;
    private JTextArea messageArea;
    private ArrayList<JMenuItem> menuItemsDisabledDuringRun;
    private World<T> world;
    private ResourceBundle resources;
    private DisplayMap displayMap;
    private Set<Class> gridClasses;
    private JMenu newGridMenu;
    private static int count = 0;

    public WorldFrame(World<T> world) {
        this.world = world;
        ++count;
        this.resources = ResourceBundle.getBundle(this.getClass().getName() + "Resources");
        try {
            System.setProperty("sun.awt.exception.handler", GUIExceptionHandler.class.getName());
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                count--;
                if (count == 0) {
                    System.exit(0);
                }
            }
        });
        this.displayMap = new DisplayMap();
        String title = System.getProperty("info.gridworld.gui.frametitle");
        if (title == null) {
            title = this.resources.getString("frame.title");
        }
        this.setTitle(title);
        this.setLocation(25, 15);
        URL appIconUrl = this.getClass().getResource("GridWorld.gif");
        ImageIcon appIcon = new ImageIcon(appIconUrl);
        this.setIconImage(appIcon.getImage());
        this.makeMenus();
        JPanel content = new JPanel();
        content.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        content.setLayout(new BorderLayout());
        this.setContentPane(content);
        this.display = new GridPanel(this.displayMap, this.resources);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent event) {
                if (WorldFrame.this.getFocusOwner() == null) {
                    return false;
                }
                String text = KeyStroke.getKeyStrokeForEvent(event).toString();
                String PRESSED = "pressed ";
                int n = text.indexOf("pressed ");
                if (n < 0) {
                    return false;
                }
                if (event.getKeyChar() == '\uffff' && !event.isActionKey()) {
                    return false;
                }
                text = text.substring(0, n) + text.substring(n + "pressed ".length());
                boolean consumed = WorldFrame.this.getWorld().keyPressed(text, WorldFrame.this.display.getCurrentLocation());
                if (consumed) {
                    WorldFrame.this.repaint();
                }
                return consumed;
            }
        });
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewport(new PseudoInfiniteViewport(scrollPane));
        scrollPane.setViewportView(this.display);
        content.add((Component)scrollPane, "Center");
        this.gridClasses = new TreeSet<Class>(new Comparator<Class>(){

            @Override
            public int compare(Class a, Class b) {
                return a.getName().compareTo(b.getName());
            }
        });
        for (String name : world.getGridClasses()) {
            try {
                this.gridClasses.add(Class.forName(name));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Grid<T> gr = world.getGrid();
        this.gridClasses.add(gr.getClass());
        this.makeNewGridMenu();
        this.control = new GUIController(this, this.display, this.displayMap, this.resources);
        content.add((Component)this.control.controlPanel(), "South");
        this.messageArea = new JTextArea(2, 35);
        this.messageArea.setEditable(false);
        this.messageArea.setFocusable(false);
        this.messageArea.setBackground(new Color(16448210));
        content.add((Component)new JScrollPane(this.messageArea), "North");
        this.pack();
        this.repaint();
        this.display.setGrid(gr);
    }

    @Override
    public void repaint() {
        String message = this.getWorld().getMessage();
        if (message == null) {
            message = this.resources.getString("message.default");
        }
        this.messageArea.setText(message);
        this.messageArea.repaint();
        this.display.repaint();
        super.repaint();
    }

    public World<T> getWorld() {
        return this.world;
    }

    public void setGrid(Grid<T> newGrid) {
        Grid<T> oldGrid = this.world.getGrid();
        HashMap<Location, T> occupants = new HashMap<Location, T>();
        for (Location loc : oldGrid.getOccupiedLocations()) {
            occupants.put(loc, this.world.remove(loc));
        }
        this.world.setGrid(newGrid);
        for (Location loc : occupants.keySet()) {
            if (!newGrid.isValid(loc)) continue;
            this.world.add(loc, occupants.get(loc));
        }
        this.display.setGrid(newGrid);
        this.repaint();
    }

    public void showError(Throwable t, String resource) {
        String title;
        String text;
        try {
            text = this.resources.getString(resource + ".text");
        }
        catch (MissingResourceException e) {
            text = this.resources.getString("error.text");
        }
        try {
            title = this.resources.getString(resource + ".title");
        }
        catch (MissingResourceException e) {
            title = this.resources.getString("error.title");
        }
        String reason = this.resources.getString("error.reason");
        String message = text + "\n" + MessageFormat.format(reason, t);
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    private JMenu makeMenu(String resource) {
        JMenu menu = new JMenu();
        this.configureAbstractButton(menu, resource);
        return menu;
    }

    private JMenuItem makeMenuItem(String resource, ActionListener listener) {
        JMenuItem item = new JMenuItem();
        this.configureMenuItem(item, resource, listener);
        return item;
    }

    private void configureMenuItem(JMenuItem item, String resource, ActionListener listener) {
        this.configureAbstractButton(item, resource);
        item.addActionListener(listener);
        try {
            String accel = this.resources.getString(resource + ".accel");
            String metaPrefix = "@";
            if (accel.startsWith(metaPrefix)) {
                int menuMask = this.getToolkit().getMenuShortcutKeyMask();
                KeyStroke key = KeyStroke.getKeyStroke(KeyStroke.getKeyStroke(accel.substring(metaPrefix.length())).getKeyCode(), menuMask);
                item.setAccelerator(key);
            } else {
                item.setAccelerator(KeyStroke.getKeyStroke(accel));
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
    }

    private void configureAbstractButton(AbstractButton button, String resource) {
        String title = this.resources.getString(resource);
        int i = title.indexOf(38);
        char mnemonic = '\u0000';
        if (i >= 0) {
            mnemonic = title.charAt(i + 1);
            title = title.substring(0, i) + title.substring(i + 1);
            button.setText(title);
            button.setMnemonic(Character.toUpperCase((int)mnemonic));
            button.setDisplayedMnemonicIndex(i);
        } else {
            button.setText(title);
        }
    }

    private void makeMenus() {
        JMenuBar mbar = new JMenuBar();
        this.menuItemsDisabledDuringRun = new ArrayList();
        JMenu menu = this.makeMenu("menu.file");
        mbar.add(menu);
        this.newGridMenu = this.makeMenu("menu.file.new");
        menu.add(this.newGridMenu);
        this.menuItemsDisabledDuringRun.add(this.newGridMenu);
        menu.add(this.makeMenuItem("menu.file.quit", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        }));
        menu = this.makeMenu("menu.view");
        mbar.add(menu);
        menu.add(this.makeMenuItem("menu.view.up", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.display.moveLocation(-1, 0);
            }
        }));
        menu.add(this.makeMenuItem("menu.view.down", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.display.moveLocation(1, 0);
            }
        }));
        menu.add(this.makeMenuItem("menu.view.left", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.display.moveLocation(0, -1);
            }
        }));
        menu.add(this.makeMenuItem("menu.view.right", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.display.moveLocation(0, 1);
            }
        }));
        JMenuItem viewEditMenu = this.makeMenuItem("menu.view.edit", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.control.editLocation();
            }
        });
        menu.add(viewEditMenu);
        this.menuItemsDisabledDuringRun.add(viewEditMenu);
        JMenuItem viewDeleteMenu = this.makeMenuItem("menu.view.delete", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.control.deleteLocation();
            }
        });
        menu.add(viewDeleteMenu);
        this.menuItemsDisabledDuringRun.add(viewDeleteMenu);
        menu.add(this.makeMenuItem("menu.view.zoomin", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.display.zoomIn();
            }
        }));
        menu.add(this.makeMenuItem("menu.view.zoomout", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.display.zoomOut();
            }
        }));
        menu = this.makeMenu("menu.help");
        mbar.add(menu);
        menu.add(this.makeMenuItem("menu.help.about", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.showAboutPanel();
            }
        }));
        menu.add(this.makeMenuItem("menu.help.help", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.showHelp();
            }
        }));
        menu.add(this.makeMenuItem("menu.help.license", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorldFrame.this.showLicense();
            }
        }));
        this.setRunMenuItemsEnabled(true);
        this.setJMenuBar(mbar);
    }

    private void makeNewGridMenu() {
        this.newGridMenu.removeAll();
        MenuMaker maker = new MenuMaker(this, this.resources, this.displayMap);
        maker.addConstructors(this.newGridMenu, this.gridClasses);
    }

    public void setRunMenuItemsEnabled(boolean enable) {
        for (JMenuItem item : this.menuItemsDisabledDuringRun) {
            item.setEnabled(enable);
        }
    }

    private void showAboutPanel() {
        String html = MessageFormat.format(this.resources.getString("dialog.about.text"), this.resources.getString("version.id"));
        String[] props = new String[]{"java.version", "java.vendor", "java.home", "os.name", "os.arch", "os.version", "user.name", "user.home", "user.dir"};
        html = html + "<table border='1'>";
        for (String prop : props) {
            try {
                String value = System.getProperty(prop);
                html = html + "<tr><td>" + prop + "</td><td>" + value + "</td></tr>";
            }
            catch (SecurityException ex) {
                // empty catch block
            }
        }
        html = html + "</table>";
        html = "<html>" + html + "</html>";
        JOptionPane.showMessageDialog(this, new JLabel(html), this.resources.getString("dialog.about.title"), 1);
    }

    private void showHelp() {
        JDialog dialog = new JDialog((Frame)this, this.resources.getString("dialog.help.title"));
        final JEditorPane helpText = new JEditorPane();
        try {
            URL url = this.getClass().getResource("GridWorldHelp.html");
            helpText.setPage(url);
        }
        catch (Exception e) {
            helpText.setText(this.resources.getString("dialog.help.error"));
        }
        helpText.setEditable(false);
        helpText.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent ev) {
                if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        helpText.setPage(ev.getURL());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        JScrollPane sp = new JScrollPane(helpText);
        sp.setPreferredSize(new Dimension(650, 500));
        dialog.getContentPane().add(sp);
        dialog.setLocation(this.getX() + this.getWidth() - 200, this.getY() + 50);
        dialog.pack();
        dialog.setVisible(true);
    }

    private void showLicense() {
        JDialog dialog = new JDialog((Frame)this, this.resources.getString("dialog.license.title"));
        JEditorPane text = new JEditorPane();
        try {
            URL url = this.getClass().getResource("GNULicense.txt");
            text.setPage(url);
        }
        catch (Exception e) {
            text.setText(this.resources.getString("dialog.license.error"));
        }
        text.setEditable(false);
        JScrollPane sp = new JScrollPane(text);
        sp.setPreferredSize(new Dimension(650, 500));
        dialog.getContentPane().add(sp);
        dialog.setLocation(this.getX() + this.getWidth() - 200, this.getY() + 50);
        dialog.pack();
        dialog.setVisible(true);
    }

    public class GUIExceptionHandler {
        public void handle(Throwable e) {
            e.printStackTrace();
            JTextArea area = new JTextArea(10, 40);
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            area.setText(writer.toString());
            area.setCaretPosition(0);
            String copyOption = WorldFrame.this.resources.getString("dialog.error.copy");
            JOptionPane pane = new JOptionPane(new JScrollPane(area), 0, 0, null, new String[]{copyOption, WorldFrame.this.resources.getString("cancel")});
            pane.createDialog(WorldFrame.this, e.toString()).setVisible(true);
            if (copyOption.equals(pane.getValue())) {
                area.setSelectionStart(0);
                area.setSelectionEnd(area.getText().length());
                area.copy();
            }
        }
    }
}

