/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.gui;

import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import info.gridworld.gui.ColorEditor;
import info.gridworld.gui.FormLayout;
import info.gridworld.gui.LocationEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyEditorSupport;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class PropertySheet
extends JPanel {
    private PropertyEditor[] editors;
    private Object[] values;
    private static Map<Class, PropertyEditor> defaultEditors = new HashMap<Class, PropertyEditor>();

    public PropertySheet(Class[] types, Object[] values) {
        this.values = values;
        this.editors = new PropertyEditor[types.length];
        this.setLayout(new FormLayout());
        for (int i = 0; i < values.length; ++i) {
            JLabel label = new JLabel(types[i].getName());
            this.add(label);
            if (Grid.class.isAssignableFrom(types[i])) {
                label.setEnabled(false);
                this.add(new JPanel());
                continue;
            }
            this.editors[i] = this.getEditor(types[i]);
            if (this.editors[i] != null) {
                this.editors[i].setValue(values[i]);
                this.add(this.getEditorComponent(this.editors[i]));
                continue;
            }
            this.add(new JLabel("?"));
        }
    }

    public PropertyEditor getEditor(Class type) {
        PropertyEditor editor = defaultEditors.get(type);
        if (editor != null) {
            return editor;
        }
        editor = PropertyEditorManager.findEditor(type);
        return editor;
    }

    public Component getEditorComponent(final PropertyEditor editor) {
        String[] tags = editor.getTags();
        String text = editor.getAsText();
        if (editor.supportsCustomEditor()) {
            return editor.getCustomEditor();
        }
        if (tags != null) {
            final JComboBox<String> comboBox = new JComboBox<String>(tags);
            comboBox.setSelectedItem(text);
            comboBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        editor.setAsText((String)comboBox.getSelectedItem());
                    }
                }
            });
            return comboBox;
        }
        final JTextField textField = new JTextField(text, 10);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    editor.setAsText(textField.getText());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    editor.setAsText(textField.getText());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        return textField;
    }

    public Object[] getValues() {
        for (int i = 0; i < this.editors.length; ++i) {
            if (this.editors[i] == null) continue;
            this.values[i] = this.editors[i].getValue();
        }
        return this.values;
    }

    static {
        defaultEditors.put(String.class, new StringEditor());
        defaultEditors.put(Location.class, new LocationEditor());
        defaultEditors.put(Color.class, new ColorEditor());
    }

    public static class StringEditor
    extends PropertyEditorSupport {
        public String getAsText() {
            return (String)this.getValue();
        }

        public void setAsText(String s) {
            this.setValue(s);
        }
    }
}

