/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.gui;

import info.gridworld.gui.AbstractDisplay;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class ImageDisplay
extends AbstractDisplay {
    private Class cl;
    private String imageFilename;
    private static final String imageExtension = ".gif";
    private Map<String, Image> tintedVersions = new HashMap<String, Image>();

    public ImageDisplay(Class cl) throws IOException {
        this.cl = cl;
        this.imageFilename = cl.getName().replace('.', '/');
        URL url = cl.getClassLoader().getResource(this.imageFilename + imageExtension);
        if (url == null) {
            throw new FileNotFoundException(this.imageFilename + imageExtension + " not found.");
        }
        this.tintedVersions.put("", ImageIO.read(url));
    }

    public void draw(Object obj, Component comp, Graphics2D g2) {
        Image tinted;
        Color color = obj == null ? null : (Color)ImageDisplay.getProperty(obj, "color");
        String imageSuffix = (String)ImageDisplay.getProperty(obj, "imageSuffix");
        if (imageSuffix == null) {
            imageSuffix = "";
        }
        if ((tinted = this.tintedVersions.get(color + imageSuffix)) == null) {
            Image untinted = this.tintedVersions.get(imageSuffix);
            if (untinted == null) {
                try {
                    URL url = this.cl.getClassLoader().getResource(this.imageFilename + imageSuffix + imageExtension);
                    if (url == null) {
                        throw new FileNotFoundException(this.imageFilename + imageSuffix + imageExtension + " not found.");
                    }
                    untinted = ImageIO.read(url);
                    this.tintedVersions.put(imageSuffix, untinted);
                }
                catch (IOException ex) {
                    untinted = this.tintedVersions.get("");
                }
            }
            if (color == null) {
                tinted = untinted;
            } else {
                FilteredImageSource src = new FilteredImageSource(untinted.getSource(), new TintFilter(color));
                tinted = comp.createImage(src);
                this.tintedVersions.put(color + imageSuffix, tinted);
            }
        }
        int width = tinted.getWidth(null);
        int height = tinted.getHeight(null);
        int size = Math.max(width, height);
        g2.scale(1.0 / (double)size, 1.0 / (double)size);
        g2.clip(new Rectangle(-width / 2, -height / 2, width, height));
        g2.drawImage(tinted, -width / 2, -height / 2, null);
    }

    private static class TintFilter
    extends RGBImageFilter {
        private int tintR;
        private int tintG;
        private int tintB;

        public TintFilter(Color color) {
            this.canFilterIndexColorModel = true;
            int rgb = color.getRGB();
            this.tintR = rgb >> 16 & 0xFF;
            this.tintG = rgb >> 8 & 0xFF;
            this.tintB = rgb & 0xFF;
        }

        public int filterRGB(int x, int y, int argb) {
            int alpha = argb >> 24 & 0xFF;
            int red = argb >> 16 & 0xFF;
            int green = argb >> 8 & 0xFF;
            int blue = argb & 0xFF;
            double lum = (0.2989 * (double)red + 0.5866 * (double)green + 0.1144 * (double)blue) / 255.0;
            double scale = 1.0 - 4.0 * ((lum - 0.5) * (lum - 0.5));
            red = (int)((double)this.tintR * scale + (double)red * (1.0 - scale));
            green = (int)((double)this.tintG * scale + (double)green * (1.0 - scale));
            blue = (int)((double)this.tintB * scale + (double)blue * (1.0 - scale));
            return alpha << 24 | red << 16 | green << 8 | blue;
        }
    }
}

