/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.gui;

import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import info.gridworld.gui.Display;
import info.gridworld.gui.DisplayMap;
import info.gridworld.gui.PseudoInfiniteViewport;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridPanel
extends JPanel
implements Scrollable,
PseudoInfiniteViewport.Pannable {
    private static final int MIN_CELL_SIZE = 12;
    private static final int DEFAULT_CELL_SIZE = 48;
    private static final int DEFAULT_CELL_COUNT = 10;
    private static final int TIP_DELAY = 1000;
    private Grid<?> grid;
    private int numRows;
    private int numCols;
    private int originRow;
    private int originCol;
    private int cellSize;
    private boolean toolTipsEnabled;
    private Color backgroundColor = Color.WHITE;
    private ResourceBundle resources;
    private DisplayMap displayMap;
    private Location currentLocation;
    private Timer tipTimer;
    private JToolTip tip;
    private JPanel glassPane;

    public GridPanel(DisplayMap map, ResourceBundle res) {
        this.displayMap = map;
        this.resources = res;
        this.setToolTipsEnabled(true);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.paintComponent(g2);
        if (this.grid == null) {
            return;
        }
        Insets insets = this.getInsets();
        g2.setColor(this.backgroundColor);
        g2.fillRect(insets.left, insets.top, this.numCols * (this.cellSize + 1) + 1, this.numRows * (this.cellSize + 1) + 1);
        this.drawWatermark(g2);
        this.drawGridlines(g2);
        this.drawOccupants(g2);
        this.drawCurrentLocation(g2);
    }

    private void drawOccupant(Graphics2D g2, int xleft, int ytop, Object obj) {
        Rectangle cellToDraw = new Rectangle(xleft, ytop, this.cellSize, this.cellSize);
        if (cellToDraw.intersects(g2.getClip().getBounds())) {
            Graphics2D g2copy = (Graphics2D)g2.create();
            g2copy.clip(cellToDraw);
            Display displayObj = this.displayMap.findDisplayFor(obj.getClass());
            displayObj.draw(obj, this, g2copy, cellToDraw);
            g2copy.dispose();
        }
    }

    private void drawGridlines(Graphics2D g2) {
        int y;
        Rectangle curClip = g2.getClip().getBounds();
        int top = this.getInsets().top;
        int left = this.getInsets().left;
        int miny = Math.max(0, (curClip.y - top) / (this.cellSize + 1)) * (this.cellSize + 1) + top;
        int minx = Math.max(0, (curClip.x - left) / (this.cellSize + 1)) * (this.cellSize + 1) + left;
        int maxy = Math.min(this.numRows, (curClip.y + curClip.height - top + this.cellSize) / (this.cellSize + 1)) * (this.cellSize + 1) + top;
        int maxx = Math.min(this.numCols, (curClip.x + curClip.width - left + this.cellSize) / (this.cellSize + 1)) * (this.cellSize + 1) + left;
        g2.setColor(Color.GRAY);
        for (y = miny; y <= maxy; y += this.cellSize + 1) {
            for (int x = minx; x <= maxx; x += this.cellSize + 1) {
                Location loc = this.locationForPoint(new Point(x + this.cellSize / 2, y + this.cellSize / 2));
                if (loc == null || this.grid.isValid(loc)) continue;
                g2.fillRect(x + 1, y + 1, this.cellSize, this.cellSize);
            }
        }
        g2.setColor(Color.BLACK);
        for (y = miny; y <= maxy; y += this.cellSize + 1) {
            g2.drawLine(minx, y, maxx, y);
        }
        for (int x = minx; x <= maxx; x += this.cellSize + 1) {
            g2.drawLine(x, miny, x, maxy);
        }
    }

    private void drawOccupants(Graphics2D g2) {
        ArrayList<Location> occupantLocs = this.grid.getOccupiedLocations();
        for (int index = 0; index < occupantLocs.size(); ++index) {
            Location loc = occupantLocs.get(index);
            int xleft = this.colToXCoord(loc.getCol());
            int ytop = this.rowToYCoord(loc.getRow());
            this.drawOccupant(g2, xleft, ytop, this.grid.get(loc));
        }
    }

    private void drawCurrentLocation(Graphics2D g2) {
        if ("hide".equals(System.getProperty("info.gridworld.gui.selection"))) {
            return;
        }
        if (this.currentLocation != null) {
            Point p = this.pointForLocation(this.currentLocation);
            g2.drawRect(p.x - this.cellSize / 2 - 2, p.y - this.cellSize / 2 - 2, this.cellSize + 3, this.cellSize + 3);
        }
    }

    private void drawWatermark(Graphics2D g2) {
        if ("hide".equals(System.getProperty("info.gridworld.gui.watermark"))) {
            return;
        }
        g2 = (Graphics2D)g2.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle rect = this.getBounds();
        g2.setPaint(new Color(227, 211, 211));
        int WATERMARK_FONT_SIZE = 100;
        String s = this.resources.getString("version.id");
        if ("1.0".compareTo(s) <= 0) {
            return;
        }
        g2.setFont(new Font("SansSerif", 1, 100));
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D bounds = g2.getFont().getStringBounds(s, frc);
        float centerX = rect.x + rect.width / 2;
        float centerY = rect.y + rect.height / 2;
        float leftX = centerX - (float)bounds.getWidth() / 2.0f;
        LineMetrics lm = g2.getFont().getLineMetrics(s, frc);
        float baselineY = centerY - lm.getHeight() / 2.0f + lm.getAscent();
        g2.drawString(s, leftX, baselineY);
    }

    public void setToolTipsEnabled(boolean flag) {
        if ("hide".equals(System.getProperty("info.gridworld.gui.tooltips"))) {
            flag = false;
        }
        if (flag) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
        this.toolTipsEnabled = flag;
    }

    public void setGrid(Grid<?> gr) {
        this.currentLocation = new Location(0, 0);
        JViewport vp = this.getEnclosingViewport();
        if (vp != null) {
            vp.setViewPosition(new Point(0, 0));
        }
        this.grid = gr;
        this.originCol = 0;
        this.originRow = 0;
        if (this.grid.getNumRows() == -1 && this.grid.getNumCols() == -1) {
            this.numCols = 2000;
            this.numRows = 2000;
        } else {
            this.numRows = this.grid.getNumRows();
            this.numCols = this.grid.getNumCols();
        }
        this.recalculateCellSize(12);
    }

    private int extraWidth() {
        return this.getInsets().left + this.getInsets().right;
    }

    private int extraHeight() {
        return this.getInsets().top + this.getInsets().left;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.numCols * (this.cellSize + 1) + 1 + this.extraWidth(), this.numRows * (this.cellSize + 1) + 1 + this.extraHeight());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.numCols * 13 + 1 + this.extraWidth(), this.numRows * 13 + 1 + this.extraHeight());
    }

    public void zoomIn() {
        this.cellSize *= 2;
        this.revalidate();
    }

    public void zoomOut() {
        this.cellSize = Math.max(this.cellSize / 2, 12);
        this.revalidate();
    }

    public void recenter(Location loc) {
        this.originRow = loc.getRow();
        this.originCol = loc.getCol();
        this.repaint();
        JViewport vp = this.getEnclosingViewport();
        if (vp != null) {
            if (!this.isPannableUnbounded() || !(vp instanceof PseudoInfiniteViewport)) {
                vp.setViewPosition(this.pointForLocation(loc));
            } else {
                this.showPanTip();
            }
        }
    }

    public Location locationForPoint(Point p) {
        return new Location(this.yCoordToRow(p.y), this.xCoordToCol(p.x));
    }

    public Point pointForLocation(Location loc) {
        return new Point(this.colToXCoord(loc.getCol()) + this.cellSize / 2, this.rowToYCoord(loc.getRow()) + this.cellSize / 2);
    }

    private int xCoordToCol(int xCoord) {
        return (xCoord - 1 - this.getInsets().left) / (this.cellSize + 1) + this.originCol;
    }

    private int yCoordToRow(int yCoord) {
        return (yCoord - 1 - this.getInsets().top) / (this.cellSize + 1) + this.originRow;
    }

    private int colToXCoord(int col) {
        return (col - this.originCol) * (this.cellSize + 1) + 1 + this.getInsets().left;
    }

    private int rowToYCoord(int row) {
        return (row - this.originRow) * (this.cellSize + 1) + 1 + this.getInsets().top;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        Location loc = this.locationForPoint(evt.getPoint());
        return this.getToolTipText(loc);
    }

    private String getToolTipText(Location loc) {
        if (!this.toolTipsEnabled || loc == null || !this.grid.isValid(loc)) {
            return null;
        }
        Object f = this.grid.get(loc);
        if (f != null) {
            return MessageFormat.format(this.resources.getString("cell.tooltip.nonempty"), loc, f);
        }
        return MessageFormat.format(this.resources.getString("cell.tooltip.empty"), loc, f);
    }

    public void setCurrentLocation(Location loc) {
        this.currentLocation = loc;
    }

    public Location getCurrentLocation() {
        return this.currentLocation;
    }

    public void moveLocation(int dr, int dc) {
        Location newLocation = new Location(this.currentLocation.getRow() + dr, this.currentLocation.getCol() + dc);
        if (!this.grid.isValid(newLocation)) {
            return;
        }
        this.currentLocation = newLocation;
        JViewport viewPort = this.getEnclosingViewport();
        if (this.isPannableUnbounded()) {
            if (this.originRow > this.currentLocation.getRow()) {
                this.originRow = this.currentLocation.getRow();
            }
            if (this.originCol > this.currentLocation.getCol()) {
                this.originCol = this.currentLocation.getCol();
            }
            Dimension dim = viewPort.getSize();
            int rows = dim.height / (this.cellSize + 1);
            int cols = dim.width / (this.cellSize + 1);
            if (this.originRow + rows - 1 < this.currentLocation.getRow()) {
                this.originRow = this.currentLocation.getRow() - rows + 1;
            }
            if (this.originCol + rows - 1 < this.currentLocation.getCol()) {
                this.originCol = this.currentLocation.getCol() - cols + 1;
            }
        } else if (viewPort != null) {
            int dx = 0;
            int dy = 0;
            Point p = this.pointForLocation(this.currentLocation);
            Rectangle locRect = new Rectangle(p.x - this.cellSize / 2, p.y - this.cellSize / 2, this.cellSize + 1, this.cellSize + 1);
            Rectangle viewRect = viewPort.getViewRect();
            if (!viewRect.contains(locRect)) {
                while (locRect.x < viewRect.x + dx) {
                    dx -= this.cellSize + 1;
                }
                while (locRect.y < viewRect.y + dy) {
                    dy -= this.cellSize + 1;
                }
                while (locRect.getMaxX() > viewRect.getMaxX() + (double)dx) {
                    dx += this.cellSize + 1;
                }
                while (locRect.getMaxY() > viewRect.getMaxY() + (double)dy) {
                    dy += this.cellSize + 1;
                }
                Point pt = viewPort.getViewPosition();
                pt.x += dx;
                pt.y += dy;
                viewPort.setViewPosition(pt);
            }
        }
        this.repaint();
        this.showTip(this.getToolTipText(this.currentLocation), this.pointForLocation(this.currentLocation));
    }

    public void showTip(String tipText, Point pt) {
        if (this.getRootPane() == null) {
            return;
        }
        if (this.glassPane == null) {
            this.glassPane = new JPanel();
            this.getRootPane().setGlassPane(this.glassPane);
            this.glassPane.setOpaque(false);
            this.glassPane.setLayout(null);
            this.tip = new JToolTip();
            this.glassPane.add(this.tip);
            this.tipTimer = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    GridPanel.this.glassPane.setVisible(false);
                }
            });
            this.tipTimer.setRepeats(false);
        }
        if (tipText == null) {
            return;
        }
        this.tip.setTipText(tipText);
        this.tip.setLocation(SwingUtilities.convertPoint(this, pt, this.glassPane));
        this.tip.setSize(this.tip.getPreferredSize());
        this.glassPane.setVisible(true);
        this.glassPane.repaint();
        this.tipTimer.restart();
    }

    private void recalculateCellSize(int minSize) {
        if (this.numRows == 0 || this.numCols == 0) {
            this.cellSize = 0;
        } else {
            JViewport vp = this.getEnclosingViewport();
            Dimension viewableSize = vp != null ? vp.getSize() : this.getSize();
            int desiredCellSize = Math.min((viewableSize.height - this.extraHeight()) / this.numRows, (viewableSize.width - this.extraWidth()) / this.numCols) - 1;
            this.cellSize = 48;
            if (this.cellSize <= desiredCellSize) {
                while (2 * this.cellSize <= desiredCellSize) {
                    this.cellSize *= 2;
                }
            } else {
                while (this.cellSize / 2 >= Math.max(desiredCellSize, 12)) {
                    this.cellSize /= 2;
                }
            }
        }
        this.revalidate();
    }

    private JViewport getEnclosingViewport() {
        Container parent = this.getParent();
        return parent instanceof JViewport ? (JViewport)parent : null;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.cellSize + 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return (int)((double)visibleRect.height * 0.9);
        }
        return (int)((double)visibleRect.width * 0.9);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(491 + this.extraWidth(), 491 + this.extraHeight());
    }

    @Override
    public void panBy(int hDelta, int vDelta) {
        this.originCol += hDelta / (this.cellSize + 1);
        this.originRow += vDelta / (this.cellSize + 1);
        this.repaint();
    }

    @Override
    public boolean isPannableUnbounded() {
        return this.grid != null && (this.grid.getNumRows() == -1 || this.grid.getNumCols() == -1);
    }

    @Override
    public void showPanTip() {
        Location loc;
        String tipText = null;
        Point upperLeft = new Point(0, 0);
        JViewport vp = this.getEnclosingViewport();
        if (!this.isPannableUnbounded() && vp != null) {
            upperLeft = vp.getViewPosition();
        }
        if ((loc = this.locationForPoint(upperLeft)) != null) {
            tipText = this.getToolTipText(loc);
        }
        this.showTip(tipText, this.getLocation());
    }
}

