/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.gui;

import info.gridworld.gui.DefaultDisplay;
import info.gridworld.gui.Display;
import info.gridworld.gui.ImageDisplay;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import javax.swing.Icon;

public class DisplayMap {
    private HashMap<Class, Display> map = new HashMap();
    private Display defaultDisplay = new DefaultDisplay();

    private Display createDisplay(Class cl) {
        try {
            String className = cl.getName();
            Class<?> dcl = Class.forName(className + "Display");
            if (Display.class.isAssignableFrom(dcl)) {
                Display display = (Display)dcl.newInstance();
                this.map.put(cl, display);
                return display;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ImageDisplay display = new ImageDisplay(cl);
            this.map.put(cl, display);
            return display;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Display findDisplayFor(Class cl) {
        if (cl == Object.class) {
            return this.defaultDisplay;
        }
        Display display = this.map.get(cl);
        if (display != null) {
            return display;
        }
        display = this.createDisplay(cl);
        if (display != null) {
            this.map.put(cl, display);
            return display;
        }
        display = this.findDisplayFor(cl.getSuperclass());
        this.map.put(cl, display);
        return display;
    }

    public Icon getIcon(Class cl, int w, int h) {
        return new DisplayIcon(cl, w, h);
    }

    private class DisplayIcon
    implements Icon {
        private Display displayObj;
        private int width;
        private int height;

        public DisplayIcon(Class cl, int w, int h) {
            this.displayObj = DisplayMap.this.findDisplayFor(cl);
            this.width = w;
            this.height = h;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component comp, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform savedTransform = g2.getTransform();
            this.displayObj.draw(null, comp, g2, new Rectangle(x, y, this.getIconWidth(), this.getIconHeight()));
            g2.setTransform(savedTransform);
        }
    }
}

