/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.grid;

import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGrid<E>
implements Grid<E> {
    @Override
    public ArrayList<E> getNeighbors(Location loc) {
        ArrayList neighbors = new ArrayList();
        for (Location neighborLoc : this.getOccupiedAdjacentLocations(loc)) {
            neighbors.add(this.get(neighborLoc));
        }
        return neighbors;
    }

    @Override
    public ArrayList<Location> getValidAdjacentLocations(Location loc) {
        ArrayList<Location> locs = new ArrayList<Location>();
        int d = 0;
        for (int i = 0; i < 8; ++i) {
            Location neighborLoc = loc.getAdjacentLocation(d);
            if (this.isValid(neighborLoc)) {
                locs.add(neighborLoc);
            }
            d += 45;
        }
        return locs;
    }

    @Override
    public ArrayList<Location> getEmptyAdjacentLocations(Location loc) {
        ArrayList<Location> locs = new ArrayList<Location>();
        for (Location neighborLoc : this.getValidAdjacentLocations(loc)) {
            if (this.get(neighborLoc) != null) continue;
            locs.add(neighborLoc);
        }
        return locs;
    }

    @Override
    public ArrayList<Location> getOccupiedAdjacentLocations(Location loc) {
        ArrayList<Location> locs = new ArrayList<Location>();
        for (Location neighborLoc : this.getValidAdjacentLocations(loc)) {
            if (this.get(neighborLoc) == null) continue;
            locs.add(neighborLoc);
        }
        return locs;
    }

    public String toString() {
        String s = "{";
        for (Location loc : this.getOccupiedLocations()) {
            if (s.length() > 1) {
                s = s + ", ";
            }
            s = s + loc + "=" + this.get(loc);
        }
        return s + "}";
    }
}

