/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.actor;

import info.gridworld.actor.Actor;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import info.gridworld.world.World;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActorWorld
extends World<Actor> {
    private static final String DEFAULT_MESSAGE = "Click on a grid location to construct or manipulate an actor.";

    public ActorWorld() {
    }

    public ActorWorld(Grid<Actor> grid) {
        super(grid);
    }

    @Override
    public void show() {
        if (this.getMessage() == null) {
            this.setMessage(DEFAULT_MESSAGE);
        }
        super.show();
    }

    @Override
    public void step() {
        Grid gr = this.getGrid();
        ArrayList actors = new ArrayList();
        for (Location loc : gr.getOccupiedLocations()) {
            actors.add(gr.get(loc));
        }
        for (Actor a : actors) {
            if (a.getGrid() != gr) continue;
            a.act();
        }
    }

    @Override
    public void add(Location loc, Actor occupant) {
        occupant.putSelfInGrid(this.getGrid(), loc);
    }

    public void add(Actor occupant) {
        Location loc = this.getRandomEmptyLocation();
        if (loc != null) {
            this.add(loc, occupant);
        }
    }

    @Override
    public Actor remove(Location loc) {
        Actor occupant = (Actor)this.getGrid().get(loc);
        if (occupant == null) {
            return null;
        }
        occupant.removeSelfFromGrid();
        return occupant;
    }
}

