/*
 * Decompiled with CFR 0.152.
 */
package info.gridworld.actor;

import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Actor {
    private Grid<Actor> grid = null;
    private Location location = null;
    private int direction = 0;
    private Color color = Color.BLUE;

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color newColor) {
        this.color = newColor;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int newDirection) {
        this.direction = newDirection % 360;
        if (this.direction < 0) {
            this.direction += 360;
        }
    }

    public Grid<Actor> getGrid() {
        return this.grid;
    }

    public Location getLocation() {
        return this.location;
    }

    public void putSelfInGrid(Grid<Actor> gr, Location loc) {
        if (this.grid != null) {
            throw new IllegalStateException("This actor is already contained in a grid.");
        }
        Actor actor = gr.get(loc);
        if (actor != null) {
            actor.removeSelfFromGrid();
        }
        gr.put(loc, this);
        this.grid = gr;
        this.location = loc;
    }

    public void removeSelfFromGrid() {
        if (this.grid == null) {
            throw new IllegalStateException("This actor is not contained in a grid.");
        }
        if (this.grid.get(this.location) != this) {
            throw new IllegalStateException("The grid contains a different actor at location " + this.location + ".");
        }
        this.grid.remove(this.location);
        this.grid = null;
        this.location = null;
    }

    public void moveTo(Location newLocation) {
        if (this.grid == null) {
            throw new IllegalStateException("This actor is not in a grid.");
        }
        if (this.grid.get(this.location) != this) {
            throw new IllegalStateException("The grid contains a different actor at location " + this.location + ".");
        }
        if (!this.grid.isValid(newLocation)) {
            throw new IllegalArgumentException("Location " + newLocation + " is not valid.");
        }
        if (newLocation.equals(this.location)) {
            return;
        }
        this.grid.remove(this.location);
        Actor other = this.grid.get(newLocation);
        if (other != null) {
            other.removeSelfFromGrid();
        }
        this.location = newLocation;
        this.grid.put(this.location, this);
    }

    public void act() {
        this.setDirection(this.getDirection() + 180);
    }

    public String toString() {
        return this.getClass().getName() + "[location=" + this.location + ",direction=" + this.direction + ",color=" + this.color + "]";
    }
}

