/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.StringTokenizer;

public class TCAStringManip {
    public static String charString(char c, int len) {
        String temp = "";
        int i = 1;
        while (i <= len) {
            temp = String.valueOf(temp) + c;
            ++i;
        }
        return temp;
    }

    public static String repeatedPhrase(String x, int n) {
        String temp = "";
        int i = 1;
        while (i <= n) {
            temp = String.valueOf(temp) + x;
            ++i;
        }
        return temp;
    }

    public static String repeatedPhrase(String x, int n, char delimiter) {
        String temp = "";
        int i = 1;
        while (i < n) {
            temp = String.valueOf(temp) + x;
            temp = String.valueOf(temp) + delimiter;
            ++i;
        }
        temp = String.valueOf(temp) + x;
        return temp;
    }

    public static String insertCharInto(String s, char c, int posn) {
        String temp = s;
        ArrayList<Character> a = TCAStringManip.toArrayList(s);
        if (posn < 0) {
            posn = 0;
        }
        if (posn > s.length()) {
            posn = s.length();
        }
        a.add(posn, Character.valueOf(c));
        temp = TCAStringManip.makeString(a);
        return temp;
    }

    public static ArrayList<Character> toArrayList(String s) {
        ArrayList<Character> temp = new ArrayList<Character>();
        int len = s.length();
        int i = 0;
        while (i < len) {
            temp.add(Character.valueOf(s.charAt(i)));
            ++i;
        }
        return temp;
    }

    public static String makeString(ArrayList<Character> a) {
        String temp = "";
        for (char c : a) {
            temp = String.valueOf(temp) + c;
        }
        return temp;
    }

    public static String makeString(int x0, int n) {
        String temp = "";
        int i = 0;
        while (i < n) {
            temp = String.valueOf(temp) + (char)(x0 + i);
            ++i;
        }
        return temp;
    }

    public static String encode(String m, String p) {
        int umin = 32;
        int umax = 126;
        String temp = "";
        TCACharacterArray u = new TCACharacterArray(m);
        TCACharacterArray k = new TCACharacterArray(p);
        TCADoubleArray unicodes = u.getUnicodes();
        TCADoubleArray shifters = k.getUnicodes();
        int len = unicodes.getLength();
        int shifterLen = shifters.getLength();
        int i = 0;
        int ndx = 0;
        while (ndx < len) {
            int shiftedUnicode = umin + (int)(unicodes.getValue(ndx) + shifters.getValue(i %= shifterLen)) % (umax - umin);
            temp = String.valueOf(temp) + (char)shiftedUnicode;
            ++i;
            ++ndx;
        }
        return temp;
    }

    public static String decode(String m, String p) {
        int umin = 32;
        int umax = 126;
        String temp = "";
        TCACharacterArray u = new TCACharacterArray(m);
        TCACharacterArray k = new TCACharacterArray(p);
        TCADoubleArray unicodes = u.getUnicodes();
        TCADoubleArray shifters = k.getUnicodes();
        int len = unicodes.getLength();
        int shifterLen = shifters.getLength();
        int i = 0;
        double divisor = umax - umin;
        int ndx = 0;
        while (ndx < len) {
            double tempVal;
            i %= shifterLen;
            int multiple = -1;
            while ((tempVal = unicodes.getValue(ndx) - (double)umin + (double)(++multiple) * divisor - shifters.getValue(i)) < (double)umin) {
            }
            int shiftedUnicode = (int)tempVal;
            temp = String.valueOf(temp) + (char)shiftedUnicode;
            ++i;
            ++ndx;
        }
        return temp;
    }

    public static String makeString(int[] a) {
        String temp = "";
        int[] nArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            temp = String.valueOf(temp) + (char)i;
            ++n2;
        }
        return temp;
    }

    public static String makeString(char[] c) {
        String temp = "";
        char[] cArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            char i = cArray[n2];
            temp = String.valueOf(temp) + i;
            ++n2;
        }
        return temp;
    }

    public static String alphabetize0(String s) {
        int[] myUnicodes = TCAStringManip.toIntArray(s);
        TCADoubleArray da = new TCADoubleArray(myUnicodes);
        int[] sortedArray = da.makeSortedIntArray();
        String alphabetized = TCAStringManip.makeString(sortedArray);
        return alphabetized;
    }

    public static String alphabetize(String s, boolean sensitive) {
        String alphabetized = "";
        if (!sensitive) {
            s = s.toLowerCase();
        }
        int[] myUnicodes = TCAStringManip.toIntArray(s);
        TCADoubleArray da = new TCADoubleArray(myUnicodes);
        int[] sortedArray = da.makeSortedIntArray();
        alphabetized = TCAStringManip.makeString(sortedArray);
        return alphabetized;
    }

    public static String reverse0(String s) {
        String temp = s;
        String bw = "";
        int n = s.length();
        int k = n - 1;
        while (k >= 0) {
            bw = String.valueOf(bw) + temp.substring(k, k + 1);
            --k;
        }
        bw = TCAStringManip.matchCaseOfWord(s, bw);
        return bw;
    }

    public static boolean containsPunctuation(String x) {
        boolean hasPunctuation = false;
        ArrayList<Character> a = TCAStringManip.toArrayList(x);
        for (char ch : a) {
            if (!TCAStringManip.isPunctuation(ch)) continue;
            hasPunctuation = true;
            break;
        }
        return hasPunctuation;
    }

    public static String reverse(String s) {
        String temp = s;
        String bw = "";
        int n = s.length();
        String sansPunctuation = "";
        if (TCAStringManip.containsPunctuation(s)) {
            HashMap<Integer, Character> punctLocn = new HashMap<Integer, Character>();
            ArrayList<Character> c = TCAStringManip.toArrayList(s);
            int i = 0;
            while (i < n) {
                char ch = c.get(i).charValue();
                if (TCAStringManip.isPunctuation(ch)) {
                    punctLocn.put(i, Character.valueOf(ch));
                } else {
                    sansPunctuation = String.valueOf(sansPunctuation) + ch;
                }
                ++i;
            }
            String bw2 = TCAStringManip.reverse(sansPunctuation);
            int i2 = 0;
            while (i2 < n) {
                if (punctLocn.containsKey(i2)) {
                    char symbol = ((Character)punctLocn.get(i2)).charValue();
                    bw2 = TCAStringManip.insertCharInto(bw2, symbol, i2);
                }
                bw = bw2;
                ++i2;
            }
        } else {
            int k = n - 1;
            while (k >= 0) {
                bw = String.valueOf(bw) + temp.substring(k, k + 1);
                --k;
            }
            bw = TCAStringManip.matchCaseOfWord(s, bw);
        }
        return bw;
    }

    public static String alphabetize(String s) {
        String bw = "";
        int n = s.length();
        if (n == 1) {
            return s;
        }
        String sansPunctuation = "";
        if (TCAStringManip.containsPunctuation(s)) {
            HashMap<Integer, Character> punctLocn = new HashMap<Integer, Character>();
            ArrayList<Character> c = TCAStringManip.toArrayList(s);
            int i = 0;
            while (i < n) {
                char ch = c.get(i).charValue();
                if (TCAStringManip.isPunctuation(ch)) {
                    punctLocn.put(i, Character.valueOf(ch));
                } else {
                    sansPunctuation = String.valueOf(sansPunctuation) + ch;
                }
                ++i;
            }
            String bw2 = TCAStringManip.alphabetize(sansPunctuation);
            int i2 = 0;
            while (i2 < n) {
                if (punctLocn.containsKey(i2)) {
                    char symbol = ((Character)punctLocn.get(i2)).charValue();
                    bw2 = TCAStringManip.insertCharInto(bw2, symbol, i2);
                }
                bw = bw2;
                ++i2;
            }
        } else {
            bw = TCAStringManip.alphabetize(s, false);
            bw = TCAStringManip.matchCaseOfWord(s, bw);
        }
        return bw;
    }

    public static int[] toIntArray(String s) {
        int[] temp = new int[s.length()];
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c;
            char unicode = c = s.charAt(i);
            temp[i] = unicode;
            ++i;
        }
        return temp;
    }

    public static TCACharacterArray uniqueLetters(String s) {
        TCACharacterArray a = new TCACharacterArray(s);
        TCADoubleArray u = a.getUnicodes().findUniqueValues();
        TCACharacterArray uniques = new TCACharacterArray(u);
        return uniques;
    }

    public static TCACharacterArray duplicates(String s) {
        TCACharacterArray a = new TCACharacterArray(s);
        TCADoubleArray dups = a.getUnicodes().repeatedValuesTCADoubleArray();
        TCACharacterArray duplicates = dups != null ? new TCACharacterArray(dups) : null;
        return duplicates;
    }

    public static boolean isIsogram(String x) {
        boolean status = false;
        TCACharacterArray dups = TCAStringManip.duplicates(x);
        if (dups == null) {
            status = true;
        }
        return status;
    }

    public static boolean isPalindrome(String x) {
        boolean status = false;
        String bwards = TCAStringManip.reverse(x = x.toLowerCase());
        if (bwards.equals(x)) {
            status = true;
        }
        return status;
    }

    public static boolean isAlphaOrdered(String x) {
        boolean status = false;
        String ordered = TCAStringManip.alphabetize(x);
        if (ordered.equals(x)) {
            status = true;
        }
        return status;
    }

    public static String concatenateStringsFromArray(ArrayList<String> s) {
        String temp = "";
        for (String x : s) {
            temp = String.valueOf(temp) + x;
        }
        return temp;
    }

    public static String concatenateStringsFromArrayWithNewLines(ArrayList<String> s) {
        String temp = "";
        for (String x : s) {
            temp = String.valueOf(temp) + x;
            temp = String.valueOf(temp) + "\n";
        }
        return temp;
    }

    public static String concatenateStringsFromArrayWithDelimiter(ArrayList<String> s, String delimiter) {
        String temp = "";
        for (String x : s) {
            temp = String.valueOf(temp) + x;
            temp = String.valueOf(temp) + delimiter;
        }
        return temp;
    }

    public static String interweave(String p, String w, int f) {
        if (f <= 0) {
            f = 1;
        }
        String temp = "";
        int len = p.length();
        int fcount = 1;
        int wndx = 0;
        temp = String.valueOf(temp) + p.charAt(0);
        int i = 1;
        while (i < len) {
            if (fcount == f) {
                char chw = w.charAt(wndx);
                if (++wndx >= w.length()) {
                    wndx = 0;
                }
                fcount = 0;
                temp = String.valueOf(temp) + chw;
            }
            ++fcount;
            char chp = p.charAt(i);
            temp = String.valueOf(temp) + chp;
            ++i;
        }
        return temp;
    }

    public static String removeChars(String x, int[] u) {
        String temp = x;
        String target = TCAStringManip.makeString(u);
        int len = x.length();
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (target.indexOf(ch, 0) < 0) {
                temp = String.valueOf(temp) + ch;
            }
            ++i;
        }
        return temp;
    }

    public static String removeChars(String x, char[] c) {
        String temp = "";
        String target = TCAStringManip.makeString(c);
        int len = x.length();
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (target.indexOf(ch, 0) < 0) {
                temp = String.valueOf(temp) + ch;
            }
            ++i;
        }
        return temp;
    }

    public static String removeCharsCaseInsensitive(String x, char[] c) {
        String temp = "";
        String target = TCAStringManip.makeString(c);
        String targetLC = target.toLowerCase();
        String targetUC = target.toUpperCase();
        int len = x.length();
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (targetLC.indexOf(ch, 0) < 0 && targetUC.indexOf(ch, 0) < 0) {
                temp = String.valueOf(temp) + ch;
            }
            ++i;
        }
        return temp;
    }

    public static String removeSpaces(String x) {
        return TCAStringManip.removeChars(x, " ");
    }

    public static String removeChars(String x, String target) {
        String temp = "";
        int len = x.length();
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (target.indexOf(ch, 0) < 0) {
                temp = String.valueOf(temp) + ch;
            }
            ++i;
        }
        return temp;
    }

    public static String removeAllCharsBut(String x, String target) {
        String temp = "";
        int len = x.length();
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (target.indexOf(ch, 0) >= 0) {
                temp = String.valueOf(temp) + ch;
            }
            ++i;
        }
        return temp;
    }

    public static boolean isPunctuation(int u) {
        String temp = "";
        String pString = ".,:;'\")(!?-";
        return pString.indexOf(temp = String.valueOf(temp) + (char)u, 0) >= 0;
    }

    public static boolean isPunctuationOrSpace(int u) {
        String temp = "";
        String pString = ".,:;'\")(!?- ";
        return pString.indexOf(temp = String.valueOf(temp) + (char)u, 0) >= 0;
    }

    public static boolean isDigit(int u) {
        String temp = "";
        String dString = "0123456789";
        return dString.indexOf(temp = String.valueOf(temp) + (char)u, 0) >= 0;
    }

    public static boolean isDigit(char u) {
        String temp = "";
        String dString = "0123456789";
        return dString.indexOf(temp = String.valueOf(temp) + u, 0) >= 0;
    }

    public static String removePunctuation(String x) {
        String temp = "";
        int len = x.length();
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (!TCAStringManip.isPunctuation(ch)) {
                temp = String.valueOf(temp) + ch;
            }
            ++i;
        }
        return temp;
    }

    public static String removeDigits(String x) {
        String temp = "";
        int len = x.length();
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (!TCAStringManip.isDigit(ch)) {
                temp = String.valueOf(temp) + ch;
            }
            ++i;
        }
        return temp;
    }

    public static int countUniqueLetters(String x) {
        TCACharacterArray c = TCAStringManip.uniqueLetters(x);
        int uniqueCount = c.getPhrase().length();
        return uniqueCount;
    }

    public static String makePasscode(String allowableSymbols, int n, Random rng, boolean duplicatesAllowed) {
        String temp = "";
        int len = allowableSymbols.length();
        if (duplicatesAllowed) {
            char symbol;
            do {
                int ndx = TCAMath.getRandom(rng, 0, len - 1);
                symbol = allowableSymbols.charAt(ndx);
            } while ((temp = String.valueOf(temp) + symbol).length() < n);
        } else if (n > len) {
            temp = null;
        } else {
            char symbol;
            ArrayList<Character> mySymbols = TCAStringManip.toArrayList(allowableSymbols);
            do {
                int ndx = TCAMath.getRandom(rng, 0, mySymbols.size() - 1);
                symbol = mySymbols.remove(ndx).charValue();
            } while ((temp = String.valueOf(temp) + symbol).length() < n);
        }
        return temp;
    }

    public static String encase(String s, char c) {
        String temp = "";
        temp = String.valueOf(temp) + c;
        temp = String.valueOf(temp) + s;
        temp = String.valueOf(temp) + c;
        return temp;
    }

    public static boolean containsOnlyAlphabeticCharacters(String x) {
        boolean isAlphabetic = true;
        x = x.toLowerCase();
        int i = 0;
        while (i < x.length()) {
            char ucode = x.charAt(i);
            if (ucode < 'a' || ucode > 'z') {
                isAlphabetic = false;
                break;
            }
            ++i;
        }
        return isAlphabetic;
    }

    public static boolean isLowerCaseLetter(String ltr) {
        char uc = ltr.charAt(0);
        return uc < 'A' || uc > 'Z';
    }

    public static boolean isUpperCaseLetter(String ltr) {
        char uc = ltr.charAt(0);
        return uc >= 'a' && uc <= 'z';
    }

    public static String toggleCase(String ltr) {
        String temp = ltr;
        if (TCAStringManip.containsOnlyAlphabeticCharacters(ltr)) {
            temp = TCAStringManip.isLowerCaseLetter(temp) ? temp.toUpperCase() : temp.toLowerCase();
        }
        return temp;
    }

    public static String toggleCaseWholeWord(String word) {
        String temp = "";
        int i = 0;
        while (i < word.length()) {
            char ch = word.charAt(i);
            String ltr = String.valueOf(ch);
            ltr = TCAStringManip.toggleCase(ltr);
            temp = String.valueOf(temp) + ltr;
            ++i;
        }
        return temp;
    }

    public static String alternateCase(String w, char caseChoice) {
        String temp = "";
        w = caseChoice == 'l' ? w.toLowerCase() : w.toUpperCase();
        int len = w.length();
        temp = String.valueOf(temp) + w.charAt(0);
        int i = 1;
        while (i < len) {
            String ltr = String.valueOf(w.charAt(i));
            if (i % 2 == 1) {
                ltr = caseChoice == 'l' ? ltr.toUpperCase() : ltr.toLowerCase();
            }
            temp = String.valueOf(temp) + ltr;
            ++i;
        }
        return temp;
    }

    public static String exchangeEndLetters0(String w) {
        String temp = "";
        int len = w.length();
        if (len <= 1) {
            temp = w;
        } else {
            char lastLetter = w.charAt(len - 1);
            char firstLetter = w.charAt(0);
            temp = String.valueOf(temp) + lastLetter;
            int i = 1;
            while (i < len - 1) {
                String ltr = String.valueOf(w.charAt(i));
                temp = String.valueOf(temp) + ltr;
                ++i;
            }
            temp = String.valueOf(temp) + firstLetter;
            temp = TCAStringManip.matchCaseOfWord(w, temp);
        }
        return temp;
    }

    public static String exchangeEndLetters(String w) {
        String temp = "";
        int len = w.length();
        String sansPunctuation = "";
        if (len <= 1) {
            temp = w;
        } else {
            if (TCAStringManip.containsPunctuation(w)) {
                HashMap<Integer, Character> punctLocn = new HashMap<Integer, Character>();
                ArrayList<Character> c = TCAStringManip.toArrayList(w);
                int i = 0;
                while (i < len) {
                    char ch = c.get(i).charValue();
                    if (TCAStringManip.isPunctuation(ch)) {
                        punctLocn.put(i, Character.valueOf(ch));
                    } else {
                        sansPunctuation = String.valueOf(sansPunctuation) + ch;
                    }
                    ++i;
                }
                char firstLetter = sansPunctuation.charAt(0);
                char lastLetter = sansPunctuation.charAt(sansPunctuation.length() - 1);
                String guts = TCAStringManip.exchangeEndLetters(sansPunctuation);
                int i2 = 0;
                while (i2 < len) {
                    if (punctLocn.containsKey(i2)) {
                        char symbol = ((Character)punctLocn.get(i2)).charValue();
                        guts = TCAStringManip.insertCharInto(guts, symbol, i2);
                    }
                    ++i2;
                }
                temp = guts;
            } else {
                char lastLetter = w.charAt(len - 1);
                char firstLetter = w.charAt(0);
                temp = String.valueOf(temp) + lastLetter;
                int i = 1;
                while (i < len - 1) {
                    String ltr = String.valueOf(w.charAt(i));
                    temp = String.valueOf(temp) + ltr;
                    ++i;
                }
                temp = String.valueOf(temp) + firstLetter;
            }
            temp = TCAStringManip.matchCaseOfWord(w, temp);
        }
        return temp;
    }

    public static String matchCaseOfWord(String w, String t) {
        String temp = "";
        if (w.length() == t.length()) {
            int ndx = 0;
            while (ndx < w.length()) {
                char ch = w.charAt(ndx);
                char cht = t.charAt(ndx);
                String ltr = String.valueOf(ch);
                String tltr = String.valueOf(cht);
                tltr = TCAStringManip.isLowerCaseLetter(ltr) ? tltr.toLowerCase() : tltr.toUpperCase();
                temp = String.valueOf(temp) + tltr;
                ++ndx;
            }
        } else {
            temp = t;
        }
        return temp;
    }

    public static ArrayList<String> toArrayListOfStrings(String p, char delimiter) {
        String[] s = p.split(String.valueOf(delimiter));
        ArrayList<String> a = new ArrayList<String>();
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String x = stringArray[n2];
            if (x.length() >= 1) {
                a.add(x);
            }
            ++n2;
        }
        return a;
    }

    public static String exchangeEndLettersInPhrase(String p) {
        String temp = "";
        ArrayList<String> a = TCAStringManip.toArrayListOfStrings(p, ' ');
        for (String x : a) {
            String y = TCAStringManip.exchangeEndLetters(x);
            temp = String.valueOf(temp) + " ";
            temp = String.valueOf(temp) + y;
        }
        temp = temp.trim();
        return temp;
    }

    public static String alphabetizeWordsInPhrase(String p) {
        String temp = "";
        ArrayList<String> a = TCAStringManip.toArrayListOfStrings(p, ' ');
        for (String x : a) {
            String y = TCAStringManip.alphabetize(x);
            temp = String.valueOf(temp) + " ";
            temp = String.valueOf(temp) + y;
        }
        temp = temp.trim();
        return temp;
    }

    public static String reverseWordsInPhrase(String p) {
        String temp = "";
        ArrayList<String> a = TCAStringManip.toArrayListOfStrings(p, ' ');
        for (String x : a) {
            String y = TCAStringManip.reverse(x);
            temp = String.valueOf(temp) + " ";
            temp = String.valueOf(temp) + y;
        }
        temp = temp.trim();
        return temp;
    }

    public static String disemvowelWordsInPhrase(String p) {
        String temp = "";
        ArrayList<String> a = TCAStringManip.toArrayListOfStrings(p, ' ');
        for (String x : a) {
            String y = TCAStringManip.removeChars(x, "aeiouyAEIOUY");
            temp = String.valueOf(temp) + " ";
            temp = String.valueOf(temp) + y;
        }
        temp = TCAStringManip.stripExtraSpacesFrom(temp);
        temp = temp.trim();
        return temp;
    }

    public static String stripDoubleCharFrom(String str, char ch) {
        String temp = str;
        String ltr = String.valueOf(ch);
        String doubleLetter = String.valueOf(ltr) + ltr;
        temp = temp.replaceAll(doubleLetter, ltr);
        return temp;
    }

    public static String stripExtraSpacesFrom(String str) {
        String temp = str;
        String doubleSpace = "  ";
        while (temp.indexOf(doubleSpace) >= 0) {
            temp = temp.replaceAll(doubleSpace, " ");
        }
        temp = temp.trim();
        return temp;
    }

    public static String echoLetters(String w) {
        String temp = "";
        temp = TCAStringManip.interweave(w, w, 1);
        char lastLetter = w.charAt(w.length() - 1);
        temp = String.valueOf(temp) + lastLetter;
        temp = TCAStringManip.stripExtraSpacesFrom(temp);
        return temp;
    }

    public static boolean isVowel(char ch) {
        boolean status = false;
        String vowels = "aeiouyAEIOUY";
        int posn = vowels.indexOf(ch);
        if (posn >= 0) {
            status = true;
        }
        return status;
    }

    public static boolean isConsonant(char ch) {
        boolean status = false;
        if (!TCAStringManip.isVowel(ch)) {
            status = true;
        }
        return status;
    }

    public static int findFirstVowelPosition(String x) {
        int len = x.length();
        int posn = -1;
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (TCAStringManip.isVowel(ch)) {
                posn = i;
                break;
            }
            ++i;
        }
        return posn;
    }

    public static int findFirstConsonantPosition(String x) {
        int len = x.length();
        int posn = -1;
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (TCAStringManip.isConsonant(ch)) {
                posn = i;
                break;
            }
            ++i;
        }
        return posn;
    }

    public static String findSprefix(String x) {
        String temp = "";
        int fvowelPosn = TCAStringManip.findFirstVowelPosition(x);
        temp = x.substring(0, fvowelPosn);
        return temp;
    }

    public static String spoonerizePhrase(String phrase) {
        String temp = "";
        String adjustedPhrase = TCAStringManip.removePunctuation(phrase);
        adjustedPhrase = TCAStringManip.removeDigits(adjustedPhrase);
        adjustedPhrase = TCAStringManip.stripExtraSpacesFrom(adjustedPhrase);
        ArrayList<String> wordBank = TCAStringManip.toArrayListOfStrings(adjustedPhrase, ' ');
        int numWords = wordBank.size();
        HashMap<Object, Object> pair = new HashMap();
        if (numWords <= 1) {
            temp = phrase;
        } else if (numWords == 2) {
            String w1 = wordBank.get(0);
            String w2 = wordBank.get(1);
            pair = TCAStringManip.spoonerize(w1, w2);
            temp = String.valueOf((String)pair.get(w1)) + " " + (String)pair.get(w2);
        } else if (numWords > 2) {
            int mode2Ndx = 0;
            int mode1Ndx = 0;
            int maxLength = 0;
            int i = 0;
            while (i < wordBank.size()) {
                String myWord = wordBank.get(i);
                int myWordLength = myWord.length();
                if (myWordLength > maxLength) {
                    mode1Ndx = i;
                    maxLength = myWordLength;
                }
                ++i;
            }
            int runnerUpMaxLength = 0;
            int i2 = 0;
            while (i2 < wordBank.size()) {
                String myWord = wordBank.get(i2);
                int myWordLength = myWord.length();
                if (myWordLength > runnerUpMaxLength && i2 != mode1Ndx) {
                    mode2Ndx = i2;
                    runnerUpMaxLength = myWordLength;
                }
                ++i2;
            }
            String w1 = wordBank.get(mode1Ndx);
            String w2 = wordBank.get(mode2Ndx);
            pair = TCAStringManip.spoonerize(w1, w2);
            wordBank.set(mode1Ndx, (String)pair.get(w1));
            wordBank.set(mode2Ndx, (String)pair.get(w2));
            for (String x : wordBank) {
                temp = String.valueOf(temp) + x + " ";
            }
            temp = TCAStringManip.stripExtraSpacesFrom(temp);
        }
        return temp;
    }

    public static HashMap<String, String> spoonerize(String a, String b) {
        String bSprefix;
        a = a.toLowerCase();
        b = b.toLowerCase();
        HashMap<String, String> pairs = new HashMap<String, String>();
        if (a.length() <= 2 || b.length() <= 2) {
            return pairs;
        }
        String aSprefix = TCAStringManip.findSprefix(a);
        if (aSprefix.equals(bSprefix = TCAStringManip.findSprefix(b))) {
            return pairs;
        }
        if (aSprefix.equals("q")) {
            aSprefix = "qu";
        }
        if (bSprefix.equals("q")) {
            bSprefix = "qu";
        }
        if (aSprefix.length() >= 1 && bSprefix.length() >= 1) {
            int firstVowelPosnA = TCAStringManip.findFirstVowelPosition(a);
            int firstVowelPosnB = TCAStringManip.findFirstVowelPosition(b);
            String x = String.valueOf(bSprefix) + a.substring(firstVowelPosnA);
            String y = String.valueOf(aSprefix) + b.substring(firstVowelPosnB);
            if (aSprefix.equals("qu")) {
                x = String.valueOf(bSprefix) + a.substring(firstVowelPosnA + 1);
                y = String.valueOf(aSprefix) + b.substring(firstVowelPosnB);
            }
            if (bSprefix.equals("qu")) {
                x = String.valueOf(bSprefix) + a.substring(firstVowelPosnA);
                y = String.valueOf(aSprefix) + b.substring(firstVowelPosnB + 1);
            }
            pairs.put(a, x);
            pairs.put(b, y);
        }
        if (aSprefix.length() * bSprefix.length() == 0) {
            String firstConsonantA;
            int firstConsonantPosnA = TCAStringManip.findFirstConsonantPosition(a);
            int firstConsonantPosnB = TCAStringManip.findFirstConsonantPosition(b);
            if (firstConsonantPosnA < 0) {
                if (firstConsonantPosnB < 0) {
                    return pairs;
                }
                String x = String.valueOf(bSprefix) + a;
                String y = b.substring(firstConsonantPosnB + 1);
                pairs.put(a, x);
                pairs.put(b, y);
                return pairs;
            }
            if (firstConsonantPosnB < 0) {
                if (firstConsonantPosnA < 0) {
                    return pairs;
                }
                String x = a.substring(firstConsonantPosnA + 1);
                String y = String.valueOf(aSprefix) + b;
                pairs.put(a, x);
                pairs.put(b, y);
                return pairs;
            }
            if (aSprefix.length() == 0 && bSprefix.length() > 0) {
                firstConsonantA = "" + a.charAt(firstConsonantPosnA);
                if (firstConsonantA.equals("x")) {
                    return null;
                }
                if (bSprefix.length() == 1) {
                    String x = a.replaceFirst(firstConsonantA, bSprefix);
                    String y = b.replaceFirst(bSprefix, firstConsonantA);
                    if (!firstConsonantA.equals("x")) {
                        pairs.put(a, x);
                        pairs.put(b, y);
                    }
                } else {
                    String x = String.valueOf(bSprefix) + a;
                    String y = b.replaceFirst(bSprefix, firstConsonantA);
                    pairs.put(a, x);
                    pairs.put(b, y);
                }
            }
            if (aSprefix.length() > 0 && bSprefix.length() == 0) {
                String firstConsonantB = "" + b.charAt(firstConsonantPosnB);
                if (firstConsonantB.equals("x")) {
                    return null;
                }
                String x = a.replaceFirst(aSprefix, firstConsonantB);
                String y = String.valueOf(aSprefix) + b;
                pairs.put(a, x);
                pairs.put(b, y);
            }
            if (aSprefix.length() == 0 && bSprefix.length() == 0) {
                firstConsonantA = "" + a.charAt(firstConsonantPosnA);
                String firstConsonantB = "" + b.charAt(firstConsonantPosnB);
                String x = String.valueOf(firstConsonantB) + a;
                String y = String.valueOf(firstConsonantA) + b;
                pairs.put(a, x);
                pairs.put(b, y);
            }
        }
        return pairs;
    }

    public static String randomReplacement(String w, String r, int seed, boolean forcedChange) {
        String temp = "";
        w = w.toLowerCase();
        int len = w.length();
        int repLen = r.length();
        if (repLen <= 1) {
            forcedChange = false;
        }
        Random rng = seed == 0 ? new Random() : new Random(seed);
        char replacementLtr = '-';
        int i = 0;
        while (i < len) {
            boolean swapped = false;
            char ch = w.charAt(i);
            if (r.indexOf(ch) >= 0) {
                int ndx;
                replacementLtr = ch;
                if (forcedChange) {
                    while (replacementLtr == ch) {
                        ndx = TCAMath.getRandom(rng, 0, repLen - 1);
                        replacementLtr = r.charAt(ndx);
                    }
                } else {
                    ndx = TCAMath.getRandom(rng, 0, repLen - 1);
                    replacementLtr = r.charAt(ndx);
                }
                swapped = true;
            }
            temp = swapped ? String.valueOf(temp) + replacementLtr : String.valueOf(temp) + ch;
            ++i;
        }
        return temp;
    }

    public static HashMap<String, String> symbolsReplacementHashMap(String k, String v) {
        int vLen;
        HashMap<String, String> map = new HashMap<String, String>();
        int kLen = k.length();
        if (kLen != (vLen = v.length()) || kLen * vLen == 0) {
            map = null;
        } else {
            int i = 0;
            while (i < kLen) {
                String key = String.valueOf(k.charAt(i));
                String value = String.valueOf(v.charAt(i));
                map.put(key, value);
                ++i;
            }
        }
        return map;
    }

    public static HashMap<String, String> stringReplacementHashMap(ArrayList<String> k, ArrayList<String> v) {
        int vLen;
        HashMap<String, String> map = new HashMap<String, String>();
        int kLen = k.size();
        if (kLen != (vLen = v.size()) || kLen * vLen == 0) {
            map = null;
        } else {
            int i = 0;
            while (i < kLen) {
                String key = k.get(i);
                String value = v.get(i);
                map.put(key, value);
                ++i;
            }
        }
        return map;
    }

    public static String toMorseCode(String w, String delimiter) {
        String temp = "";
        ArrayList<String> mc = TCAArchive.getMorseCodeConversions();
        ArrayList<String> myKeys = new ArrayList<String>();
        ArrayList<String> myValues = new ArrayList<String>();
        for (String s : mc) {
            String[] info = s.split(";");
            String k = info[0];
            String v = info[1];
            myKeys.add(k);
            myValues.add(v);
        }
        HashMap<String, String> morseMap = TCAStringManip.stringReplacementHashMap(myKeys, myValues);
        w = w.toUpperCase();
        w = TCAStringManip.removePunctuation(w);
        w = TCAStringManip.interweave(w, delimiter, 1);
        temp = TCAStringManip.hashMapStringReplacement(w, myKeys, morseMap);
        return temp;
    }

    public static String fromMorseCode(String m, String delimiter) {
        String temp = "";
        ArrayList<String> mc = TCAArchive.getMorseCodeConversions();
        ArrayList<String> myKeys = new ArrayList<String>();
        ArrayList<String> myValues = new ArrayList<String>();
        for (String s : mc) {
            String[] info = s.split(";");
            String k = info[1];
            String v = info[0];
            myKeys.add(k);
            myValues.add(v);
        }
        HashMap<String, String> morseMap = TCAStringManip.stringReplacementHashMap(myKeys, myValues);
        temp = TCAStringManip.hashMapStringReplacement(m, myKeys, morseMap, delimiter);
        return temp;
    }

    public static String hashMapSymbolReplacement(String word, HashMap<String, String> map) {
        String temp = "";
        int len = word.length();
        String replacement = "";
        int i = 0;
        while (i < len) {
            boolean swapped = false;
            String symbol = String.valueOf(word.charAt(i));
            if (map.containsKey(symbol)) {
                swapped = true;
                replacement = map.get(symbol);
            }
            temp = swapped ? String.valueOf(temp) + replacement : String.valueOf(temp) + symbol;
            ++i;
        }
        return temp;
    }

    public static String hashMapStringReplacement(String word, ArrayList<String> keys, HashMap<String, String> map) {
        String temp = word;
        int numKeys = keys.size();
        int i = 0;
        while (i < numKeys) {
            String key = keys.get(i);
            if (map.containsKey(key)) {
                String value = map.get(key);
                temp = temp.replaceAll(key, value);
            }
            ++i;
        }
        return temp;
    }

    public static String hashMapStringReplacement(String word, ArrayList<String> keys, HashMap<String, String> map, String delimiter) {
        String[] a;
        String temp = "";
        String[] stringArray = a = word.split(delimiter);
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (map.containsKey(s)) {
                String value = map.get(s);
                temp = String.valueOf(temp) + value;
            }
            ++n2;
        }
        return temp;
    }

    public static String iWord(String w) {
        String temp = w;
        char firstChar = w.charAt(0);
        if (firstChar == 'i' || firstChar == 'I') {
            String ending = temp.substring(1);
            if (ending.length() > 0) {
                ending = TCAStringManip.toSentenceCase(ending);
                temp = "i" + ending;
            } else {
                temp = "i";
            }
        }
        return temp;
    }

    public static String xWord(String w, String firstLetter) {
        String temp = w;
        char firstChar = w.charAt(0);
        char trigger = firstLetter.charAt(0);
        String ucTrigger = String.valueOf(trigger).toUpperCase();
        String lcTrigger = String.valueOf(trigger).toLowerCase();
        String prefix = String.valueOf(trigger).toLowerCase();
        if (firstChar == lcTrigger.charAt(0) || firstChar == ucTrigger.charAt(0)) {
            String ending = temp.substring(1);
            if (ending.length() > 0) {
                ending = TCAStringManip.toSentenceCase(ending);
                temp = String.valueOf(prefix) + ending;
            } else {
                temp = prefix;
            }
        }
        return temp;
    }

    public static String toSentenceCase0(String w) {
        String temp = "";
        if (w.length() == 1) {
            temp = w.toUpperCase();
        } else {
            String firstLetter = String.valueOf(w.charAt(0)).toUpperCase();
            temp = String.valueOf(firstLetter) + w.substring(1).toLowerCase();
        }
        return temp;
    }

    public static String toSentenceCase(String w) {
        String temp = "";
        if (w.length() == 1) {
            temp = w.toUpperCase();
        } else {
            w = w.toLowerCase();
            String firstLetter = String.valueOf(w.charAt(0)).toUpperCase();
            temp = String.valueOf(firstLetter) + w.substring(1);
        }
        return temp;
    }

    public static String toPhonePadNumber(String w) {
        String temp = w.toLowerCase();
        String alphabet = TCAStringManip.makeString(65, 26);
        alphabet = alphabet.toLowerCase();
        String digits = "22233344455566677778889999";
        HashMap<String, String> map = TCAStringManip.symbolsReplacementHashMap(alphabet, digits);
        String phoneNumber = "";
        int len = w.length();
        int i = 0;
        while (i < len) {
            String d = String.valueOf(temp.charAt(i));
            if (map.containsKey(d)) {
                phoneNumber = String.valueOf(phoneNumber) + map.get(d);
            } else if (TCAStringManip.isDigit(temp.charAt(i))) {
                phoneNumber = String.valueOf(phoneNumber) + d;
            }
            ++i;
        }
        return phoneNumber;
    }

    public static String processText(String x, int n) {
        String temp = "";
        ArrayList<String> myData = new ArrayList<String>();
        String entry = "";
        StringTokenizer tokenizer = new StringTokenizer(x, " ");
        while (tokenizer.hasMoreTokens()) {
            entry = tokenizer.nextToken();
            myData.add(entry);
        }
        int len = myData.size();
        int i = 0;
        while (i < len) {
            String clip = "";
            while (clip.length() < n && i < len) {
                clip = String.valueOf(clip) + (String)myData.get(i) + " ";
                ++i;
            }
            --i;
            temp = String.valueOf(temp) + clip + "\n";
            ++i;
        }
        return temp;
    }

    public static int getCharCodeSum(String x) {
        int sum = 0;
        int len = x.length();
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            sum += ch;
            ++i;
        }
        return sum;
    }

    public static double avgCharCode(String x) {
        int sum = TCAStringManip.getCharCodeSum(x);
        double avg = (double)sum / (double)x.length();
        return avg;
    }

    public static String scramble(String x) {
        TCACharacterArray tca = new TCACharacterArray(x);
        TCADoubleArray uni = tca.getUnicodes();
        uni.randomizeOrder();
        TCACharacterArray tca2 = new TCACharacterArray(uni);
        String jumbled = tca2.getPhrase();
        return jumbled;
    }

    public static String scramble(String x, int seed) {
        TCACharacterArray tca = new TCACharacterArray(x);
        TCADoubleArray uni = tca.getUnicodes();
        uni.randomizeOrder(seed);
        TCACharacterArray tca2 = new TCACharacterArray(uni);
        String jumbled = tca2.getPhrase();
        return jumbled;
    }

    public static String scramble(String x, int seed, int leftInset, int rightInset) {
        String y = TCAStringManip.removePunctuation(x);
        int len = (y = TCAStringManip.removeSpaces(y)).length();
        if (leftInset + rightInset >= len) {
            return x;
        }
        int first = leftInset;
        int last = len - rightInset;
        String prefix = y.substring(0, first);
        String suffix = y.substring(last);
        String guts = y.substring(first, last);
        int gutsLen = guts.length();
        String jumbledGuts = guts;
        int seed2 = seed;
        if (gutsLen > 1) {
            int tries = 0;
            while (jumbledGuts.equals(guts) && tries <= 5) {
                TCACharacterArray tca = new TCACharacterArray(guts);
                TCADoubleArray uni = tca.getUnicodes();
                uni.randomizeOrder(seed2);
                TCACharacterArray tca2 = new TCACharacterArray(uni);
                jumbledGuts = tca2.getPhrase();
                System.out.println("jumbledGuts = " + jumbledGuts);
                ++seed2;
                ++tries;
            }
        }
        String jumbled = String.valueOf(prefix) + jumbledGuts + suffix;
        jumbled = TCAStringManip.matchPunctuation(x, jumbled);
        jumbled = TCAStringManip.matchCaseOfWord(x, jumbled);
        return jumbled;
    }

    public static String scrambleWordsInPhrase(String p, int seed, int leftInset, int rightInset) {
        String temp = "";
        ArrayList<String> a = TCAStringManip.toArrayListOfStrings(p, ' ');
        for (String x : a) {
            String y = TCAStringManip.scramble(x, seed, leftInset, rightInset);
            System.out.println(y);
            temp = String.valueOf(temp) + " ";
            temp = String.valueOf(temp) + y;
        }
        temp = temp.trim();
        return temp;
    }

    public static String matchPunctuation(String orig, String x) {
        String temp = x;
        int len = orig.length();
        int i = 0;
        while (i < len) {
            char ch = orig.charAt(i);
            if (TCAStringManip.isPunctuationOrSpace(ch)) {
                if (i >= temp.length()) {
                    temp = String.valueOf(temp) + ch;
                } else {
                    char ch2 = temp.charAt(i);
                    if (ch != ch2) {
                        temp = TCAStringManip.insertCharInto(temp, ch, i);
                    }
                }
            }
            ++i;
        }
        return temp;
    }

    public static String redistributeToUniformLength(String x, int len) {
        String temp = TCAStringManip.removeSpaces(x);
        temp = TCAStringManip.removePunctuation(temp);
        temp = temp.toLowerCase();
        int n = temp.length();
        String uniform = "";
        int count = 0;
        int i = 0;
        while (i < n) {
            char ch = temp.charAt(i);
            if (++count <= len) {
                uniform = String.valueOf(uniform) + ch;
            } else {
                uniform = String.valueOf(uniform) + " ";
                uniform = String.valueOf(uniform) + ch;
                count = 1;
            }
            ++i;
        }
        return uniform;
    }

    public static String redistributeWordLengths(String x, int seed, int min, int max) {
        double sD;
        double mean;
        String temp = TCAStringManip.removeSpaces(x);
        temp = TCAStringManip.removePunctuation(temp);
        temp = temp.toLowerCase();
        int n = temp.length();
        String y = "";
        int count = 0;
        Random rng = seed == 0 ? new Random() : new Random(seed);
        int len = TCAMath.getGausseanDist(rng, mean = (double)(min + max) / 2.0, sD = (double)((max - min) / 6));
        if (len <= 0) {
            len = 1;
        }
        int i = 0;
        while (i < n) {
            char ch = temp.charAt(i);
            if (++count <= len) {
                y = String.valueOf(y) + ch;
            } else {
                y = String.valueOf(y) + " ";
                y = String.valueOf(y) + ch;
                count = 1;
                len = TCAMath.getGausseanDist(rng, 1, 15);
            }
            ++i;
        }
        return y;
    }

    public static double calculateAverageWordLength(ArrayList<String> a) {
        double avg = 0.0;
        int num = a.size();
        double sum = 0.0;
        System.out.println("num = " + num);
        for (String s : a) {
            int wordSize = s.length();
            sum += (double)wordSize;
        }
        avg = sum / (double)num;
        return avg;
    }

    public static String addRandomPunctuation0(ArrayList<String> a, Random rng) {
        String story = "";
        int n = a.size();
        System.out.println("n = " + n);
        String firstWord = a.get(0);
        firstWord = TCAStringManip.toSentenceCase(firstWord);
        story = String.valueOf(story) + firstWord;
        int current = 1;
        while (current < n) {
            String nextCapWord;
            int i;
            int x = TCAMath.getGausseanDist(rng, 2, 15);
            if (current + x < n - 2) {
                i = current;
                while (i < current + x) {
                    story = String.valueOf(story) + " " + a.get(i);
                    ++i;
                }
                char punct = TCAStringManip.randomCharacterFrom(rng, "........!?");
                story = String.valueOf(story) + punct;
                story = String.valueOf(story) + "  ";
                nextCapWord = TCAStringManip.toSentenceCase(a.get(i));
                story = String.valueOf(story) + nextCapWord;
                story = String.valueOf(story) + " ";
                current = i + 1;
                System.out.println("current = " + current);
                continue;
            }
            nextCapWord = TCAStringManip.toSentenceCase(a.get(current));
            story = String.valueOf(story) + nextCapWord;
            story = String.valueOf(story) + " ";
            i = ++current;
            while (i < n) {
                story = String.valueOf(story) + " " + a.get(i);
                ++i;
            }
            char punct = TCAStringManip.randomCharacterFrom(rng, "........!?");
            story = String.valueOf(story) + punct;
        }
        return story;
    }

    public static String addRandomPunctuation(ArrayList<String> a, Random rng) {
        String story = "";
        int n = a.size();
        int lastIndex = n - 1;
        System.out.println("n = " + n);
        String firstWord = a.get(0);
        String lastWord = a.get(lastIndex);
        System.out.println("Last word = " + lastWord + ", at index " + lastIndex);
        firstWord = TCAStringManip.toSentenceCase(firstWord);
        System.out.println("firstWord = " + firstWord);
        story = String.valueOf(story) + firstWord;
        story = String.valueOf(story) + " ";
        int current = 1;
        while (current < n) {
            String nextCapWord;
            String nextWord;
            int i;
            int x = TCAMath.getGausseanDist(rng, 2, 15);
            if (current + x < n - 2) {
                i = current;
                while (i < current + x) {
                    nextWord = a.get(i);
                    if (nextWord.equals(lastWord)) {
                        story = String.valueOf(story) + " " + nextWord + ".";
                        System.out.println("End of story....");
                        return story;
                    }
                    story = String.valueOf(story) + " " + a.get(i);
                    if (i < current + x - 2) {
                        int commaPlace = TCAMath.getRandom(rng, 0, 20);
                        char punct = TCAStringManip.randomCharacterFrom(rng, ",,,,,,,,;;:");
                        String myXtraPunct = punct + " ";
                        if (commaPlace < 4) {
                            story = String.valueOf(story) + myXtraPunct;
                        }
                    }
                    ++i;
                }
                char punct = TCAStringManip.randomCharacterFrom(rng, "........!?");
                story = String.valueOf(story) + punct;
                story = String.valueOf(story) + "  ";
                nextCapWord = TCAStringManip.toSentenceCase(a.get(i));
                story = String.valueOf(story) + nextCapWord;
                story = String.valueOf(story) + " ";
                current = i + 1;
                if (current < n - 1) continue;
                System.out.println("Here at end...add some punctuation...");
                punct = TCAStringManip.randomCharacterFrom(rng, "........!?");
                story = String.valueOf(story) + punct;
                break;
            }
            System.out.println("Phasing out, current = " + current);
            nextCapWord = TCAStringManip.toSentenceCase(a.get(current));
            System.out.println("nextCapWord = " + nextCapWord);
            story = String.valueOf(story) + nextCapWord;
            story = String.valueOf(story) + " ";
            i = ++current;
            while (i < n) {
                nextWord = a.get(i);
                if (nextWord.equals(lastWord)) {
                    story = String.valueOf(story) + " " + nextWord + ".";
                    System.out.println("End of story....");
                    return story;
                }
                story = String.valueOf(story) + " " + nextWord;
                ++i;
            }
            char punct = TCAStringManip.randomCharacterFrom(rng, "........!?");
            story = String.valueOf(story) + punct;
        }
        return story;
    }

    public static char randomCharacterFrom(Random rng, String x) {
        int len = x.length();
        int r = TCAMath.getRandom(rng, 0, len - 1);
        char ch = x.charAt(r);
        return ch;
    }

    public static String removeEveryXthLetterAfterFirst(String w, int x) {
        int first;
        String temp = "";
        int len = w.length();
        temp = String.valueOf(temp) + w.charAt(0);
        int i = first = x;
        while (i < len) {
            temp = String.valueOf(temp) + w.charAt(i);
            i += x;
        }
        return temp;
    }

    public static String removeXthLetterAfterFirstInPhrase(String p, int x) {
        String temp = "";
        ArrayList<Character> a = TCAStringManip.toArrayListCharacters(p);
        int len = a.size();
        int i = --x;
        while (i < len) {
            char ch = a.get(i).charValue();
            if (TCAStringManip.isPunctuationOrSpace(ch)) {
                ++i;
            } else {
                a.remove(i);
            }
            len = a.size();
            i += x;
        }
        System.out.println("now...");
        System.out.println(a);
        for (char c : a) {
            temp = String.valueOf(temp) + c;
        }
        return temp;
    }

    public static ArrayList<Character> toArrayListCharacters(String p) {
        ArrayList<Character> a = new ArrayList<Character>();
        int len = p.length();
        int i = 0;
        while (i < len) {
            char c = p.charAt(i);
            a.add(Character.valueOf(c));
            ++i;
        }
        return a;
    }

    public static String modulusLetterSelectionFromPhrase(String p, int modulus) {
        String x = TCAStringManip.removePunctuation(p);
        TCARing myRing = new TCARing(x, modulus);
        String y = myRing.emptyRingByModulusToString();
        return y;
    }

    public static TCADat findLongestContiguousConstantSubstring(String x) {
        TCADat d = null;
        int len = x.length();
        char ch0 = x.charAt(0);
        int charCount = 1;
        int charCountMax = 1;
        int ndx = 0;
        String myGroup = TCAStringManip.makeString(ch0, 1);
        int myIndex = ndx;
        d = new TCADat(myGroup, myIndex);
        int i = 1;
        while (i < len) {
            char chn = x.charAt(i);
            if (chn != ch0) {
                if (charCount >= charCountMax) {
                    charCountMax = charCount;
                    myGroup = TCAStringManip.charString(ch0, charCount);
                    myIndex = ndx;
                    d = new TCADat(myGroup, myIndex);
                }
                ch0 = chn;
                ndx = i;
                charCount = 0;
            }
            ++charCount;
            ++i;
        }
        if (charCount >= charCountMax) {
            charCountMax = charCount;
            myGroup = TCAStringManip.charString(ch0, charCount);
            myIndex = ndx;
            d = new TCADat(myGroup, myIndex);
        }
        return d;
    }

    public static String randomDigitString(Random r, int min, int max, int n) {
        String temp = "";
        int i = 1;
        while (i <= n) {
            int val = TCAMath.getRandom(r, min, max);
            String s = String.valueOf(val);
            temp = String.valueOf(temp) + s;
            ++i;
        }
        return temp;
    }

    public static TCADoubleArray digitsToDoubleArray(String x) {
        ArrayList<Double> myDigits = new ArrayList<Double>();
        int len = x.length();
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            if (TCAStringManip.isDigit(ch)) {
                double val = TCAMath.toDouble(ch);
                myDigits.add(val);
            }
            ++i;
        }
        TCADoubleArray d = new TCADoubleArray(myDigits);
        return d;
    }

    public static char lowCase(char c) {
        char temp = c;
        if (temp >= 'A' && temp <= 'Z') {
            temp = (char)(temp + 32);
        }
        return temp;
    }

    public static char upCase(char c) {
        char temp = c;
        if (temp >= 'a' && temp <= 'z') {
            temp = (char)(temp - 32);
        }
        return temp;
    }

    public static String replacePrefix(String S, char ch, String replacement) {
        String temp = "";
        String prefix = "";
        int len = S.length();
        int ndx = 0;
        while (S.charAt(ndx) == ch) {
            prefix = String.valueOf(prefix) + replacement;
            ++ndx;
        }
        temp = String.valueOf(prefix) + S.substring(ndx, len);
        return temp;
    }

    public static String scramble0(String s) {
        int ndx;
        String temp = "";
        Random rng = new Random();
        do {
            int n = s.length();
            ndx = rng.nextInt(n);
            temp = String.valueOf(temp) + String.valueOf(s.charAt(ndx));
        } while ((s = String.valueOf(s.substring(0, ndx)) + s.substring(ndx + 1)).length() != 0);
        return temp;
    }

    public static String scramble2(String s, Random rng) {
        int ndx;
        String temp = "";
        do {
            int n = s.length();
            ndx = rng.nextInt(n);
            temp = String.valueOf(temp) + String.valueOf(s.charAt(ndx));
        } while ((s = String.valueOf(s.substring(0, ndx)) + s.substring(ndx + 1)).length() != 0);
        return temp;
    }

    public static String scrambleRecursive(String s) {
        String temp = "";
        Random rng = new Random();
        if (s.length() != 0) {
            int n = s.length();
            int ndx = rng.nextInt(n);
            temp = String.valueOf(temp) + String.valueOf(s.charAt(ndx));
            s = String.valueOf(s.substring(0, ndx)) + s.substring(ndx + 1);
            return String.valueOf(temp) + TCAStringManip.scrambleRecursive(s);
        }
        return temp;
    }

    public static String scrambleRecursive2(String s, Random rng) {
        String temp = "";
        if (s.length() != 0) {
            int n = s.length();
            int ndx = rng.nextInt(n);
            temp = String.valueOf(temp) + String.valueOf(s.charAt(ndx));
            s = String.valueOf(s.substring(0, ndx)) + s.substring(ndx + 1);
            return String.valueOf(temp) + TCAStringManip.scrambleRecursive(s);
        }
        return temp;
    }
}

