/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

class TCARing {
    private TCALink head;
    private int numLinks;
    private int modulus;
    private ArrayList<Object> lineup;
    private Object lastElement;
    private int origPlacement;

    public TCARing() {
        this.numLinks = 10;
        this.modulus = 1;
        this.createRing();
        this.lineup = this.listRingByModulus();
        this.lastElement = this.lineup.get(this.lineup.size() - 1);
        this.origPlacement = this.findOriginalPositionFromHead(this.lastElement);
    }

    public TCARing(int n, int m) {
        this.numLinks = n;
        this.modulus = m;
        this.createRing();
        this.lineup = this.listRingByModulus();
        this.lastElement = this.lineup.get(this.lineup.size() - 1);
        this.origPlacement = this.findOriginalPositionFromHead(this.lastElement);
    }

    public TCARing(String w) {
        this.numLinks = w.length();
        this.modulus = 1;
        this.createRing(w);
        this.lineup = this.listRingByModulus();
        this.lastElement = this.lineup.get(this.lineup.size() - 1);
        this.origPlacement = this.findOriginalPositionFromHead(this.lastElement);
    }

    public TCARing(TCARing orig) {
        this.numLinks = orig.getNumLinks();
        this.modulus = orig.getModulus();
        this.copyRing(orig);
        this.lineup = orig.getLineup();
        this.lastElement = orig.getLastElementValue();
    }

    public TCARing(ArrayList<String> data, int mod) {
        this.numLinks = data.size();
        this.modulus = mod;
        this.createRing(data);
        this.lineup = this.listRingByModulus();
        this.lastElement = this.lineup.get(this.lineup.size() - 1);
        this.origPlacement = this.findOriginalPositionFromHead(this.lastElement);
    }

    public TCARing(String w, int mod) {
        this.numLinks = w.length();
        this.modulus = mod;
        this.createRing(w);
        this.lineup = this.listRingByModulus();
        this.lastElement = this.lineup.get(this.lineup.size() - 1);
        this.origPlacement = this.findOriginalPositionFromHead(this.lastElement);
    }

    public void createRing() {
        TCALink last = this.head = new TCALink(String.valueOf(this.numLinks));
        int i = this.numLinks - 1;
        while (i >= 1) {
            TCALink myLink;
            this.head = myLink = new TCALink(String.valueOf(i), this.head);
            --i;
        }
        TCALink first = this.head;
        last.setNextLink(first);
    }

    public void copyRing(TCARing orig) {
        TCALink current;
        orig.repositionHead(0);
        Object myFirstValue = orig.getHead().getData();
        TCALink z = new TCALink(myFirstValue);
        TCALink first = current = (this.head = new TCALink(z.getData()));
        int i = 2;
        while (i <= this.numLinks) {
            orig.increment();
            TCALink v = orig.getHead();
            Object val = v.getData();
            TCALink myLink = new TCALink(val);
            current.setNextLink(myLink);
            this.head = current = myLink;
            ++i;
        }
        TCALink last = this.head;
        last.setNextLink(first);
        this.repositionHead(1);
        orig.increment();
    }

    public void createReverseRing(String w) {
        TCALink last = this.head = new TCALink(Character.valueOf(w.charAt(0)));
        int i = 1;
        while (i <= this.numLinks - 1) {
            TCALink myLink;
            this.head = myLink = new TCALink(Character.valueOf(w.charAt(i)), this.head);
            ++i;
        }
        TCALink first = this.head;
        last.setNextLink(first);
        this.head = first;
    }

    public void createRing(String w) {
        TCALink last = this.head = new TCALink(Character.valueOf(w.charAt(this.numLinks - 1)));
        int i = this.numLinks - 2;
        while (i >= 0) {
            TCALink myLink;
            this.head = myLink = new TCALink(Character.valueOf(w.charAt(i)), this.head);
            --i;
        }
        TCALink first = this.head;
        last.setNextLink(first);
        this.head = first;
    }

    public void createRing(ArrayList<String> data) {
        TCALink last = this.head = new TCALink(data.get(this.numLinks - 1));
        int i = this.numLinks - 2;
        while (i >= 0) {
            TCALink myLink;
            this.head = myLink = new TCALink(data.get(i), this.head);
            --i;
        }
        TCALink first = this.head;
        last.setNextLink(first);
        this.head = first;
    }

    public void print() {
        System.out.println("Number of Links: " + this.numLinks + ", modulus: " + this.modulus);
        TCALink myLink = this.head;
        int i = 1;
        while (i <= this.numLinks) {
            this.printLink(myLink);
            myLink = myLink.getNextLink();
            ++i;
        }
        System.out.println("Lineup by modulus:");
        System.out.println(this.lineup);
        System.out.println("Last element value: " + this.lastElement);
        System.out.println("Original placement from head: " + this.origPlacement);
    }

    public void printLink(TCALink myLink) {
        System.out.println(String.valueOf(myLink.getAddress()) + " contains " + myLink.getData() + " and points to " + myLink.getNextLink().getAddress());
    }

    public int getModulus() {
        return this.modulus;
    }

    public TCALink getHead() {
        return this.head;
    }

    public int getNumLinks() {
        return this.numLinks;
    }

    public Object getLastElementValue() {
        return this.lastElement;
    }

    public int getOriginalPlacement() {
        return this.origPlacement;
    }

    public void setModulus(int v) {
        this.modulus = v;
        this.lineup = this.listRingByModulus();
        this.lastElement = this.lineup.get(this.lineup.size() - 1);
        this.origPlacement = this.findOriginalPositionFromHead(this.lastElement);
    }

    public void setHead(int steps) {
        this.repositionHead(steps);
        this.lineup = this.listRingByModulus();
        this.lastElement = this.lineup.get(this.lineup.size() - 1);
        this.origPlacement = this.findOriginalPositionFromHead(this.lastElement);
    }

    public void setHead(TCALink h) {
        this.head = h;
    }

    public ArrayList<Object> getLineup() {
        return this.lineup;
    }

    public void repositionHead(int steps) {
        int i = 1;
        while (i <= steps) {
            TCALink x;
            this.head = x = this.head.getNextLink();
            ++i;
        }
    }

    public void increment() {
        this.repositionHead(1);
    }

    public boolean deleteRingLinkStepsFromHead(int steps) {
        boolean status = false;
        if (steps < 0 || this.numLinks == 0) {
            return false;
        }
        if (steps == 0) {
            TCALink current = this.head;
            TCALink next = this.head.getNextLink();
            this.repositionHead(this.numLinks - 1);
            TCALink former = this.head;
            former.setNextLink(next);
            this.head = next;
            --this.numLinks;
            status = true;
        } else if (!status) {
            this.repositionHead(steps);
            status = this.deleteRingLinkStepsFromHead(0);
        }
        return status;
    }

    public boolean deleteRingLinkModulusFromHead() {
        boolean status = this.deleteRingLinkStepsFromHead(this.modulus);
        return status;
    }

    public int findOriginalPositionFromHead(Object v) {
        int steps = 0;
        TCALink origHead = this.getHead();
        boolean found = false;
        do {
            Object val;
            if ((val = this.getHead().getData()).equals(v)) {
                found = true;
                continue;
            }
            this.increment();
            ++steps;
        } while (!found);
        this.setHead(origHead);
        return steps;
    }

    public ArrayList<Object> emptyRingByModulus() {
        ArrayList<Object> data = new ArrayList<Object>();
        boolean status = true;
        while (this.numLinks > 0 && status) {
            this.repositionHead(this.modulus);
            Object obj = this.head.getData();
            data.add(obj);
            status = this.deleteRingLinkStepsFromHead(0);
        }
        return data;
    }

    public String emptyRingByModulusToString() {
        ArrayList<Object> data = new ArrayList<Object>();
        boolean status = true;
        String temp = "";
        while (this.numLinks > 0 && status) {
            this.repositionHead(this.modulus);
            Object obj = this.head.getData();
            data.add(obj);
            status = this.deleteRingLinkStepsFromHead(0);
        }
        for (Object e : data) {
            char ch = ((Character)e).charValue();
            temp = String.valueOf(temp) + ch;
        }
        return temp;
    }

    public ArrayList<Object> listRingByModulus() {
        ArrayList<Object> data = new ArrayList<Object>();
        TCARing temp = new TCARing(this);
        boolean status = true;
        while (temp.getNumLinks() > 0 && status) {
            temp.repositionHead(this.modulus);
            Object obj = temp.getHead().getData();
            data.add(obj);
            status = temp.deleteRingLinkStepsFromHead(0);
        }
        return data;
    }

    public ArrayList<Object> emptyRingFromHeadInOrder() {
        ArrayList<Object> data = new ArrayList<Object>();
        boolean status = true;
        while (this.numLinks > 0 && status) {
            this.repositionHead(0);
            Object obj = this.head.getData();
            data.add(obj);
            status = this.deleteRingLinkStepsFromHead(0);
        }
        return data;
    }

    public ArrayList<Object> emptyRingFromXInOrder(int x) {
        ArrayList<Object> data = new ArrayList<Object>();
        boolean status = true;
        this.repositionHead(x);
        while (this.numLinks > 0 && status) {
            this.repositionHead(0);
            Object obj = this.head.getData();
            data.add(obj);
            status = this.deleteRingLinkStepsFromHead(0);
        }
        return data;
    }
}

