/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;

class TCARadical {
    private long radicand0;
    private long coeff0;
    private long radicand;
    private long coeff;
    private double value;
    private boolean isExact;
    private DecimalFormat df;

    public TCARadical() {
        this.coeff0 = 1000L;
        this.radicand0 = 1000L;
        this.coeff = 1000L;
        this.radicand = 1000L;
        this.value = (double)this.coeff * Math.sqrt(this.radicand);
        this.df = new DecimalFormat("#,###.###");
        this.isExact = TCAMath.aboutEqual(this.value, Math.rint(this.value));
        this.simplify();
    }

    public TCARadical(long c, long r) {
        this.radicand = this.radicand0 = r;
        this.coeff = this.coeff0 = c;
        this.value = (double)c * Math.sqrt(r);
        this.df = new DecimalFormat("#,###.###");
        this.isExact = TCAMath.aboutEqual(this.value, Math.rint(this.value));
        this.simplify();
    }

    public long getRadicand() {
        return this.radicand;
    }

    public long getCoeff() {
        return this.coeff;
    }

    public String toString() {
        String temp = "";
        if (this.coeff0 != this.coeff) {
            temp = String.valueOf(temp) + String.valueOf(this.coeff0) + '\u00fa' + '\u00fb' + "(" + String.valueOf(this.radicand0) + ")" + " = ";
        }
        temp = String.valueOf(temp) + String.valueOf(this.coeff) + '\u00fa' + '\u00fb' + "(" + String.valueOf(this.radicand) + ")";
        temp = this.isExact ? String.valueOf(temp) + " = " : String.valueOf(temp) + " \u00f7 ";
        String s1 = this.df.format(this.value);
        temp = String.valueOf(temp) + s1;
        return temp;
    }

    public boolean checkExactness() {
        boolean check = Math.abs(this.value - Math.rint(this.value)) < 1.0E-4;
        return check;
    }

    public void simplify() {
        ArrayList<Long> myFactors = TCAMath.factor(this.radicand);
        ArrayList<TCAPower> myPowers = TCARadical.consolodate(myFactors);
        long f = 1L;
        int i = 0;
        while (i < myPowers.size()) {
            TCAPower p = myPowers.get(i);
            long e = p.getExponent();
            if (e > 1L) {
                f = e % 2L == 0L ? (long)((double)f * Math.pow(p.getBase(), e / 2L)) : (long)((double)f * Math.pow(p.getBase(), (e - 1L) / 2L));
            }
            ++i;
        }
        this.coeff *= f;
        this.radicand /= f * f;
        this.value = (double)this.coeff * Math.sqrt(this.radicand);
    }

    public static ArrayList<Long> factor(long x) {
        ArrayList<Long> myFactors = new ArrayList<Long>();
        if (x == 1L) {
            myFactors.add(new Long(1L));
        }
        if (TCARadical.isPrime(x)) {
            if (x != 1L) {
                myFactors.add(new Long(x));
            }
        } else {
            long i = 2L;
            while (i <= x) {
                if (x % i == 0L) {
                    x /= i;
                    myFactors.add(new Long(i));
                    --i;
                }
                ++i;
            }
        }
        return myFactors;
    }

    public static boolean isPrime(long checkNumber) {
        if (checkNumber == 1L) {
            return false;
        }
        if (checkNumber == 2L) {
            return true;
        }
        if (checkNumber % 2L == 0L) {
            return false;
        }
        double root = Math.sqrt(checkNumber);
        double uBound = Math.ceil(root);
        long i = 3L;
        while ((double)i <= uBound) {
            if (checkNumber % i == 0L) {
                return false;
            }
            i += 2L;
        }
        return true;
    }

    public static ArrayList<TCAPower> consolodate(ArrayList<Long> a) {
        TCAPower p;
        ArrayList<TCAPower> t = new ArrayList<TCAPower>();
        int count = 1;
        if (a.isEmpty()) {
            TCAPower p2 = new TCAPower(1, 1);
            t.add(p2);
            return t;
        }
        Long f = a.get(0);
        long b = f;
        int i = 1;
        while (i < a.size()) {
            f = a.get(i);
            long x = f;
            if (x == b) {
                ++count;
            } else {
                p = new TCAPower(b, (long)count);
                t.add(p);
                b = x;
                count = 1;
            }
            ++i;
        }
        p = new TCAPower(b, (long)count);
        t.add(p);
        return t;
    }
}

