/*
 * Decompiled with CFR 0.152.
 */
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

class TCAOrderedPair
extends Point2D.Double {
    private DecimalFormat df;
    private String label;

    public TCAOrderedPair() {
        this.df = new DecimalFormat(".###");
        this.label = null;
    }

    public TCAOrderedPair(double myX, double myY) {
        super(myX, myY);
        this.df = this.createFormatString(3);
    }

    public TCAOrderedPair(double myX, double myY, int dp) {
        super(myX, myY);
        this.df = this.createFormatString(dp);
        this.label = null;
    }

    public TCAOrderedPair(double myX, double myY, String lbl) {
        super(myX, myY);
        this.df = new DecimalFormat(".###");
        this.label = lbl;
    }

    public TCAOrderedPair(TCAOrderedPair p, String lbl) {
        this(p.getX(), p.getY(), lbl);
        this.df = p.df;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String lbl) {
        this.label = lbl;
    }

    public void setX(double myX) {
        this.x = myX;
    }

    public void setY(double myY) {
        this.y = myY;
    }

    public void setDP(int dp) {
        this.df = this.createFormatString(dp);
    }

    public DecimalFormat createFormatString(int dp) {
        String formatString = ".";
        formatString = String.valueOf(formatString) + TCAStringManip.charString('#', dp);
        DecimalFormat myDF = new DecimalFormat(formatString);
        return myDF;
    }

    @Override
    public String toString() {
        String temp = "";
        if (this.label != null) {
            temp = String.valueOf(temp) + this.label;
        }
        temp = String.valueOf(temp) + "(";
        temp = String.valueOf(temp) + this.df.format(this.x) + ", " + this.df.format(this.y) + ")";
        return temp;
    }

    public void translate(double delx, double dely) {
        this.x += delx;
        this.y += dely;
    }

    public void move(double myX, double myY) {
        this.x = myX;
        this.y = myY;
    }

    public double calcSlope(TCAOrderedPair p) {
        double delx = this.x - p.x;
        double dely = this.y - p.y;
        double slope = 0.0;
        try {
            slope = dely / delx;
            String msg = "Slope value: " + slope;
            if (TCAMath.aboutEqual(delx, 0.0)) {
                TCAIO.terminateProgram(msg);
            }
        }
        catch (Exception e) {
            TCAIO.terminateProgram(e);
        }
        return slope;
    }

    public TCARadical exactDistance(TCAOrderedPair p) {
        double distSqrd = this.distanceSq(p);
        long coeff = 1L;
        long radicand = (long)distSqrd;
        TCARadical myR = new TCARadical(coeff, radicand);
        return myR;
    }

    public TCAOrderedPair calcMidPoint(TCAOrderedPair p) {
        double myX = (this.x + p.x) / 2.0;
        double myY = (this.y + p.y) / 2.0;
        TCAOrderedPair midPoint = new TCAOrderedPair(myX, myY);
        return midPoint;
    }

    public TCAOrderedPair calcMidPoint(TCAOrderedPair p, String lbl) {
        double myX = (this.x + p.x) / 2.0;
        double myY = (this.y + p.y) / 2.0;
        TCAOrderedPair midPoint = new TCAOrderedPair(myX, myY, lbl);
        return midPoint;
    }
}

