/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class TCAMatrix {
    protected int r;
    protected int c;
    protected int numEntries;
    protected double[][] myMatrix;

    public TCAMatrix() {
        this.r = 0;
        this.c = 0;
        this.numEntries = 0;
        this.myMatrix = null;
    }

    public TCAMatrix(int n) {
        this.r = n;
        this.c = n;
        this.numEntries = this.r * this.c;
        this.myMatrix = new double[this.r][this.c];
        this.fillDiagonal(1);
    }

    public TCAMatrix(int numRow, int numCol) {
        this.r = numRow;
        this.c = numCol;
        this.numEntries = this.r * this.c;
        this.myMatrix = new double[this.r][this.c];
    }

    public TCAMatrix(int numRow, int numCol, double value) {
        this(numRow, numCol);
        this.fill(value);
    }

    public TCAMatrix(double[][] a) {
        this.r = a.length;
        this.c = a[0].length;
        this.numEntries = this.r * this.c;
        this.myMatrix = new double[this.r][this.c];
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                this.set(i, j, a[i][j]);
                ++j;
            }
            ++i;
        }
    }

    public TCAMatrix(int numRow, int numCol, double[] a) {
        int ndx = 0;
        this.r = numRow;
        this.c = numCol;
        this.numEntries = this.r * this.c;
        this.myMatrix = new double[this.r][this.c];
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                double value = ndx < a.length ? a[ndx] : 0.0;
                this.myMatrix[i][j] = value;
                ++ndx;
                ++j;
            }
            ++i;
        }
    }

    public TCAMatrix(TCADoubleArray a) {
        this(TCAMath.findFactorClosestToSquareRoot(a.getLength()), a.getLength() / TCAMath.findFactorClosestToSquareRoot(a.getLength()), a.getArray());
    }

    public TCAMatrix(int numCol, String digits) {
        this.c = numCol;
        long len = digits.length();
        long modulus = len % (long)numCol;
        this.r = (int)len / numCol;
        if (modulus != 0L) {
            ++this.r;
        }
        this.numEntries = this.r * this.c;
        this.myMatrix = new double[this.r][this.c];
        int ndx = 0;
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                double value = (long)ndx < len ? Double.parseDouble(digits.substring(ndx, ndx + 1)) : -1.0;
                this.myMatrix[i][j] = value;
                ++ndx;
                ++j;
            }
            ++i;
        }
    }

    public TCAMatrix(TCAMatrix matrix) {
        this.r = matrix.getRows();
        this.c = matrix.getColumns();
        this.numEntries = this.r * this.c;
        this.myMatrix = new double[this.r][this.c];
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                this.myMatrix[i][j] = matrix.getValue(i, j);
                ++j;
            }
            ++i;
        }
    }

    public int getRows() {
        return this.r;
    }

    public int getColumns() {
        return this.c;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public double get(int row, int colm) {
        return this.myMatrix[row][colm];
    }

    public double[][] getMyMatrix() {
        return this.myMatrix;
    }

    public double get(Posn p) {
        int myR = p.getRow();
        int myC = p.getColm();
        return this.myMatrix[myR][myC];
    }

    public double[] getColumnAt(int column) {
        double[] values = new double[this.r];
        int i = 0;
        while (i < this.r) {
            values[i] = this.myMatrix[i][column];
            ++i;
        }
        return values;
    }

    public double[] getRowAt(int row) {
        double[] values = new double[this.c];
        int j = 0;
        while (j < this.c) {
            values[j] = this.myMatrix[row][j];
            ++j;
        }
        return values;
    }

    public boolean equals(TCAMatrix m2) {
        boolean theSame = true;
        TCAMatrix m1 = this;
        if (m1.r == m2.r && m1.c == m2.c) {
            int i = 0;
            while (i < m1.r) {
                int j = 0;
                while (j < m1.c) {
                    if (m1.get(i, j) != m2.get(i, j)) {
                        theSame = false;
                        break;
                    }
                    ++j;
                }
                if (theSame) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            theSame = false;
        }
        return theSame;
    }

    public void fill(double x) {
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                this.myMatrix[i][j] = x;
                ++j;
            }
            ++i;
        }
    }

    public void replaceValues(double x0, double xf) {
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                double val = this.get(i, j);
                if (TCAMath.aboutEqual(val, x0)) {
                    this.myMatrix[i][j] = xf;
                }
                ++j;
            }
            ++i;
        }
    }

    public void print() {
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                System.out.print(String.valueOf(this.myMatrix[i][j]) + "  ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public void writeToFile(String fileName, String delimitter) throws IOException {
        System.out.println("printing...");
        FileWriter writer = new FileWriter(fileName);
        PrintWriter out = new PrintWriter(writer);
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                String value = Double.toString(this.myMatrix[i][j]);
                out.print(value);
                out.print(delimitter);
                ++j;
            }
            out.println();
            ++i;
        }
        writer.close();
    }

    public void set(int row, int colm, double value) {
        this.myMatrix[row][colm] = value;
    }

    public double getValue(int row, int colm) {
        return this.myMatrix[row][colm];
    }

    public void fillDiagonal(int value) {
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                this.myMatrix[i][j] = i == j ? (double)value : 0.0;
                ++j;
            }
            ++i;
        }
    }

    public TCAMatrix copy() {
        int r = this.r;
        int c = this.c;
        TCAMatrix myCopy = new TCAMatrix(r, c);
        int i = 0;
        while (i < r) {
            int j = 0;
            while (j < c) {
                myCopy.set(i, j, this.getValue(i, j));
                ++j;
            }
            ++i;
        }
        return myCopy;
    }

    public TCAMatrix add(TCAMatrix addend2) {
        TCAMatrix temp = null;
        if (this.r == addend2.r && this.c == addend2.c) {
            temp = new TCAMatrix(addend2.r, addend2.c);
            int i = 0;
            while (i < this.r) {
                int j = 0;
                while (j < this.c) {
                    double value = this.get(i, j) + addend2.get(i, j);
                    temp.set(i, j, value);
                    ++j;
                }
                ++i;
            }
        }
        return temp;
    }

    public TCAMatrix scalar(double k) {
        TCAMatrix temp = new TCAMatrix(this.r, this.c);
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                double value = this.get(i, j) * k;
                temp.set(i, j, value);
                ++j;
            }
            ++i;
        }
        return temp;
    }

    public TCAMatrix subtract(TCAMatrix x) {
        TCAMatrix temp = this;
        TCAMatrix result = temp.add(x.scalar(-1.0));
        return result;
    }

    public TCAMatrix multiply(TCAMatrix f2) {
        TCAMatrix f1 = this;
        double sum = 0.0;
        if (this.c == f2.r) {
            TCAMatrix product = new TCAMatrix(f1.r, f2.c);
            int i = 0;
            while (i < product.r) {
                int j = 0;
                while (j < product.c) {
                    sum = 0.0;
                    int k = 0;
                    while (k < f1.c) {
                        sum += f1.get(i, k) * f2.get(k, j);
                        ++k;
                    }
                    product.set(i, j, sum);
                    ++j;
                }
                ++i;
            }
            return product;
        }
        return null;
    }

    public TCAMatrix kbMultiply(TCAMatrix f2) {
        if (this.c == f2.getRows()) {
            TCAMatrix product = new TCAMatrix(this.r, f2.getColumns());
            int i = 0;
            while (i < product.getRows()) {
                double[] rowValues = this.getRowAt(i);
                int j = 0;
                while (j < product.getColumns()) {
                    double[] columnValues = f2.getColumnAt(j);
                    double sum = 0.0;
                    int k = 0;
                    while (k < columnValues.length) {
                        sum += rowValues[k] * columnValues[k];
                        ++k;
                    }
                    product.set(i, j, sum);
                    ++j;
                }
                ++i;
            }
            return product;
        }
        return null;
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                s = String.valueOf(s) + this.myMatrix[i][j] + "  ";
                ++j;
            }
            s = String.valueOf(s) + "\n";
            ++i;
        }
        return s;
    }

    public double calcDeterminant() {
        double[][] arr = this.myMatrix;
        double result = 0.0;
        if (arr.length == 1) {
            result = arr[0][0];
            return result;
        }
        if (arr.length == 2) {
            result = arr[0][0] * arr[1][1] - arr[0][1] * arr[1][0];
            return result;
        }
        int i = 0;
        while (i < arr[0].length) {
            double[][] temp = new double[arr.length - 1][arr[0].length - 1];
            int j = 1;
            while (j < arr.length) {
                int k = 0;
                while (k < arr[0].length) {
                    if (k < i) {
                        temp[j - 1][k] = arr[j][k];
                    } else if (k > i) {
                        temp[j - 1][k - 1] = arr[j][k];
                    }
                    ++k;
                }
                TCAMatrix t = new TCAMatrix(temp);
                result += arr[0][i] * Math.pow(-1.0, i) * t.calcDeterminant();
                ++j;
            }
            ++i;
        }
        return result;
    }

    public double getMaxAt(char x, int n) {
        int zbasedN = n - 1;
        double max = 666.0;
        if ((x = Character.toLowerCase(x)) == 'c') {
            if (zbasedN < 0 || zbasedN > this.c - 1) {
                System.out.println("invalid input...");
                System.exit(0);
            } else {
                TCADoubleArray myColm = new TCADoubleArray(this.getColumnAt(zbasedN));
                max = myColm.getHigh();
            }
        } else if (x == 'r') {
            if (zbasedN < 0 || zbasedN > this.r - 1) {
                System.out.println("invalid input...");
                System.exit(0);
            } else {
                TCADoubleArray myRow = new TCADoubleArray(this.getRowAt(zbasedN));
                max = myRow.getHigh();
            }
        } else {
            System.out.println("invalid input...");
            System.exit(0);
        }
        return max;
    }

    public int lookupRowForColumnCWithValueV(int myc, double v) {
        int targettedRow = -1;
        int row = 0;
        while (row < this.r) {
            double[] vector = this.getRowAt(row);
            if (vector[myc - 1] == v) {
                targettedRow = row;
                break;
            }
            ++row;
        }
        return targettedRow;
    }

    public TCAMatrix transpose() {
        TCAMatrix temp = new TCAMatrix();
        temp.r = this.c;
        temp.c = this.r;
        temp.numEntries = this.numEntries;
        temp.myMatrix = new double[temp.r][temp.c];
        int row = 0;
        while (row < this.r) {
            int colm = 0;
            while (colm < this.c) {
                temp.set(colm, row, this.get(row, colm));
                ++colm;
            }
            ++row;
        }
        return temp;
    }

    public TCAMatrix addBorder(char ch) {
        int myR = this.r + 2;
        int myC = this.c + 2;
        char uCode = ch;
        TCAMatrix temp = new TCAMatrix(myR, myC);
        int topRow = 0;
        int bottomRow = myR - 1;
        int leftColm = 0;
        int rightColm = myC - 1;
        int i = 0;
        while (i < myR) {
            int j = 0;
            while (j < myC) {
                if (i == topRow) {
                    temp.set(i, j, uCode);
                } else if (i == bottomRow) {
                    temp.set(i, j, uCode);
                } else if (j == leftColm) {
                    temp.set(i, j, uCode);
                } else if (j == rightColm) {
                    temp.set(i, j, uCode);
                } else {
                    temp.set(i, j, this.get(i - 1, j - 1));
                }
                ++j;
            }
            ++i;
        }
        return temp;
    }

    public TCAMatrix addBorder(int[] uc) {
        int myR = this.r + 2;
        int myC = this.c + 2;
        TCAMatrix temp = new TCAMatrix(myR, myC);
        int topRow = 0;
        int bottomRow = myR - 1;
        int leftColm = 0;
        int rightColm = myC - 1;
        int i = 0;
        while (i < myR) {
            int j = 0;
            while (j < myC) {
                if (i == topRow) {
                    if (j == 0) {
                        temp.set(i, j, (char)uc[0]);
                    } else if (j == rightColm) {
                        temp.set(i, j, (char)uc[2]);
                    } else {
                        temp.set(i, j, (char)uc[1]);
                    }
                } else if (i == bottomRow) {
                    if (j == 0) {
                        temp.set(i, j, (char)uc[6]);
                    } else if (j == rightColm) {
                        temp.set(i, j, (char)uc[4]);
                    } else {
                        temp.set(i, j, (char)uc[5]);
                    }
                } else if (j == leftColm) {
                    if (i == 0) {
                        temp.set(i, j, (char)uc[0]);
                    } else if (i == bottomRow) {
                        temp.set(i, j, (char)uc[6]);
                    } else {
                        temp.set(i, j, (char)uc[7]);
                    }
                } else if (j == rightColm) {
                    if (i == 0) {
                        temp.set(i, j, (char)uc[2]);
                    } else if (i == bottomRow) {
                        temp.set(i, j, (char)uc[4]);
                    } else {
                        temp.set(i, j, (char)uc[3]);
                    }
                } else {
                    temp.set(i, j, this.get(i - 1, j - 1));
                }
                ++j;
            }
            ++i;
        }
        return temp;
    }

    public TCAMatrix addBorder() {
        int[] uc = new int[]{201, 205, 187, 186, 188, 205, 200, 186};
        int myR = this.r + 2;
        int myC = this.c + 2;
        TCAMatrix temp = new TCAMatrix(myR, myC);
        int topRow = 0;
        int bottomRow = myR - 1;
        int leftColm = 0;
        int rightColm = myC - 1;
        int i = 0;
        while (i < myR) {
            int j = 0;
            while (j < myC) {
                if (i == topRow) {
                    if (j == 0) {
                        temp.set(i, j, (char)uc[0]);
                    } else if (j == rightColm) {
                        temp.set(i, j, (char)uc[2]);
                    } else {
                        temp.set(i, j, (char)uc[1]);
                    }
                } else if (i == bottomRow) {
                    if (j == 0) {
                        temp.set(i, j, (char)uc[6]);
                    } else if (j == rightColm) {
                        temp.set(i, j, (char)uc[4]);
                    } else {
                        temp.set(i, j, (char)uc[5]);
                    }
                } else if (j == leftColm) {
                    if (i == 0) {
                        temp.set(i, j, (char)uc[0]);
                    } else if (i == bottomRow) {
                        temp.set(i, j, (char)uc[6]);
                    } else {
                        temp.set(i, j, (char)uc[7]);
                    }
                } else if (j == rightColm) {
                    if (i == 0) {
                        temp.set(i, j, (char)uc[2]);
                    } else if (i == bottomRow) {
                        temp.set(i, j, (char)uc[4]);
                    } else {
                        temp.set(i, j, (char)uc[3]);
                    }
                } else {
                    temp.set(i, j, this.get(i - 1, j - 1));
                }
                ++j;
            }
            ++i;
        }
        return temp;
    }

    public TCAMatrix addBorder(String x) {
        TCACharacterArray c = new TCACharacterArray(x);
        int[] uc = c.getUnicodes().makeRoundedIntArray();
        int len = uc.length;
        int ndx = 0;
        int myR = this.r + 2;
        int myC = this.c + 2;
        TCAMatrix temp = new TCAMatrix(myR, myC);
        int topRow = 0;
        int bottomRow = myR - 1;
        int leftColm = 0;
        int rightColm = myC - 1;
        int j = 0;
        while (j < myC) {
            temp.set(topRow, j, uc[ndx]);
            if (++ndx >= len) {
                ndx = 0;
            }
            ++j;
        }
        int i = 1;
        while (i < myR) {
            temp.set(i, rightColm, uc[ndx]);
            if (++ndx >= len) {
                ndx = 0;
            }
            ++i;
        }
        j = myC - 2;
        while (j >= 0) {
            temp.set(bottomRow, j, uc[ndx]);
            if (++ndx >= len) {
                ndx = 0;
            }
            --j;
        }
        j = 0;
        i = myR - 2;
        while (i > 0) {
            temp.set(i, leftColm, uc[ndx]);
            if (++ndx >= len) {
                ndx = 0;
            }
            --i;
        }
        i = 1;
        while (i < myR - 1) {
            j = 1;
            while (j < myC - 1) {
                temp.set(i, j, this.get(i - 1, j - 1));
                ++j;
            }
            ++i;
        }
        return temp;
    }

    public String summary() {
        String temp = "";
        temp = String.valueOf(temp) + this.r + " by " + this.c + " matrix: " + this.numEntries + " entries";
        return temp;
    }

    public boolean validPosn(Posn p) {
        boolean valid = true;
        if (p.getRow() >= this.r || p.getColm() >= this.c) {
            valid = false;
        }
        if (p.getRow() < 0 || p.getColm() < 0) {
            valid = false;
        }
        return valid;
    }

    public static void sendTextFileOfDigitsToMatrixFile(String origFname, String targetFname, int nCol, char delimiter) throws IOException {
        ArrayList<Object> digits = new ArrayList();
        if (TCAIO.isTextFile(origFname)) {
            digits = TCAIO.readStringData(origFname);
            String myDigits = (String)digits.get(0);
            myDigits = TCAStringManip.removeAllCharsBut(myDigits, "0123456789");
            TCAMatrix m = new TCAMatrix(nCol, myDigits);
            String mySymbol = String.valueOf(delimiter);
            m.writeToFile(targetFname, mySymbol);
        }
    }
}

