/*
 * Decompiled with CFR 0.152.
 */
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class TCAMath {
    public static double logBase10(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    public static double logBaseb(double x, double b) {
        return Math.log(x) / Math.log(b);
    }

    public static boolean aboutEqual(double x, double y) {
        double EPSILON = 1.0E-14;
        boolean aboutEqualTo = false;
        double difference = x * y != 0.0 ? Math.abs(x - y) / Math.max(Math.abs(x), Math.abs(y)) : Math.abs(x - y);
        if (difference <= 1.0E-14) {
            aboutEqualTo = true;
        }
        return aboutEqualTo;
    }

    public static int getRandom(Random r, int min, int max) {
        int x = min + r.nextInt(max - min + 1);
        return x;
    }

    public static double getRandom(Random r, double min, double max) {
        double x = min + (max - min) * r.nextDouble();
        return x;
    }

    public static int getRemainder(long num, int denom) {
        long q = num / (long)denom;
        int remainder = (int)(num - q * (long)denom);
        return remainder;
    }

    public static long getRemainder(long num, double denom) {
        double q = (double)num / denom;
        long r = (long)((double)num - (double)((long)q) * denom);
        return r;
    }

    public static BigInteger factorial(int n) {
        BigInteger tempProduct = BigInteger.ONE;
        int i = n;
        while (i > 1) {
            String myX = String.valueOf(i);
            BigInteger x = new BigInteger(myX);
            tempProduct = tempProduct.multiply(x);
            --i;
        }
        return tempProduct;
    }

    public static long longFactorial(int n) {
        long prod = 1L;
        if (n == 0 || n == 1) {
            return 1L;
        }
        int i = n;
        while (i >= 1) {
            prod *= (long)i;
            --i;
        }
        return prod;
    }

    public static long nCr(int n, int r) {
        return TCAMath.nPr(n, r) / TCAMath.longFactorial(r);
    }

    public static long nCrNonFactorial(int n, int r) {
        double prod = 1.0;
        int myR = r;
        int i = n;
        while (i > n - r) {
            prod *= (double)i;
            if (myR >= 1) {
                prod /= (double)myR;
                --myR;
            }
            --i;
        }
        prod = Math.round(prod);
        return (long)prod;
    }

    public static double doublenCr(int n, int r) {
        double prod = 1.0;
        double myR = r;
        double i = n;
        while (i > (double)(n - r)) {
            prod *= i;
            if (myR >= 1.0) {
                System.out.println("temp prod = " + (prod /= myR));
                myR -= 1.0;
            }
            i -= 1.0;
        }
        prod = TCAMath.roundBigDouble(prod);
        return prod;
    }

    public static long nPr(int n, int r) {
        long prod = 1L;
        int i = n;
        while (i > n - r) {
            prod *= (long)i;
            --i;
        }
        return prod;
    }

    public static BigInteger recursiveFactorial(BigInteger n, BigInteger tempProduct) {
        tempProduct = tempProduct.multiply(n);
        if (n.equals(BigInteger.ZERO)) {
            tempProduct = BigInteger.ONE;
            return tempProduct;
        }
        if ((n = n.subtract(BigInteger.ONE)).compareTo(BigInteger.ONE) >= 0) {
            return TCAMath.recursiveFactorial(n, tempProduct);
        }
        return tempProduct;
    }

    public static ArrayList<Long> factor(long x) {
        ArrayList<Long> myFactors = new ArrayList<Long>();
        if (x == 1L) {
            myFactors.add(new Long(1L));
        }
        if (TCAMath.isPrime(x)) {
            if (x != 1L) {
                myFactors.add(new Long(x));
            }
        } else {
            long i = 2L;
            while (i <= x) {
                if (x % i == 0L) {
                    x /= i;
                    myFactors.add(new Long(i));
                    --i;
                }
                ++i;
            }
        }
        return myFactors;
    }

    /*
     * Unable to fully structure code
     */
    public static ArrayList<Long> factorUsingPrimeList(long x) {
        block6: {
            block5: {
                primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069, 1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151, 1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223, 1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291, 1297, 1301, 1303, 1307, 1319, 1321, 1327, 1361, 1367, 1373, 1381, 1399, 1409, 1423, 1427, 1429, 1433, 1439, 1447, 1451, 1453, 1459, 1471, 1481, 1483, 1487, 1489, 1493, 1499, 1511, 1523, 1531, 1543, 1549, 1553, 1559, 1567, 1571, 1579, 1583, 1597, 1601, 1607, 1609, 1613, 1619, 1621, 1627, 1637, 1657, 1663, 1667, 1669, 1693, 1697, 1699, 1709, 1721, 1723, 1733, 1741, 1747, 1753, 1759, 1777, 1783, 1787, 1789, 1801, 1811, 1823, 1831, 1847, 1861, 1867, 1871, 1873, 1877, 1879, 1889, 1901, 1907, 1913, 1931, 1933, 1949, 1951, 1973, 1979, 1987, 1993, 1997, 1999};
                len = primes.length;
                myFactors = new ArrayList<Long>();
                originalNumber = x;
                if (x != 1L) break block5;
                myFactors.add(new Long(1L));
                break block6;
            }
            i = 0;
            ** GOTO lbl18
            {
                myFactors.add(new Long(primes[i]));
                x /= (long)primes[i];
                do {
                    if (x % (long)primes[i] == 0L) continue block0;
                    ++i;
lbl18:
                    // 2 sources

                } while (i < len && (long)primes[i] <= x);
            }
            i = nextOdd = (long)(primes[len - 1] + 2);
            ** GOTO lbl27
            {
                myFactors.add(new Long(i));
                x /= i;
                do {
                    if (x % i == 0L) continue block2;
                    i += 2L;
lbl27:
                    // 2 sources

                } while (i <= x);
            }
        }
        if (x == originalNumber) {
            myFactors.add(new Long(originalNumber));
        }
        return myFactors;
    }

    public static <E> void viewArrayList(ArrayList<E> list) {
        int i = 0;
        while (i < list.size()) {
            System.out.print(String.valueOf(list.get(i).toString()) + " ");
            ++i;
        }
    }

    public static boolean isPrime(long checkNumber) {
        if (checkNumber == 1L) {
            return false;
        }
        if (checkNumber == 2L) {
            return true;
        }
        if (checkNumber % 2L == 0L) {
            return false;
        }
        double root = Math.sqrt(checkNumber);
        double uBound = Math.ceil(root);
        long i = 3L;
        while ((double)i <= uBound) {
            if (checkNumber % i == 0L) {
                return false;
            }
            i += 2L;
        }
        return true;
    }

    public static double roundBigDouble(double x) {
        return Math.floor(x + 0.5);
    }

    public double linRegression(double x1, double y1, double x2, double y2, double x) {
        double m = (y2 - y1) / (x2 - x1);
        double y = y1 + m * (x - x1);
        return y;
    }

    public static double getFractionalPart(double x) {
        String numString = Double.toString(x);
        String[] a = numString.split("\\.");
        a[1] = "." + a[1];
        double fracPart = Double.parseDouble(a[1]);
        return fracPart;
    }

    public static void sortList(ArrayList<Integer> a) {
        Object[] temp = new Object[a.size()];
        temp = a.toArray();
        Arrays.sort(temp);
        ArrayList<Integer> b = new ArrayList<Integer>();
        Object[] objectArray = temp;
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            String s = obj.toString();
            int x = Integer.parseInt(s);
            b.add(new Integer(x));
            ++n2;
        }
        a.clear();
        for (Integer y : b) {
            a.add(y);
        }
    }

    public static int findFactorClosestToSquareRoot(int n) {
        double sroot = Math.sqrt(n);
        int candidate = 1;
        int i = 1;
        while ((double)i <= sroot) {
            int newFactor;
            if (TCAMath.getRemainder((long)n, i) == 0 && (newFactor = i) > candidate) {
                candidate = newFactor;
            }
            ++i;
        }
        return candidate;
    }

    public static long findFactorClosestToSquareRoot(long n) {
        double sroot = Math.sqrt(n);
        long candidate = 1L;
        long i = 1L;
        while ((double)i <= sroot) {
            long newFactor;
            if (TCAMath.getRemainder(n, i) == 0L && (newFactor = i) > candidate) {
                candidate = newFactor;
            }
            ++i;
        }
        return candidate;
    }

    public static double roundToJ(double v, int dp) {
        double powTen = Math.pow(10.0, dp);
        double temp = v * powTen;
        temp = Math.rint(temp);
        return temp /= powTen;
    }

    public static double roundLikeExcel(double v, int dp) {
        double powTen = Math.pow(10.0, dp);
        double temp = Math.abs(v * powTen);
        temp = Math.rint(temp);
        temp /= powTen;
        if (v < 0.0) {
            temp *= -1.0;
        }
        return temp;
    }

    public static double roundTo(double x, int numPlaces) {
        double myDecimal = Math.abs(x);
        String temp = String.valueOf(myDecimal);
        String[] a = temp.split("\\.");
        String wholePart = a[0];
        String fracPart = a[1];
        int len = fracPart.length();
        fracPart = "." + fracPart;
        double myFracPart = Double.parseDouble(fracPart);
        long powTen = 1L;
        if (len > numPlaces) {
            len = numPlaces;
        }
        int i = 1;
        while (i <= len) {
            myFracPart *= 10.0;
            powTen *= 10L;
            ++i;
        }
        myFracPart = Math.rint(myFracPart);
        double myAnswer = Double.parseDouble(wholePart) + (myFracPart /= (double)powTen);
        if (x < 0.0) {
            myAnswer *= -1.0;
        }
        return myAnswer;
    }

    public static double findFirstPerfectSquareLargerThan(long x) {
        double root = Math.sqrt(x);
        double upperBoundRoot = Math.ceil(root);
        double ps = Math.pow(upperBoundRoot, 2.0);
        return ps;
    }

    public static long findSmallestPrimeLargerThanOrEqualTo(long x) {
        long myPrime = x;
        if (!TCAMath.isPrime(myPrime)) {
            while (!TCAMath.isPrime(++myPrime)) {
            }
        }
        return myPrime;
    }

    public static int calculateGCF(int n1, int n2) {
        int rem = 0;
        int gcf = 0;
        do {
            if ((rem = Math.abs(n1) % Math.abs(n2)) == 0) {
                gcf = n2;
                continue;
            }
            n1 = n2;
            n2 = rem;
        } while (rem != 0);
        return gcf;
    }

    public static long calculateGCF(long n1, long n2) {
        long rem = 0L;
        long gcf = 0L;
        do {
            if ((rem = Math.abs(n1) % Math.abs(n2)) == 0L) {
                gcf = n2;
                continue;
            }
            n1 = n2;
            n2 = rem;
        } while (rem != 0L);
        return gcf;
    }

    public static int countDigits(int n) {
        String ns = TCAMath.convertToString(n);
        return ns.length();
    }

    public static int countUniqueDigits(int n) {
        String ns = TCAMath.convertToString(n);
        int uniqueDigits = TCAStringManip.countUniqueLetters(ns);
        return uniqueDigits;
    }

    public static String convertToString(int n) {
        String ns = Integer.toString(n);
        return ns;
    }

    public static int sortAscending(int x) {
        String ns = TCAMath.convertToString(x);
        String temp = TCAStringManip.alphabetize(ns);
        int sortedX = Integer.parseInt(temp);
        return sortedX;
    }

    public static int sortDescending(int x) {
        String ns = TCAMath.convertToString(x);
        String temp = TCAStringManip.alphabetize(ns);
        temp = TCAStringManip.reverse(temp);
        int sortedX = Integer.parseInt(temp);
        return sortedX;
    }

    public static int prePadWithDigitTillSize(int original, int d, int len) {
        int updatedValue = original;
        int currentLength = TCAMath.countDigits(original);
        int diff = len - currentLength;
        if (diff > 0) {
            String prefix = "";
            int i = 1;
            while (i <= diff) {
                prefix = String.valueOf(prefix) + TCAMath.convertToString(d);
                ++i;
            }
            String paddedNumber = String.valueOf(prefix) + TCAMath.convertToString(original);
            System.out.println("paddedNumberString = " + paddedNumber);
            updatedValue = Integer.parseInt(paddedNumber);
        }
        return updatedValue;
    }

    public static int postPadWithDigitTillSize(int original, int d, int len) {
        int updatedValue = original;
        int currentLength = TCAMath.countDigits(original);
        int diff = len - currentLength;
        if (diff > 0) {
            String suffix = "";
            int i = 1;
            while (i <= diff) {
                suffix = String.valueOf(suffix) + TCAMath.convertToString(d);
                ++i;
            }
            String paddedNumber = String.valueOf(TCAMath.convertToString(original)) + suffix;
            System.out.println("paddedNumberString = " + paddedNumber);
            updatedValue = Integer.parseInt(paddedNumber);
        }
        return updatedValue;
    }

    public static boolean isPrimeByFileCheckFirst(int x) {
        boolean isPrime = false;
        ArrayList<Integer> myPrimes = TCAArchive.getPrimes();
        isPrime = myPrimes.contains(x) ? true : TCAMath.isPrime(x);
        return isPrime;
    }

    public static double[] getGausseanDist(int n, int seed, double mean, double sD) {
        Random rng = seed <= 0 ? new Random() : new Random(seed);
        int num = n * n;
        double[] a = new double[num];
        int i = 0;
        while (i < num) {
            double x;
            a[i] = x = (double)Math.round(mean + sD * rng.nextGaussian());
            ++i;
        }
        return a;
    }

    public static int getGausseanDist(Random rng, double mean, double sD) {
        int val = (int)Math.round(mean + sD * rng.nextGaussian());
        return val;
    }

    public static int getGausseanDist(Random rng, int low, int high) {
        double mean = (double)(low + high) / 2.0;
        double sD = (high - low) / 7;
        int val = (int)Math.round(mean + sD * rng.nextGaussian());
        return val;
    }

    public static double toDouble(char ch) {
        double val;
        if (TCAStringManip.isDigit(ch)) {
            int num = Integer.parseInt(String.valueOf(ch));
            val = num;
        } else {
            char unicode = ch;
            val = unicode;
        }
        return val;
    }
}

