/*
 * Decompiled with CFR 0.152.
 */
public class TCALink {
    private Object data;
    private TCALink nextLink;
    private String address;

    public TCALink(Object d) {
        this.data = d;
        this.nextLink = null;
        this.address = this.obtainAddress();
    }

    public TCALink(Object d, TCALink next) {
        this.data = d;
        this.nextLink = next;
        this.address = this.obtainAddress();
    }

    public Object getData() {
        return this.data;
    }

    public TCALink getNextLink() {
        return this.nextLink;
    }

    public String getAddress() {
        return this.address;
    }

    public void setData(Object x) {
        this.data = x;
    }

    public void setNextLink(TCALink myLink) {
        this.nextLink = myLink;
    }

    public String toString() {
        String info = "";
        info = this.nextLink != null ? String.valueOf(info) + this.address + " contains " + this.data + " points to " + this.nextLink.address : String.valueOf(info) + this.address + " contains " + this.data + " points to null";
        return info;
    }

    public void print() {
        System.out.println(this.data + " points to " + this.nextLink.address);
    }

    public void print(String info) {
        System.out.print(String.valueOf(info) + ":  ");
        System.out.println(this.data + " points to " + this.nextLink.address);
    }

    public String obtainAddress() {
        int x = System.identityHashCode(this);
        String x2 = Integer.toHexString(x);
        String info = "TCALink@" + x2;
        return info;
    }

    public static void showTraversalPathToNullStartingFrom(TCALink x) {
        TCALink current = x;
        System.out.println(current);
        TCALink next = current.getNextLink();
        while (next != null) {
            System.out.println(next);
            next = next.getNextLink();
        }
    }
}

