/*
 * Decompiled with CFR 0.152.
 */
public class TCALeanComplex {
    private double real;
    private double imag;
    private double absVal;

    public TCALeanComplex() {
        this.real = 0.0;
        this.imag = 0.0;
        this.absVal = 0.0;
    }

    public TCALeanComplex(double a, double b) {
        this.real = a;
        this.imag = b;
        this.absVal = this.computeAbsVal();
    }

    public TCALeanComplex(TCALeanComplex z) {
        this(z.real, z.imag);
    }

    public TCALeanComplex findConjugate() {
        TCALeanComplex temp = new TCALeanComplex();
        temp.setReal(this.real);
        temp.setImag(-1.0 * this.imag);
        temp.setAbsVal();
        return temp;
    }

    public TCALeanComplex divide(TCALeanComplex z2) {
        if (z2.absVal > 0.0) {
            TCALeanComplex myConjugate = z2.findConjugate();
            TCALeanComplex temp1 = this.multiply(myConjugate);
            TCALeanComplex temp2 = z2.multiply(myConjugate);
            temp1 = temp1.multiply(1.0 / temp2.real);
            return temp1;
        }
        return null;
    }

    public TCALeanComplex multiply(TCALeanComplex z2) {
        double r = this.real * z2.real - this.imag * z2.imag;
        double im = this.real * z2.imag + this.imag * z2.real;
        TCALeanComplex prod = new TCALeanComplex(r, im);
        return prod;
    }

    public TCALeanComplex multiply(double f) {
        TCALeanComplex temp = this.multiply(new TCALeanComplex(f, 0.0));
        return temp;
    }

    public TCALeanComplex add(TCALeanComplex z2) {
        double r = this.real + z2.real;
        double im = this.imag + z2.imag;
        return new TCALeanComplex(r, im);
    }

    public TCALeanComplex subtract(TCALeanComplex z2) {
        z2 = z2.multiply(new TCALeanComplex(-1.0, 0.0));
        TCALeanComplex diff = this.add(z2);
        return diff;
    }

    public TCALeanComplex square(TCALeanComplex z2) {
        return z2.multiply(z2);
    }

    public TCALeanComplex square() {
        return this.multiply(this);
    }

    public double computeAbsVal() {
        double zabs = Math.sqrt(this.real * this.real + Math.pow(this.imag, 2.0));
        return zabs;
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    public double getAbsVal() {
        return this.absVal;
    }

    public void setReal(double rVal) {
        this.real = rVal;
        this.absVal = this.computeAbsVal();
    }

    public void setImag(double iVal) {
        this.imag = iVal;
        this.absVal = this.computeAbsVal();
    }

    private void setAbsVal() {
        this.absVal = this.computeAbsVal();
    }

    public boolean equals(TCALeanComplex z) {
        return TCAMath.aboutEqual(this.real, z.real) && TCAMath.aboutEqual(this.imag, z.imag);
    }

    public String toString() {
        String temp = "";
        temp = String.valueOf(temp) + this.real;
        temp = String.valueOf(temp) + " + " + this.imag + "i\n";
        return temp;
    }

    public void summarize() {
        System.out.println(this.summary());
    }

    public static void summarize(TCALeanComplex z) {
        if (z != null) {
            System.out.println(z.summary());
            System.out.println();
        } else {
            System.out.println("The requested complex number could not be evaluated\n");
        }
    }

    public String summary() {
        String temp = "";
        temp = String.valueOf(temp) + "\nValue: " + this;
        temp = String.valueOf(temp) + "Absolute Value: " + this.absVal;
        temp = String.valueOf(temp) + "\nMemory Address: " + TCAIO.obtainAddress(this) + "\n";
        return temp;
    }
}

