/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

public class TCAIO {
    private static int windowLength = 80;

    public static void skip(int n) {
        int i = 1;
        while (i <= n) {
            System.out.println();
            ++i;
        }
    }

    public static void center(String phrase) {
        int len = phrase.length();
        int winLen = windowLength;
        int whitespace = winLen - len;
        String padding = TCAStringManip.charString(' ', whitespace / 2);
        String paddedPhrase = String.valueOf(padding) + phrase;
        System.out.println(paddedPhrase);
    }

    public static void center(String phrase, int n) {
        int len = phrase.length();
        int winLen = windowLength;
        int whitespace = winLen - len;
        String padding = TCAStringManip.charString(' ', whitespace / 2);
        String paddedPhrase = String.valueOf(padding) + phrase;
        System.out.print(paddedPhrase);
        TCAIO.skip(n);
    }

    public static void title(String phrase, char c) {
        String horizBorder = TCAStringManip.charString(c, windowLength);
        String currentTime = TCADateTime.getDateTime();
        String currentDirectory = TCAIO.getCurrentDirectory();
        String currentUser = TCAIO.getCurrentUser();
        TCAIO.center(horizBorder, 0);
        TCAIO.center(phrase, 2);
        TCAIO.center(currentTime);
        TCAIO.center(currentDirectory);
        TCAIO.center(currentUser);
        TCAIO.center(horizBorder, 0);
        TCAIO.skip(2);
    }

    public static void boxTitle(String phrase, char c, int n) {
        String currentTime = TCADateTime.getDateTime();
        String currentDirectory = TCAIO.getCurrentDirectory();
        String currentUser = TCAIO.getCurrentUser();
        int offset = 5;
        int len = Math.max(currentTime.length(), phrase.length());
        len = Math.max(len, currentDirectory.length());
        int borderLength = (len = Math.max(len, currentUser.length())) + 2 * offset;
        if (borderLength > 80) {
            borderLength = 80;
        }
        String horizBorder = TCAStringManip.charString(c, borderLength);
        String myPhrase = TCAIO.makeBoxTitleFiller(phrase, c, borderLength);
        String myCurrentTime = TCAIO.makeBoxTitleFiller(currentTime, c, borderLength);
        String myDirectory = TCAIO.makeBoxTitleFiller(currentDirectory, c, borderLength);
        String myCurrentUser = TCAIO.makeBoxTitleFiller(currentUser, c, borderLength);
        TCAIO.center(horizBorder);
        TCAIO.center(myPhrase);
        TCAIO.center(myCurrentTime);
        TCAIO.center(myDirectory);
        TCAIO.center(myCurrentUser);
        TCAIO.center(horizBorder, 0);
        TCAIO.skip(n);
    }

    public static void simpleTitle(String phrase, char c) {
        String horizBorder = TCAStringManip.charString(c, windowLength);
        String currentTime = TCADateTime.getDateTime();
        String currentUser = TCAIO.getCurrentUser();
        TCAIO.center(horizBorder, 0);
        TCAIO.center(phrase, 2);
        TCAIO.center(currentTime);
        TCAIO.center(currentUser);
        TCAIO.center(horizBorder, 0);
        TCAIO.skip(2);
    }

    public static void simpleBoxTitle(String phrase, char c, int n) {
        String currentTime = TCADateTime.getDateTimeStandardFormat();
        String currentUser = TCAIO.getCurrentUser();
        int offset = 5;
        int len = Math.max(currentTime.length(), phrase.length());
        int borderLength = (len = Math.max(len, currentUser.length())) + 2 * offset;
        if (borderLength > 80) {
            borderLength = 80;
        }
        String horizBorder = TCAStringManip.charString(c, borderLength);
        String myPhrase = TCAIO.makeBoxTitleFiller(phrase, c, borderLength);
        String myCurrentTime = TCAIO.makeBoxTitleFiller(currentTime, c, borderLength);
        String myCurrentUser = TCAIO.makeBoxTitleFiller(currentUser, c, borderLength);
        TCAIO.center(horizBorder);
        TCAIO.center(myPhrase);
        TCAIO.center(myCurrentTime);
        TCAIO.center(myCurrentUser);
        TCAIO.center(horizBorder, 0);
        TCAIO.skip(n);
    }

    public static void simpleBoxTitle(String phrase, char c, int n, boolean standardTimeFormat) {
        String currentTime = standardTimeFormat ? TCADateTime.getDateTimeStandardFormat() : TCADateTime.getDateTime();
        String currentUser = TCAIO.getCurrentUser();
        int offset = 5;
        int len = Math.max(currentTime.length(), phrase.length());
        int borderLength = (len = Math.max(len, currentUser.length())) + 2 * offset;
        if (borderLength > 80) {
            borderLength = 80;
        }
        String horizBorder = TCAStringManip.charString(c, borderLength);
        String myPhrase = TCAIO.makeBoxTitleFiller(phrase, c, borderLength);
        String myCurrentTime = TCAIO.makeBoxTitleFiller(currentTime, c, borderLength);
        String myCurrentUser = TCAIO.makeBoxTitleFiller(currentUser, c, borderLength);
        TCAIO.center(horizBorder);
        TCAIO.center(myPhrase);
        TCAIO.center(myCurrentTime);
        TCAIO.center(myCurrentUser);
        TCAIO.center(horizBorder, 0);
        TCAIO.skip(n);
    }

    public static void simpleBoxTitle(String phrase, String s, int n) {
        char c = s.charAt(0);
        String currentTime = TCADateTime.getDateTime();
        String currentUser = TCAIO.getCurrentUser();
        int offset = 5;
        int len = Math.max(currentTime.length(), phrase.length());
        int borderLength = (len = Math.max(len, currentUser.length())) + 2 * offset;
        if (borderLength > 80) {
            borderLength = 80;
        }
        String horizBorder = TCAStringManip.charString(c, borderLength);
        String myPhrase = TCAIO.makeBoxTitleFiller(phrase, c, borderLength);
        String myCurrentTime = TCAIO.makeBoxTitleFiller(currentTime, c, borderLength);
        String myCurrentUser = TCAIO.makeBoxTitleFiller(currentUser, c, borderLength);
        TCAIO.center(horizBorder);
        TCAIO.center(myPhrase);
        TCAIO.center(myCurrentTime);
        TCAIO.center(myCurrentUser);
        TCAIO.center(horizBorder, 0);
        TCAIO.skip(n);
    }

    private static String makePadding(String phrase, int boxLength) {
        int space = boxLength - phrase.length();
        space -= 2;
        String padding = TCAStringManip.charString(' ', space /= 2);
        return padding;
    }

    private static String makeBoxTitleFiller(String s, char c, int length) {
        String padding = TCAIO.makePadding(s, length);
        String temp = String.valueOf(c) + padding + s + padding + c;
        while (temp.length() < length) {
            temp = TCAStringManip.insertCharInto(temp, ' ', 1);
        }
        return temp;
    }

    public static String inputString(String prompt) {
        Scanner input = new Scanner(System.in);
        String myStringInput = "";
        System.out.print(prompt);
        myStringInput = input.nextLine();
        input.close();
        return myStringInput;
    }

    public static int inputInt(String prompt) {
        Scanner input = new Scanner(System.in);
        System.out.print(prompt);
        int myIntInput = 0;
        try {
            myIntInput = input.nextInt();
            input.close();
        }
        catch (Exception e) {
            System.out.println("Possible input error...");
            System.out.println("Program termination");
            input.close();
            System.exit(0);
        }
        return myIntInput;
    }

    public static double inputDouble(String prompt) {
        Scanner input = new Scanner(System.in);
        System.out.print(prompt);
        double myDoubleInput = 0.0;
        try {
            myDoubleInput = input.nextDouble();
            input.close();
        }
        catch (Exception e) {
            System.out.println("Possible input error...");
            System.out.println("Program termination");
            input.close();
            System.exit(0);
        }
        return myDoubleInput;
    }

    public static char inputChar(String str) {
        Scanner input = new Scanner(System.in);
        System.out.print(str);
        char myCharInput = 'x';
        String temp = "";
        try {
            temp = input.nextLine();
            myCharInput = temp.charAt(0);
            input.close();
        }
        catch (Exception e) {
            System.out.println("Possible input error...");
            System.out.println("Program termination");
            input.close();
            System.exit(0);
        }
        return myCharInput;
    }

    public static String guiPromptString(String prompt, String windowTitle) {
        String myString = "";
        boolean acceptable = true;
        do {
            acceptable = true;
            myString = JOptionPane.showInputDialog(prompt);
            if (myString != null) continue;
            JOptionPane.showMessageDialog(null, "Reenter your desired String", windowTitle, 1);
            acceptable = false;
        } while (!acceptable);
        return myString;
    }

    public static char guiPromptChar(String prompt, String windowTitle) {
        String myString = "";
        boolean acceptable = true;
        do {
            acceptable = true;
            myString = JOptionPane.showInputDialog(prompt);
            if (myString != null) continue;
            JOptionPane.showMessageDialog(null, "Reenter your desired String", windowTitle, 1);
            acceptable = false;
        } while (!acceptable);
        char myChar = myString.charAt(0);
        return myChar;
    }

    public static int guiPromptInt(String prompt, String windowTitle) {
        int x = 1;
        boolean acceptable = true;
        do {
            acceptable = true;
            String temp = JOptionPane.showInputDialog(prompt);
            if (temp == null) {
                JOptionPane.showMessageDialog(null, "Program Termination! Have a Good Day!", windowTitle, 1);
                System.exit(0);
            }
            try {
                x = Integer.parseInt(temp);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Please enter an integer!", windowTitle, 2);
                acceptable = false;
            }
        } while (!acceptable);
        return x;
    }

    public static long guiPromptLong(String prompt, String windowTitle) {
        long x = 1L;
        boolean acceptable = true;
        do {
            acceptable = true;
            String temp = JOptionPane.showInputDialog(prompt);
            if (temp == null) {
                JOptionPane.showMessageDialog(null, "Program Termination! Have a Good Day!", windowTitle, 1);
                System.exit(0);
            }
            try {
                x = Long.parseLong(temp);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Please enter an integer!", windowTitle, 2);
                acceptable = false;
            }
        } while (!acceptable);
        return x;
    }

    public static double guiPromptDouble(String prompt, String windowTitle) {
        double x = 1.0;
        boolean acceptable = true;
        do {
            acceptable = true;
            String temp = JOptionPane.showInputDialog(prompt);
            if (temp == null) {
                JOptionPane.showMessageDialog(null, "Program Termination! Have a Good Day!", windowTitle, 1);
                System.exit(0);
            }
            try {
                x = Double.parseDouble(temp);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Please enter a real number!", windowTitle, 2);
                acceptable = false;
            }
        } while (!acceptable);
        return x;
    }

    public static BigInteger guiPromptBigInteger(String prompt, String windowTitle) {
        BigInteger x = BigInteger.ONE;
        boolean acceptable = true;
        do {
            acceptable = true;
            String temp = JOptionPane.showInputDialog(prompt);
            if (temp == null) {
                JOptionPane.showMessageDialog(null, "Program Termination! Have a Good Day!", windowTitle, 1);
                System.exit(0);
            }
            try {
                x = new BigInteger(temp);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Please enter an integer!", windowTitle, 2);
                acceptable = false;
            }
        } while (!acceptable);
        return x;
    }

    public static void delay(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void pause(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        try {
            System.in.read();
        }
        catch (Exception e) {
            return;
        }
    }

    public static void pause() {
        try {
            System.in.read();
        }
        catch (Exception e) {
            return;
        }
    }

    public static boolean notFinished() {
        boolean temp = false;
        boolean ok = true;
        do {
            ok = true;
            char choice = TCAIO.inputChar("Another run? (y/n) ");
            choice = Character.toLowerCase(choice);
            switch (choice) {
                case 'y': {
                    temp = true;
                    break;
                }
                case 'n': {
                    temp = false;
                    break;
                }
                default: {
                    ok = false;
                }
            }
        } while (!ok);
        return temp;
    }

    public static boolean notDone(String windowTitle) {
        boolean notDone = false;
        int answer = JOptionPane.showConfirmDialog(null, "Another run?", windowTitle, 0);
        if (answer == 0) {
            notDone = true;
        } else {
            JOptionPane.showMessageDialog(null, "Program Termination! Have a Good Day!", windowTitle, 1);
            System.out.println("\n");
            System.exit(0);
        }
        return notDone;
    }

    public static void scrollOutput(String header, String information, Color colr) {
        int numColms = 45;
        JTextArea resultArea = new JTextArea(information);
        Font myFont = new Font("monospaced", 1, 15);
        resultArea.setFont(myFont);
        resultArea.setBackground(colr);
        resultArea.setEditable(false);
        resultArea.setRows(25);
        resultArea.setColumns(numColms);
        resultArea.setTabSize(3);
        JScrollPane pane = new JScrollPane(resultArea);
        JFrame myFrame = new JFrame(header);
        myFrame.setSize(480, 620);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = myFrame.getBounds();
        int ul_x = (screenDim.width - frameDim.width) / 2;
        int ul_y = (screenDim.height - frameDim.height) / 2;
        myFrame.setLocation(ul_x, ul_y);
        JPanel myPanel = new JPanel();
        myPanel.add(pane);
        Image titleIcon = new ImageIcon("tca_logo1.jpg").getImage();
        myFrame.setIconImage(titleIcon);
        myFrame.setContentPane(myPanel);
        myFrame.setVisible(true);
        myFrame.setDefaultCloseOperation(3);
    }

    public static String getCurrentDirectory() {
        String currentDir = System.getProperty("user.dir");
        return currentDir;
    }

    public static String getCurrentUser() {
        String username = System.getProperty("user.name");
        return username;
    }

    public static boolean isTextFile(String fname) {
        return fname.endsWith(".txt");
    }

    public static boolean isFileOfType(String fname, String xtension) {
        return fname.endsWith(xtension = "." + xtension);
    }

    public static String getExtension(String f) {
        String ext = "";
        int lastPeriodIndex = f.lastIndexOf(46);
        int beginningExtnIndex = lastPeriodIndex + 1;
        ext = f.substring(beginningExtnIndex);
        return ext;
    }

    public static String getFilePath() {
        JFileChooser chooser = new JFileChooser();
        File selectedFile = null;
        try {
            if (chooser.showOpenDialog(null) == 0) {
                selectedFile = chooser.getSelectedFile();
                System.out.println(selectedFile);
            } else {
                JOptionPane.showMessageDialog(null, "Program Termination! Have a Good Day!", "TCAIO.getFilePath()", 1);
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println("Exception = " + e);
            System.exit(0);
        }
        String myFile = selectedFile.toString();
        return myFile;
    }

    public static String getFilePath(String currentDirectory) {
        File myDir = new File(currentDirectory);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("txt", "txt");
        JFileChooser chooser = new JFileChooser(myDir);
        chooser.setFileFilter(filter);
        File selectedFile = null;
        try {
            if (chooser.showOpenDialog(null) == 0) {
                selectedFile = chooser.getSelectedFile();
                System.out.println(selectedFile);
            } else {
                JOptionPane.showMessageDialog(null, "Program Termination! Have a Good Day!", "TCAIO.getFilePath()", 1);
                System.exit(0);
            }
        }
        catch (Exception e) {
            System.out.println("Exception = " + e);
            System.exit(0);
        }
        String myFile = selectedFile.toString();
        return myFile;
    }

    public static String getFileNameFromPath(String path) {
        String fileName = "";
        int ndx = path.lastIndexOf(92);
        fileName = path.substring(ndx + 1);
        return fileName;
    }

    public static ArrayList<Double> readRealData(String fileName) {
        ArrayList<Double> myData = new ArrayList<Double>();
        try {
            String entry;
            FileReader inFile = new FileReader(fileName);
            BufferedReader inStream = new BufferedReader(inFile);
            while ((entry = inStream.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(entry, "\t");
                while (tokenizer.hasMoreTokens()) {
                    entry = tokenizer.nextToken();
                    double value = Double.parseDouble(entry);
                    myData.add(new Double(value));
                }
            }
            inStream.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception e = " + e, "TCAIO.readReadData()", 1);
            System.exit(0);
        }
        return myData;
    }

    public static ArrayList<Double> readRealData(String fileName, String delimitter) {
        ArrayList<Double> myData = new ArrayList<Double>();
        try {
            String entry;
            FileReader inFile = new FileReader(fileName);
            BufferedReader inStream = new BufferedReader(inFile);
            while ((entry = inStream.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(entry, delimitter);
                while (tokenizer.hasMoreTokens()) {
                    entry = tokenizer.nextToken();
                    try {
                        double value = Double.parseDouble(entry);
                        myData.add(new Double(value));
                    }
                    catch (Exception e) {
                        System.out.println("Illegal entry: '" + entry + "' was excluded");
                    }
                }
            }
            inStream.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception e = " + e, "TCAIO.readStringData()", 1);
            System.exit(0);
        }
        return myData;
    }

    public static ArrayList<Integer> readIntegerData(String fileName, String delimitter) {
        ArrayList<Integer> myData = new ArrayList<Integer>();
        try {
            String entry;
            FileReader inFile = new FileReader(fileName);
            BufferedReader inStream = new BufferedReader(inFile);
            while ((entry = inStream.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(entry, delimitter);
                while (tokenizer.hasMoreTokens()) {
                    entry = tokenizer.nextToken();
                    try {
                        int value = Integer.parseInt(entry);
                        myData.add(new Integer(value));
                    }
                    catch (Exception e) {
                        System.out.println("Illegal entry: '" + entry + "' was excluded");
                    }
                }
            }
            inStream.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception e = " + e, "TCAIO.readIntegerData()", 1);
            System.exit(0);
        }
        return myData;
    }

    public static ArrayList<String> readStringData(String fileName) {
        ArrayList<String> myData = new ArrayList<String>();
        try {
            String entry;
            FileReader inFile = new FileReader(fileName);
            BufferedReader inStream = new BufferedReader(inFile);
            while ((entry = inStream.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(entry, "\t");
                while (tokenizer.hasMoreTokens()) {
                    entry = tokenizer.nextToken();
                    myData.add(entry);
                }
            }
            inStream.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception e = " + e, "TCAIO.readReadData()", 1);
            System.exit(0);
        }
        return myData;
    }

    public static void saveStringArray(String[] a, String fn) {
        try {
            FileWriter writer = new FileWriter(fn);
            PrintWriter out = new PrintWriter(writer);
            String[] stringArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                out.println(entry);
                ++n2;
            }
            writer.close();
        }
        catch (Exception e) {
            System.out.println("There was a problem writing your array to file " + fn);
            System.exit(0);
        }
    }

    public static void saveArrayListOfStrings(ArrayList<String> a, String fn) {
        try {
            FileWriter writer = new FileWriter(fn);
            PrintWriter out = new PrintWriter(writer);
            for (String entry : a) {
                out.println(entry);
            }
            writer.close();
        }
        catch (Exception e) {
            System.out.println("There was a problem writing your array to file " + fn);
            System.exit(0);
        }
    }

    public static String obtainAddress(double prim) {
        int x = System.identityHashCode(prim);
        String x2 = Integer.toHexString(x);
        String info = "@" + x2;
        return info;
    }

    public static String obtainAddress(int prim) {
        int x = System.identityHashCode(prim);
        String x2 = Integer.toHexString(x);
        String info = "@" + x2;
        return info;
    }

    public static String obtainAddress(char prim) {
        int x = System.identityHashCode(Character.valueOf(prim));
        String x2 = Integer.toHexString(x);
        String info = "@" + x2;
        return info;
    }

    public static String obtainAddress(String s) {
        int x = System.identityHashCode(s);
        String x2 = Integer.toHexString(x);
        String info = "@" + x2;
        return info;
    }

    public static String obtainAddress(Object obj) {
        int x = System.identityHashCode(obj);
        String x2 = Integer.toHexString(x);
        String info = "@" + x2;
        return info;
    }

    public static void scrollFileContents(String header, String fname, Color colr) {
        int numColms = 45;
        System.out.println("...reading...");
        ArrayList<String> info = TCAIO.readStringData(fname);
        String information = TCAStringManip.concatenateStringsFromArrayWithNewLines(info);
        System.out.println("...processing...");
        information = TCAStringManip.processText(information, 35);
        JTextArea resultArea = new JTextArea(information);
        Font myFont = new Font("monospaced", 1, 15);
        resultArea.setFont(myFont);
        resultArea.setBackground(colr);
        resultArea.setEditable(false);
        resultArea.setRows(25);
        resultArea.setColumns(numColms);
        resultArea.setTabSize(3);
        JScrollPane pane = new JScrollPane(resultArea);
        JFrame myFrame = new JFrame(header);
        myFrame.setSize(480, 620);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = myFrame.getBounds();
        int ul_x = (screenDim.width - frameDim.width) / 2;
        int ul_y = (screenDim.height - frameDim.height) / 2;
        myFrame.setLocation(ul_x, ul_y);
        JPanel myPanel = new JPanel();
        myPanel.add(pane);
        Image titleIcon = new ImageIcon("tca_logo1.jpg").getImage();
        myFrame.setIconImage(titleIcon);
        myFrame.setContentPane(myPanel);
        myFrame.setVisible(true);
        myFrame.setDefaultCloseOperation(3);
    }

    public static String readText(String fileName) {
        String myText = "";
        try {
            String entry;
            FileReader inFile = new FileReader(fileName);
            BufferedReader inStream = new BufferedReader(inFile);
            while ((entry = inStream.readLine()) != null) {
                myText = String.valueOf(myText) + entry;
            }
            inStream.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception e = " + e, "TCAIO.readReadData()", 1);
            System.exit(0);
        }
        return myText;
    }

    public static void scrollStringOutput(String header, String information, Color colr) {
        int numColms = 45;
        information = TCAStringManip.processText(information, 35);
        JTextArea resultArea = new JTextArea(information);
        Font myFont = new Font("monospaced", 1, 15);
        resultArea.setFont(myFont);
        resultArea.setBackground(colr);
        resultArea.setEditable(false);
        resultArea.setRows(25);
        resultArea.setColumns(numColms);
        resultArea.setTabSize(3);
        JScrollPane pane = new JScrollPane(resultArea);
        JFrame myFrame = new JFrame(header);
        myFrame.setSize(480, 620);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = myFrame.getBounds();
        int ul_x = (screenDim.width - frameDim.width) / 2;
        int ul_y = (screenDim.height - frameDim.height) / 2;
        myFrame.setLocation(ul_x, ul_y);
        JPanel myPanel = new JPanel();
        myPanel.add(pane);
        Image titleIcon = new ImageIcon("tca_logo4.jpg").getImage();
        myFrame.setIconImage(titleIcon);
        myFrame.setContentPane(myPanel);
        myFrame.setVisible(true);
        myFrame.setDefaultCloseOperation(3);
    }

    public static String createFileName() {
        JFileChooser chooser = new JFileChooser();
        File myFile = null;
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal == 0) {
            myFile = chooser.getSelectedFile();
        } else {
            System.out.println("Selection Process Cancelled");
            System.out.println("Program Terminated");
            System.exit(0);
        }
        return myFile.toString();
    }

    public static void createTextFile(String finalStory, String fileName) {
        block12: {
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(fileName);
                    PrintWriter printer = new PrintWriter(writer);
                    printer.print(finalStory);
                    printer.close();
                }
                catch (Exception e) {
                    TCAIO.reportError(e);
                    System.out.println("Program Concluded");
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (Exception e2) {
                        TCAIO.reportError(e2);
                    }
                }
            }
            finally {
                System.out.println("Program Concluded");
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        TCAIO.reportError(e);
                    }
                }
            }
        }
    }

    public static void reportError(Exception e) {
        System.out.println("Exception found: " + e);
        System.out.println("Please correct the problem");
    }

    public static void terminateProgram(Exception e) {
        System.out.println("Exception found: " + e);
        System.out.println("Program is terminating...");
        System.exit(0);
    }

    public static void terminateProgram(String msg) {
        System.out.println(msg);
        System.out.println("Program is terminating...\n");
        System.exit(0);
    }

    public static String numberWithCommas(int n) {
        String temp = "";
        NumberFormat commaFormatter = NumberFormat.getNumberInstance();
        temp = String.valueOf(temp) + commaFormatter.format(n);
        return temp;
    }

    public static String numberWithCommas(double n) {
        String temp = "";
        NumberFormat commaFormatter = NumberFormat.getNumberInstance();
        temp = String.valueOf(temp) + commaFormatter.format(n);
        return temp;
    }

    public static String numberWithCommas(long n) {
        String temp = "";
        NumberFormat commaFormatter = NumberFormat.getNumberInstance();
        temp = String.valueOf(temp) + commaFormatter.format(n);
        return temp;
    }
}

