/*
 * Decompiled with CFR 0.152.
 */
public class TCAFraction {
    private int n0;
    private int d0;
    private int num;
    private int den;
    private double value;
    private String name;
    private boolean isReduced;
    private int wholePart;
    private double fracPart;
    private int sign;
    private boolean isFinite;

    public TCAFraction() {
        this.num = 0;
        this.n0 = 0;
        this.den = 1;
        this.d0 = 1;
        this.value = 0.0;
        this.wholePart = 0;
        this.fracPart = 0.0;
        this.name = "unknown";
        this.sign = 1;
        this.isReduced = true;
        this.isFinite = true;
    }

    public TCAFraction(int n, int d) {
        this.n0 = this.num = n;
        this.d0 = this.den = d;
        this.sign = n * d < 0 ? -1 : 1;
        if (Math.abs(d) > 0) {
            this.isFinite = true;
            this.adjustSigns();
            this.calculateValue();
            this.reduce();
        } else {
            this.value = this.sign > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            this.isFinite = false;
        }
        this.name = "unknown";
    }

    public TCAFraction(double n, double d) {
        this(n / d);
    }

    public TCAFraction(int n, int d, String name, boolean processMe) {
        this.n0 = n;
        this.d0 = d;
        this.num = n;
        this.den = d;
        this.sign = n * d < 0 ? -1 : 1;
        if (Math.abs(d) > 0) {
            this.isFinite = true;
            this.calculateValue();
            if (processMe) {
                this.adjustSigns();
                this.reduce();
            } else {
                this.isReduced = false;
            }
        } else {
            this.value = this.sign > 0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            this.isFinite = false;
        }
        this.name = name;
    }

    public TCAFraction(double v) {
        this.sign = v < 0.0 ? -1 : 1;
        double temp1 = Math.abs(v);
        this.wholePart = (int)Math.floor(temp1);
        this.fracPart = (double)this.sign * (temp1 - (double)this.wholePart);
        this.wholePart *= this.sign;
        double x = temp1 - (double)Math.abs(this.wholePart);
        int myD = this.lookForPossibleDenominator(x);
        int myN = (int)Math.rint((double)myD * temp1) * this.sign;
        if (myN * myD == 0 && Math.abs(v) > 0.0) {
            String msg = "Error in generating this fraction";
            TCAIO.terminateProgram(msg);
        } else {
            this.isFinite = true;
            this.value = v;
            this.name = "unknown";
            this.n0 = this.num = myN;
            this.d0 = this.den = myD;
            this.reduce();
        }
    }

    public TCAFraction(int n, int d, String myName) {
        this(n, d);
        this.name = myName;
    }

    public TCAFraction(double v, String myName) {
        this(v);
        this.setName(myName);
    }

    public TCAFraction(double myn, double myd, String myName) {
        this(myn / myd);
        this.setName(myName);
    }

    public TCAFraction(TCAFraction f, String myName) {
        this.n0 = f.n0;
        this.d0 = f.d0;
        this.num = f.num;
        this.den = f.den;
        this.value = f.value;
        this.wholePart = f.wholePart;
        this.fracPart = f.fracPart;
        this.sign = f.sign;
        this.isReduced = f.isReduced;
        this.isFinite = f.isFinite;
        this.name = myName;
    }

    public int lookForPossibleDenominator(double x) {
        int myD = 0;
        double temp = x;
        int maxN = Integer.MAX_VALUE;
        int i = 1;
        while (i < maxN) {
            double prod = temp * (double)i;
            if (TCAMath.aboutEqual(prod, Math.rint(prod))) {
                myD = i;
                break;
            }
            ++i;
        }
        return myD;
    }

    public int getOriginalNumerator() {
        return this.n0;
    }

    public int getOriginalDenominator() {
        return this.d0;
    }

    public int getNumerator() {
        return this.num;
    }

    public int getDenominator() {
        return this.den;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public double getFracPart() {
        return this.fracPart;
    }

    public int getWholePart() {
        return this.wholePart;
    }

    public int getSign() {
        return this.sign;
    }

    public boolean getIsReduced() {
        return this.isReduced;
    }

    public boolean getIsFinite() {
        return this.isFinite;
    }

    public void setNumerator(int n) {
        this.n0 = this.num = n;
        this.adjustSigns();
        this.calculateValue();
        this.reduce();
    }

    public void setDenominator(int d) {
        this.d0 = this.den = d;
        this.num = this.n0;
        this.adjustSigns();
        this.calculateValue();
        this.reduce();
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setValue(double v) {
        TCAFraction temp = new TCAFraction(v);
        this.setNumerator(temp.num);
        this.setDenominator(temp.den);
        this.value = v;
    }

    private void adjustSigns() {
        if (this.sign > 0) {
            this.n0 = this.num = Math.abs(this.n0);
            this.d0 = this.den = Math.abs(this.d0);
        } else {
            this.n0 = this.num = -1 * Math.abs(this.n0);
            this.d0 = this.den = Math.abs(this.d0);
        }
    }

    public void reduce() {
        this.isReduced = false;
        if (this.isFinite) {
            if (Math.abs(this.d0) > 0) {
                int gcf = TCAMath.calculateGCF(this.num, this.den);
                this.num = this.n0 / gcf;
                this.den = this.d0 / gcf;
                this.isReduced = true;
            } else {
                this.isReduced = false;
            }
        }
    }

    public String getRat() {
        return String.valueOf(this.num) + "/" + this.den;
    }

    public String toString() {
        return String.valueOf(this.num) + "/" + this.den;
    }

    public TCAFraction multiply(TCAFraction f2) {
        if (this.isFinite && f2.isFinite) {
            int myN = this.n0 * f2.n0;
            int myD = this.d0 * f2.d0;
            TCAFraction product = new TCAFraction(myN, myD);
            if (this.name != null && !this.name.equals("unknown") && f2.name != null && !f2.name.equals("unknown")) {
                product.setName(String.valueOf(this.name) + "*" + f2.name);
            } else {
                product.setName("unknown");
            }
            return product;
        }
        return null;
    }

    public TCAFraction divide(TCAFraction f2) {
        if (this.isFinite && f2.isFinite) {
            TCAFraction quotient;
            if (Math.abs(f2.value) > 0.0) {
                TCAFraction recip = f2.reciprocal();
                quotient = this.multiply(recip);
                if (this.name != null && !this.name.equals("unknown") && f2.name != null && !f2.name.equals("unknown")) {
                    quotient.setName(String.valueOf(this.name) + "/" + f2.name);
                } else {
                    quotient.setName("unknown");
                }
            } else {
                quotient = null;
            }
            return quotient;
        }
        return null;
    }

    public TCAFraction reciprocal() {
        TCAFraction recip = new TCAFraction(this.d0, this.n0);
        if (!this.name.equals("unknown")) {
            recip.name = "reciprocal of " + this.name;
        }
        return recip;
    }

    public TCAFraction add(TCAFraction f2) {
        if (this.isFinite && f2.isFinite) {
            int myN = this.n0 * f2.d0 + this.d0 * f2.n0;
            int myD = this.d0 * f2.d0;
            TCAFraction sum = new TCAFraction(myN, myD);
            if (this.name != null && !this.name.equals("unknown") && f2.name != null && !f2.name.equals("unknown")) {
                sum.setName(String.valueOf(this.name) + "+" + f2.name);
            } else {
                sum.setName("unknown");
            }
            return sum;
        }
        return null;
    }

    public TCAFraction subtract(TCAFraction f2) {
        if (this.isFinite && f2.isFinite) {
            int myN = this.n0 * f2.d0 - this.d0 * f2.n0;
            int myD = this.d0 * f2.d0;
            TCAFraction diff = new TCAFraction(myN, myD);
            if (this.name != null && !this.name.equals("unknown") && f2.name != null && !f2.name.equals("unknown")) {
                diff.setName(String.valueOf(this.name) + "-" + f2.name);
            } else {
                diff.setName("unknown");
            }
            return diff;
        }
        return null;
    }

    public void calculateValue() {
        if (Math.abs(this.den) > 0) {
            this.value = (double)this.num / (double)this.den;
            this.wholePart = this.n0 / this.d0;
            this.fracPart = (double)this.sign * (Math.abs(this.value) - (double)Math.abs(this.wholePart));
        } else if (this.num * this.den < 0) {
            this.value = Double.NEGATIVE_INFINITY;
            this.wholePart = 0;
            this.fracPart = this.value;
        } else {
            this.value = Double.POSITIVE_INFINITY;
            this.wholePart = 0;
            this.fracPart = this.value;
        }
    }

    public boolean equals(TCAFraction f2) {
        if (this.den * f2.den == 0) {
            return false;
        }
        int diag1 = this.num * f2.den;
        int diag2 = this.den * f2.num;
        return diag1 == diag2;
    }

    public void enlarge(int x) {
        TCAFraction temp = new TCAFraction(x * this.num, x * this.den, this.name, false);
        this.n0 = this.num = temp.n0;
        this.d0 = this.den = temp.d0;
        this.isReduced = false;
    }

    public String summary() {
        String temp = "Name: " + this.name;
        temp = String.valueOf(temp) + "\nOriginal Form: " + this.n0 + "/" + this.d0;
        temp = this.isReduced ? String.valueOf(temp) + "\nReduced Form: " + this.getRat() : String.valueOf(temp) + "\nReduced Form: To be determined";
        temp = String.valueOf(temp) + "\nDecimal Value: " + this.value;
        temp = String.valueOf(temp) + "\nWhole Part: " + this.wholePart;
        temp = String.valueOf(temp) + "\nFractional Part: " + this.fracPart;
        temp = this.isWholeNumber() ? String.valueOf(temp) + "\nIs a whole number" : String.valueOf(temp) + "\nIs not a whole number";
        if (this.isImproper()) {
            temp = String.valueOf(temp) + "\nIs improper fraction";
            temp = String.valueOf(temp) + "\nMixed Form: " + this.printAsMixedNumber();
        } else {
            temp = String.valueOf(temp) + "\nIs not an improper fraction";
        }
        temp = String.valueOf(temp) + "\nMemory Address: " + TCAIO.obtainAddress(this) + "\n";
        return temp;
    }

    public void summarize() {
        if (this != null) {
            System.out.println(this.summary());
            System.out.println();
        } else {
            System.out.println("This fraction could not be evaluated");
        }
    }

    public static void summarize(TCAFraction f) {
        if (f != null) {
            System.out.println(f.summary());
            System.out.println();
        } else {
            System.out.println("The requested fraction could not be evaluated\n");
        }
    }

    public void process() {
        this.adjustSigns();
        this.reduce();
    }

    public boolean isWholeNumber() {
        return TCAMath.aboutEqual(this.value, Math.rint(this.value));
    }

    public boolean isImproper() {
        return Math.abs(this.value) > 1.0 && !TCAMath.aboutEqual(this.value, 0.0);
    }

    public String printAsMixedNumber() {
        double fp = this.getFracPart();
        TCAFraction temp = new TCAFraction(fp);
        String mixedForm = String.valueOf(this.wholePart) + "+(" + temp + ")";
        return mixedForm;
    }
}

