/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class TCADoubleArray {
    private int seed;
    private Random rng;
    private int n;
    private double low;
    private double high;
    private double truLo;
    private double truHi;
    private double sum;
    private double mean;
    private double median;
    private double mode;
    private double sdPop;
    private double sdSample;
    private double[] myArray;
    private final int DESCENDING_ORDER = -1;
    private final int RANDOM_ORDER = 0;
    private final int ASCENDING_ORDER = 1;

    public TCADoubleArray() {
        this.rng = new Random();
        this.n = 10;
        this.low = 1.0;
        this.high = 50.0;
        this.myArray = this.generateArray();
        this.sum = this.calcSum();
        this.findTruLo();
        this.findTruHi();
        this.mean = this.calcMean();
        this.median = this.calcMedian();
        this.mode = this.calcMode();
        this.sdPop = this.calcPopulationSD();
    }

    public TCADoubleArray(int size, int seed, double lo, double hi, short decPlace) {
        if (size != 0) {
            this.rng = new Random(seed);
            this.n = size;
            this.low = lo;
            this.high = hi;
            this.myArray = this.generateArray();
            this.round(decPlace);
        } else {
            System.out.println("\nInvalid argument, size must be positive integer!\nProgram Terminated\n");
            System.exit(0);
        }
    }

    public TCADoubleArray(int size, double x) {
        if (size != 0) {
            this.rng = new Random();
            this.n = size;
            this.low = this.high = x;
            this.myArray = this.generateArray(size, this.rng, x, x);
            this.sum = this.calcSum();
            this.findTruLo();
            this.findTruHi();
            this.mean = this.calcMean();
            this.median = this.calcMedian();
            this.mode = this.calcMode();
            this.sdPop = this.calcPopulationSD();
        } else {
            System.out.println("\nInvalid argument, size must be positive integer!\nProgram Terminated\n");
            System.exit(0);
        }
    }

    public TCADoubleArray(HashSet<Double> a) {
        this.rng = new Random();
        this.n = a.size();
        this.myArray = new double[this.n];
        Object[] temp = a.toArray();
        int ndx = 0;
        Object[] objectArray = temp;
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            double val;
            Object obj = objectArray[n2];
            this.myArray[ndx] = val = ((Double)obj).doubleValue();
            ++ndx;
            ++n2;
        }
        this.sum = this.calcSum();
        this.findTruLo();
        this.findTruHi();
        this.mean = this.calcMean();
        this.median = this.calcMedian();
        this.mode = this.calcMode();
        this.sdPop = this.calcPopulationSD();
    }

    public TCADoubleArray(ArrayList<Double> a) {
        this.rng = new Random();
        this.n = a.size();
        if (this.n == 0) {
            System.out.println("\nInvalid argument, size must be positive integer!\nProgram Terminated\n");
            System.exit(0);
        }
        this.myArray = new double[this.n];
        int i = 0;
        while (i < this.n) {
            this.myArray[i] = a.get(i);
            ++i;
        }
        this.sum = this.calcSum();
        this.findTruLo();
        this.findTruHi();
        this.mean = this.calcMean();
        this.median = this.calcMedian();
        this.mode = this.calcMode();
        this.sdPop = this.calcPopulationSD();
    }

    public TCADoubleArray(int size, Random r, double lo, double hi) {
        if (size != 0) {
            this.n = size;
            this.rng = r;
            this.low = lo;
            this.high = hi;
            this.myArray = this.generateArray();
            this.sum = this.calcSum();
            this.findTruLo();
            this.findTruHi();
            this.mean = this.calcMean();
            this.median = this.calcMedian();
            this.mode = this.calcMode();
            this.sdPop = this.calcPopulationSD();
        } else {
            System.out.println("\nInvalid argument, size must be positive integer!\nProgram Terminated\n");
            System.exit(0);
        }
    }

    public TCADoubleArray(int size, Random r, double lo, double hi, short decPlace) {
        this(size, r, lo, hi);
        this.round(decPlace);
        this.findTruLo();
        this.findTruHi();
        this.sum = this.calcSum();
        this.mean = this.calcMean();
        this.median = this.calcMedian();
        this.mode = this.calcMode();
        this.sdPop = this.calcPopulationSD();
    }

    public TCADoubleArray(int size, Random r, double lo, double hi, int decPlace, boolean repeatsAllowed) {
        if (size != 0) {
            this.n = size;
            this.rng = r;
            this.low = lo;
            this.high = hi;
            if (!repeatsAllowed) {
                this.myArray = new double[this.n];
                long tripCount = 0L;
                int i = 0;
                while (i < this.n) {
                    boolean valueRepeated;
                    do {
                        double x;
                        valueRepeated = false;
                        this.myArray[i] = x = this.low + (this.high - this.low) * this.rng.nextDouble();
                        this.round(decPlace);
                        int j = 0;
                        while (j < i) {
                            if (this.aboutEqual(this.myArray[i], this.myArray[j])) {
                                valueRepeated = true;
                                ++tripCount;
                                break;
                            }
                            ++j;
                        }
                        if (tripCount <= 1000000L) continue;
                        System.out.println("Difficulty generating unique values\nAdjust parameters");
                        System.exit(0);
                    } while (valueRepeated);
                    valueRepeated = false;
                    ++i;
                }
            } else {
                this.myArray = this.generateArray();
            }
            this.round(decPlace);
            this.findTruLo();
            this.findTruHi();
            this.sum = this.calcSum();
            this.mean = this.calcMean();
            this.median = this.calcMedian();
            this.mode = this.calcMode();
            this.sdPop = this.calcPopulationSD();
        } else {
            System.out.println("\nInvalid argument, n must be positive integer!\nProgram Terminated\n");
            System.exit(0);
        }
    }

    public TCADoubleArray(int size, Random r, double lo, double hi, double x, int ndx1) {
        this(size, r, lo, hi);
        try {
            this.myArray[ndx1] = x;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Array size: " + size + "; " + "ndx1 = " + ndx1 + "; Incorrect index value. Array not adjusted");
        }
        this.findTruLo();
        this.findTruHi();
        this.sum = this.calcSum();
        this.mean = this.calcMean();
        this.median = this.calcMedian();
        this.mode = this.calcMode();
        this.sdPop = this.calcPopulationSD();
    }

    public TCADoubleArray(int size, Random r, double lo, double hi, double x, int ndx1, int ndx2) {
        this(size, r, lo, hi);
        try {
            this.myArray[ndx1] = x;
            this.myArray[ndx2] = x;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Array size: " + size + "; Incorrect index value. Array not adjusted");
        }
        this.findTruLo();
        this.findTruHi();
        this.sum = this.calcSum();
        this.mean = this.calcMean();
        this.median = this.calcMedian();
        this.mode = this.calcMode();
        this.sdPop = this.calcPopulationSD();
    }

    public TCADoubleArray(String st, String delimitter) {
        this();
        StringTokenizer strTok = new StringTokenizer(st, delimitter);
        ArrayList<Double> arrlist = new ArrayList<Double>();
        int ndx = 0;
        while (strTok.hasMoreElements()) {
            String xstr = strTok.nextToken();
            try {
                double x = Double.parseDouble(xstr);
                arrlist.add(x);
            }
            catch (Exception e) {
                System.out.println("\tinvalid entry:  " + xstr + ", deleted...");
            }
            ++ndx;
        }
        Object[] arr = arrlist.toArray();
        double[] darr = new double[arr.length];
        ndx = 0;
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            double xval;
            Object a = objectArray[n2];
            String obj = a.toString();
            darr[ndx] = xval = Double.parseDouble(obj);
            ++ndx;
            ++n2;
        }
        if (ndx > 0) {
            TCADoubleArray temp = new TCADoubleArray(darr);
            this.n = temp.n;
            this.truHi = temp.truHi;
            this.truLo = temp.truLo;
            this.sum = temp.sum;
            this.mean = temp.mean;
            this.median = temp.median;
            this.mode = temp.mode;
            this.sdPop = temp.sdPop;
            this.myArray = temp.myArray;
            this.low = this.truLo;
            this.high = this.truHi;
        } else {
            System.out.println("\nNo entries provided. Program terminated");
            System.exit(0);
        }
    }

    public TCADoubleArray(String st, char delimitter) {
        this();
        String del = String.valueOf(delimitter);
        StringTokenizer strTok = new StringTokenizer(st, del);
        ArrayList<Double> arrlist = new ArrayList<Double>();
        int ndx = 0;
        while (strTok.hasMoreElements()) {
            String xstr = strTok.nextToken();
            try {
                double x = Double.parseDouble(xstr);
                arrlist.add(x);
            }
            catch (Exception e) {
                System.out.println("\tinvalid entry:  " + xstr + ", deleted...");
            }
            ++ndx;
        }
        Object[] arr = arrlist.toArray();
        double[] darr = new double[arr.length];
        ndx = 0;
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            double xval;
            Object a = objectArray[n2];
            String obj = a.toString();
            darr[ndx] = xval = Double.parseDouble(obj);
            ++ndx;
            ++n2;
        }
        if (ndx > 0) {
            TCADoubleArray temp = new TCADoubleArray(darr);
            this.n = temp.n;
            this.truHi = temp.truHi;
            this.truLo = temp.truLo;
            this.sum = temp.sum;
            this.mean = temp.mean;
            this.median = temp.median;
            this.mode = temp.mode;
            this.sdPop = temp.sdPop;
            this.myArray = temp.myArray;
            this.low = this.truLo;
            this.high = this.truHi;
        } else {
            System.out.println("\nNo entries provided. Program terminated");
            System.exit(0);
        }
    }

    public TCADoubleArray(StringTokenizer st, String delimitter) {
        this();
        ArrayList<Double> arrlist = new ArrayList<Double>();
        int ndx = 0;
        while (st.hasMoreElements()) {
            String xstr = st.nextToken();
            try {
                double x = Double.parseDouble(xstr);
                arrlist.add(x);
            }
            catch (Exception e) {
                System.out.println("invalid entry:  " + xstr + ", deleted...");
            }
            ++ndx;
        }
        Object[] arr = arrlist.toArray();
        double[] darr = new double[arr.length];
        ndx = 0;
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            double xval;
            Object a = objectArray[n2];
            String obj = a.toString();
            darr[ndx] = xval = Double.parseDouble(obj);
            ++ndx;
            ++n2;
        }
        TCADoubleArray temp = new TCADoubleArray(darr);
        this.n = temp.n;
        this.truHi = temp.truHi;
        this.truLo = temp.truLo;
        this.sum = temp.sum;
        this.mean = temp.mean;
        this.median = temp.median;
        this.mode = temp.mode;
        this.sdPop = temp.sdPop;
        this.myArray = temp.myArray;
    }

    public TCADoubleArray(double[] a) {
        this.rng = new Random();
        this.n = a.length;
        this.low = this.high = a[0];
        this.myArray = new double[a.length];
        this.myArray[0] = a[0];
        int i = 1;
        while (i < this.n) {
            this.myArray[i] = a[i];
            this.low = Math.min(a[i], this.low);
            this.high = Math.max(a[i], this.high);
            ++i;
        }
        this.findTruLo();
        this.findTruHi();
        this.sum = this.calcSum();
        this.mean = this.calcMean();
        this.median = this.calcMedian();
        this.mode = this.calcMode();
        this.sdPop = this.calcPopulationSD();
    }

    public TCADoubleArray(int[] a) {
        this.rng = new Random();
        this.n = a.length;
        this.low = this.high = (double)a[0];
        this.myArray = new double[a.length];
        this.myArray[0] = a[0];
        int i = 1;
        while (i < this.n) {
            this.myArray[i] = a[i];
            this.low = Math.min((double)a[i], this.low);
            this.high = Math.max((double)a[i], this.high);
            ++i;
        }
        this.findTruLo();
        this.findTruHi();
        this.sum = this.calcSum();
        this.mean = this.calcMean();
        this.median = this.calcMedian();
        this.mode = this.calcMode();
        this.sdPop = this.calcPopulationSD();
    }

    public TCADoubleArray(TCADoubleArray da) {
        this(da.getArray());
    }

    public TCADoubleArray(String x) {
        this(new TCACharacterArray(x).getUnicodes());
    }

    public double[] generateArray() {
        double[] temp = new double[this.n];
        int i = 0;
        while (i < this.n) {
            double x;
            temp[i] = x = this.low + (this.high - this.low) * this.rng.nextDouble();
            ++i;
        }
        return temp;
    }

    public double[] generateArray(int n, Random rng, double low, double high) {
        double[] temp = new double[n];
        int i = 0;
        while (i < n) {
            temp[i] = low + (high - low) * rng.nextDouble();
            ++i;
        }
        return temp;
    }

    public void generateArray2() {
        int i = 0;
        while (i < this.n) {
            this.myArray[i] = this.low + (this.high - this.low) * this.rng.nextDouble();
            ++i;
        }
    }

    public String toString() {
        String output = "";
        DecimalFormat df = new DecimalFormat("#,###.000");
        int i = 0;
        while (i < this.n) {
            output = String.valueOf(output) + "myArray[" + i + "] = " + df.format(this.myArray[i]) + "\n";
            ++i;
        }
        return output;
    }

    public double findMaxSum() {
        double maxSum;
        int len = this.n;
        double sum = maxSum = this.myArray[0] + this.myArray[1];
        int i = 1;
        while (i < len) {
            int j = 0;
            while (j < i) {
                sum = this.myArray[i] + this.myArray[j];
                double diff = Math.abs(this.myArray[i] - this.myArray[j]);
                if (diff > 1.0E-7 && sum > maxSum) {
                    maxSum = sum;
                }
                ++j;
            }
            ++i;
        }
        return maxSum;
    }

    public int getLength() {
        return this.myArray.length;
    }

    public double getValue(int x) {
        return this.myArray[x];
    }

    public int[] makeRoundedIntArray() {
        int[] temp = new int[this.myArray.length];
        int i = 0;
        while (i < this.myArray.length) {
            temp[i] = Math.round((float)this.myArray[i]);
            ++i;
        }
        return temp;
    }

    public int[] makeSortedIntArray() {
        int[] temp = this.makeRoundedIntArray();
        Arrays.sort(temp);
        return temp;
    }

    public double[] makeSortedDoubleArray() {
        double[] temp = new double[this.getArray().length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = this.getValue(i);
            ++i;
        }
        Arrays.sort(temp);
        return temp;
    }

    public double[] getArray() {
        return this.myArray;
    }

    public double[] reverse() {
        int len = this.getArray().length;
        double[] temp = new double[len];
        int j = 0;
        int i = len - 1;
        while (i >= 0) {
            temp[j] = this.getValue(i);
            ++j;
            --i;
        }
        return temp;
    }

    public double getLow() {
        return this.low;
    }

    public double getHigh() {
        return this.high;
    }

    public double calcMedian() {
        double[] temp = new double[this.n];
        int i = 0;
        while (i < this.n) {
            temp[i] = this.myArray[i];
            ++i;
        }
        Arrays.sort(temp);
        double med = 0.0;
        int len = temp.length;
        if (len % 2 == 1) {
            med = temp[len / 2];
        } else {
            int ndx = len / 2;
            int ndx2 = ndx - 1;
            med = (temp[ndx2] + temp[ndx]) / 2.0;
        }
        return med;
    }

    public double calcSum() {
        double sum = 0.0;
        int i = 0;
        while (i < this.n) {
            sum += this.myArray[i];
            ++i;
        }
        return sum;
    }

    public double calcMean() {
        return this.getSum() / (double)this.n;
    }

    public void round(int x) {
        double powTen = Math.pow(10.0, x);
        if (this.n > 0) {
            int i = 0;
            while (i < this.n) {
                this.myArray[i] = this.myArray[i] * powTen;
                this.myArray[i] = Math.round(this.myArray[i]);
                int n = i++;
                this.myArray[n] = this.myArray[n] / powTen;
            }
            this.truLo = this.truHi = this.myArray[0];
            this.sum = 0.0;
            i = 0;
            while (i < this.n) {
                this.truLo = Math.min(this.myArray[i], this.truLo);
                this.truHi = Math.max(this.myArray[i], this.truHi);
                this.sum += this.myArray[i];
                ++i;
            }
            this.mean = this.calcMean();
            this.median = this.calcMedian();
            this.mode = this.calcMode();
            this.sdPop = this.calcPopulationSD();
        }
    }

    public int linearSearch(double key) {
        boolean found = false;
        int ndx = -1;
        while (!found && ndx < this.n - 1) {
            if (!this.aboutEqual(this.myArray[++ndx], key)) continue;
            found = true;
        }
        if (found) {
            return ndx;
        }
        return -1;
    }

    public boolean aboutEqual(double x, double y) {
        double EPSILON = 1.0E-14;
        boolean aboutEqualTo = false;
        double difference = x * y != 0.0 ? Math.abs(x - y) / Math.max(Math.abs(x), Math.abs(y)) : Math.abs(x - y);
        if (difference <= 1.0E-14) {
            aboutEqualTo = true;
        }
        return aboutEqualTo;
    }

    public boolean repeatedValuesPresent() {
        boolean repeatsThere = false;
        double[] temp = this.makeSortedDoubleArray();
        int i = 0;
        while (i < temp.length - 1) {
            if (this.aboutEqual(temp[i], temp[i + 1])) {
                repeatsThere = true;
                break;
            }
            ++i;
        }
        return repeatsThere;
    }

    public ArrayList<Double> makeArrayList(TCADoubleArray a) {
        ArrayList<Double> d = new ArrayList<Double>();
        double[] dArray = a.getArray();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            d.add(x);
            ++n2;
        }
        return d;
    }

    public ArrayList<Double> repeatedValuesArrayList() {
        boolean repeatsThere = false;
        double[] temp = this.makeSortedDoubleArray();
        TCADoubleArray t = new TCADoubleArray(temp);
        ArrayList<Double> repeats = t.makeArrayList(t);
        ArrayList<Double> uniques = new ArrayList<Double>();
        HashSet<Double> byeBye = new HashSet<Double>();
        int i = 0;
        while (i < repeats.size() - 1) {
            if (!byeBye.add(repeats.get(i))) {
                repeatsThere = true;
            }
            ++i;
        }
        if (repeatsThere) {
            double[] myNums = new double[byeBye.size()];
            Object[] temp2 = byeBye.toArray();
            int ndx = 0;
            Object[] objectArray = temp2;
            int n = temp2.length;
            int n2 = 0;
            while (n2 < n) {
                double val;
                Object obj = objectArray[n2];
                myNums[ndx] = val = ((Double)obj).doubleValue();
                ++ndx;
                ++n2;
            }
            Arrays.sort(myNums);
            double[] dArray = myNums;
            int n3 = myNums.length;
            n = 0;
            while (n < n3) {
                double v = dArray[n];
                uniques.add(v);
                ++n;
            }
        } else {
            uniques = null;
        }
        return uniques;
    }

    public TCADoubleArray repeatedValuesTCADoubleArray() {
        TCADoubleArray r;
        boolean repeatsThere = false;
        double[] temp = this.makeSortedDoubleArray();
        TCADoubleArray t = new TCADoubleArray(temp);
        ArrayList<Double> repeats = t.makeArrayList(t);
        HashSet<Double> byeBye = new HashSet<Double>();
        HashSet<Double> myDuplicates = new HashSet<Double>();
        int size = repeats.size();
        int i = 0;
        while (i < size) {
            if (!byeBye.add(repeats.get(i))) {
                repeatsThere = true;
                myDuplicates.add(repeats.get(i));
            }
            ++i;
        }
        if (repeatsThere) {
            r = new TCADoubleArray(myDuplicates);
            r.sortTCADoubleArray();
        } else {
            r = null;
        }
        return r;
    }

    public TCADoubleArray merge(TCADoubleArray a) {
        int len = this.n + a.n;
        double[] temp = new double[len];
        int count = 0;
        int i = 0;
        while (i < len) {
            temp[i] = count < this.n ? this.myArray[count] : a.myArray[count - this.n];
            ++count;
            ++i;
        }
        TCADoubleArray mergedArray = new TCADoubleArray(temp);
        return mergedArray;
    }

    public void scalarMultiply(double k) {
        int i = 0;
        while (i < this.n) {
            int n = i++;
            this.myArray[n] = this.myArray[n] * k;
        }
        this.sum = this.calcSum();
        this.mean = this.calcMean();
        this.median = this.calcMedian();
        this.mode = this.calcMode();
        this.findTruLo();
        this.findTruHi();
        this.high = this.truHi;
        this.low = this.truLo;
        this.sdPop = this.calcPopulationSD();
    }

    public void findTruLo() {
        double mylow = this.myArray[0];
        int i = 0;
        while (i < this.n) {
            if (this.myArray[i] < mylow) {
                mylow = this.myArray[i];
            }
            ++i;
        }
        this.truLo = mylow;
    }

    public double getTruLo() {
        return this.truLo;
    }

    public void findTruHi() {
        double myhi = this.myArray[0];
        int i = 0;
        while (i < this.n) {
            if (this.myArray[i] > myhi) {
                myhi = this.myArray[i];
            }
            ++i;
        }
        this.truHi = myhi;
    }

    public double getTruHi() {
        return this.truHi;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMedian() {
        return this.median;
    }

    public double getMode() {
        return this.mode;
    }

    public double getSDPop() {
        return this.sdPop;
    }

    public double getSDSample() {
        return this.sdSample;
    }

    public void summary() {
        System.out.println("n = " + this.n);
        System.out.println("theoretical low, high = " + this.low + ", " + this.high);
        System.out.println("actual min, max = " + this.truLo + ", " + this.truHi);
        System.out.println("sum = " + this.sum);
        System.out.println("mean = " + this.mean);
        System.out.println("median = " + this.median);
        System.out.println("mode = " + this.mode);
        System.out.println("population standard deviation = " + this.sdPop);
        System.out.println("sample standard deviation = " + this.sdSample);
    }

    public TCADoubleArray findUniqueValues() {
        double[] temp = this.makeSortedDoubleArray();
        ArrayList<Double> a = new ArrayList<Double>();
        double x = temp[0];
        a.add(x);
        double current = x;
        int i = 1;
        while (i < this.n) {
            double next = temp[i];
            if (!this.aboutEqual(next, current)) {
                a.add(next);
                current = next;
            }
            ++i;
        }
        double[] temp2 = new double[a.size()];
        int i2 = 0;
        while (i2 < temp2.length) {
            temp2[i2] = (Double)a.get(i2);
            ++i2;
        }
        ArrayList<Double> atemp = new ArrayList<Double>();
        double[] dArray = temp2;
        int n = temp2.length;
        int n2 = 0;
        while (n2 < n) {
            double q = dArray[n2];
            atemp.add(q);
            ++n2;
        }
        TCADoubleArray result = new TCADoubleArray(atemp);
        return result;
    }

    public double[][] findFrequencies() {
        TCADoubleArray u = new TCADoubleArray();
        u = this.findUniqueValues();
        int n = u.n;
        double[][] f = new double[n][2];
        int i = 0;
        while (i < n) {
            double val;
            f[i][0] = val = u.getValue(i);
            int freq = this.findFrequency(val);
            f[i][1] = freq;
            ++i;
        }
        return f;
    }

    public TCAMatrix getFrequencyMatrix() {
        double[][] f = this.findFrequencies();
        TCAMatrix m = new TCAMatrix(f);
        return m;
    }

    public int findFrequency(double x) {
        int count = 0;
        int i = 0;
        while (i < this.n) {
            if (this.aboutEqual(x, this.getValue(i))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public void sortTCADoubleArray() {
        double[] temp = this.makeSortedDoubleArray();
        this.myArray = temp;
    }

    public double calcMode0() {
        double[] temp = new double[this.myArray.length];
        int i = 0;
        while (i < this.n) {
            temp[i] = this.myArray[i];
            ++i;
        }
        Arrays.sort(temp);
        int tempLength = temp.length;
        if (tempLength > 0) {
            double maxMode = temp[0];
            double myMode = temp[0];
            int maxTimes = 1;
            int times = 1;
            int i2 = 1;
            while (i2 < tempLength) {
                if (temp[i2] != myMode) {
                    if (times > maxTimes) {
                        maxTimes = times;
                        maxMode = myMode;
                    }
                    myMode = temp[i2];
                    times = 0;
                }
                ++times;
                ++i2;
            }
            return maxMode;
        }
        return -1.0;
    }

    public double calcMode() {
        double[] temp = new double[this.myArray.length];
        int i = 0;
        while (i < this.n) {
            temp[i] = this.myArray[i];
            ++i;
        }
        Arrays.sort(temp);
        int tempLength = temp.length;
        if (tempLength > 0) {
            double maxMode = temp[0];
            double myMode = temp[0];
            int maxTimes = 1;
            int times = 1;
            int i2 = 1;
            while (i2 < tempLength) {
                if (temp[i2] != myMode) {
                    if (times > maxTimes) {
                        maxTimes = times;
                        maxMode = myMode;
                    }
                    myMode = temp[i2];
                    times = 0;
                }
                ++times;
                ++i2;
            }
            if (times > maxTimes) {
                maxTimes = times;
                maxMode = myMode;
            }
            return maxMode;
        }
        return -1.0;
    }

    public void set(int ndx, double val) {
        if (ndx < this.n) {
            this.myArray[ndx] = val;
            this.sum = this.calcSum();
            this.findTruLo();
            this.findTruHi();
            this.mean = this.calcMean();
            this.median = this.calcMedian();
            this.mode = this.calcMode();
            this.sdPop = this.calcPopulationSD();
        } else {
            System.out.println("Illegal operation. Program terminated\n");
            System.exit(0);
        }
    }

    public boolean equals(TCADoubleArray d) {
        System.out.println("checking equality...");
        boolean status = true;
        if (this.n != d.n) {
            status = false;
            return status;
        }
        int i = 0;
        while (i < this.n) {
            if (!TCAMath.aboutEqual(this.getValue(i), d.getValue(i))) {
                status = false;
                return status;
            }
            ++i;
        }
        return status;
    }

    public void saveDoubleArray(String fname, String delimitter) {
        try {
            FileWriter writer = new FileWriter(fname);
            PrintWriter out = new PrintWriter(writer);
            int i = 0;
            while (i < this.n) {
                String entry = Double.toString(this.myArray[i]);
                if (i != this.n - 1) {
                    out.println(String.valueOf(entry) + delimitter);
                } else {
                    out.println(entry);
                }
                ++i;
            }
            writer.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception e = " + e, "Writing DoubleArray", 1);
            System.exit(0);
        }
    }

    public void loadDoubleArray(String fname, String delimitter) {
        try {
            ArrayList<Double> tempdata = TCAIO.readRealData(fname, delimitter);
            this.n = tempdata.size();
            this.myArray = new double[this.n];
            int i = 0;
            while (i < this.n) {
                double x;
                this.myArray[i] = x = tempdata.get(i).doubleValue();
                ++i;
            }
            this.sum = this.calcSum();
            this.mean = this.calcMean();
            this.median = this.calcMedian();
            this.findTruHi();
            this.findTruLo();
            this.low = this.truLo;
            this.high = this.truHi;
            this.rng = new Random();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception e = " + e, "Loading DoubleArray", 1);
            System.exit(0);
        }
    }

    public TCADoubleArray add(double x) {
        int len = this.n + 1;
        double[] temp = new double[len];
        int i = 0;
        while (i < this.n) {
            temp[i] = this.myArray[i];
            ++i;
        }
        temp[i] = x;
        TCADoubleArray xtendedArray = new TCADoubleArray(temp);
        return xtendedArray;
    }

    public void append(double x) {
        int len = this.n + 1;
        double[] temp = new double[len];
        int i = 0;
        while (i < this.n) {
            temp[i] = this.myArray[i];
            ++i;
        }
        temp[i] = x;
        TCADoubleArray xtendedArray = new TCADoubleArray(temp);
        this.seed = xtendedArray.seed;
        this.rng = xtendedArray.rng;
        this.n = xtendedArray.n;
        this.low = xtendedArray.low;
        this.high = xtendedArray.high;
        this.truLo = xtendedArray.truLo;
        this.truHi = xtendedArray.truHi;
        this.sum = xtendedArray.sum;
        this.mean = xtendedArray.mean;
        this.median = xtendedArray.median;
        this.mode = xtendedArray.mode;
        this.myArray = xtendedArray.myArray;
    }

    public TCADoubleArray remove(double x) {
        ArrayList<Double> temp = new ArrayList<Double>();
        double[] dArray = this.myArray;
        int n = this.myArray.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (!TCAMath.aboutEqual(v, x)) {
                temp.add(v);
            }
            ++n2;
        }
        TCADoubleArray purged = new TCADoubleArray(temp);
        return purged;
    }

    public void purge(double x) {
        ArrayList<Double> temp = new ArrayList<Double>();
        double[] dArray = this.myArray;
        int n = this.myArray.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (!TCAMath.aboutEqual(v, x)) {
                temp.add(v);
            }
            ++n2;
        }
        TCADoubleArray purged = new TCADoubleArray(temp);
        this.seed = purged.seed;
        this.rng = purged.rng;
        this.n = purged.n;
        this.low = purged.low;
        this.high = purged.high;
        this.truLo = purged.truLo;
        this.truHi = purged.truHi;
        this.sum = purged.sum;
        this.mean = purged.mean;
        this.median = purged.median;
        this.mode = purged.mode;
        this.myArray = purged.myArray;
    }

    public void randomizeOrder() {
        ArrayList<Double> temp = this.makeArrayList(this);
        int count = 0;
        while (temp.size() > 0) {
            double val;
            int len = temp.size();
            int randomIndex = TCAMath.getRandom(this.rng, 0, len - 1);
            this.myArray[count] = val = temp.remove(randomIndex).doubleValue();
            ++count;
        }
    }

    public void randomizeOrder(int seed) {
        ArrayList<Double> temp = this.makeArrayList(this);
        Random rngCustom = new Random(seed);
        if (seed == 0) {
            rngCustom = new Random();
        }
        int count = 0;
        while (temp.size() > 0) {
            double val;
            int len = temp.size();
            int randomIndex = TCAMath.getRandom(rngCustom, 0, len - 1);
            this.myArray[count] = val = temp.remove(randomIndex).doubleValue();
            ++count;
        }
    }

    public void replace(double x, double y) {
        boolean hasBeenAdjusted = false;
        int i = 0;
        while (i < this.n) {
            double v = this.myArray[i];
            if (TCAMath.aboutEqual(v, x)) {
                this.myArray[i] = v;
                hasBeenAdjusted = true;
            }
            ++i;
        }
        if (hasBeenAdjusted) {
            this.sum = this.calcSum();
            this.findTruLo();
            this.findTruHi();
            this.mean = this.calcMean();
            this.median = this.calcMedian();
            this.mode = this.calcMode();
        }
    }

    public double calcPopulationSD() {
        double sumSqrdDistancesFromMean = 0.0;
        int i = 0;
        while (i < this.n) {
            double x = this.myArray[i];
            double diff = x - this.mean;
            sumSqrdDistancesFromMean += Math.pow(diff, 2.0);
            ++i;
        }
        double radicand = sumSqrdDistancesFromMean / (double)this.n;
        if (this.n > 1) {
            double radicand2 = sumSqrdDistancesFromMean / (double)(this.n - 1);
            this.sdSample = Math.sqrt(radicand2);
        } else {
            this.sdSample = 0.0;
        }
        return Math.sqrt(radicand);
    }

    public void outputResultsInGUI() {
        String values = "";
        int count = 0;
        int i = 0;
        while (i < this.n) {
            values = String.valueOf(values) + this.myArray[i] + "    ";
            if (++count == 5) {
                values = String.valueOf(values) + "\n";
                count = 0;
            }
            ++i;
        }
        String title = "";
        title = String.valueOf(title) + " Random Array\n Seed = " + this.seed + ";  " + this.n + " elements in [" + this.truLo + ", " + this.truHi + "] : \n";
        title = String.valueOf(title) + "\n";
        JOptionPane.showMessageDialog(null, String.valueOf(title) + values);
    }
}

