/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class TCADictionary {
    public static ArrayList<String> makeMiniGlossary(ArrayList<String> a, int wordSize) {
        ArrayList<String> temp = new ArrayList<String>();
        String word = "";
        int i = 0;
        while (i < a.size()) {
            word = a.get(i);
            if (word.length() == wordSize) {
                temp.add(word);
            }
            ++i;
        }
        return temp;
    }

    public static double getAvgWordLength(ArrayList<String> a) {
        long sum = 0L;
        int n = a.size();
        String word = "";
        int i = 0;
        while (i < n) {
            word = a.get(i);
            sum += (long)word.length();
            ++i;
        }
        return (double)sum / (double)n;
    }

    public static void printGlossarytoTextArea(ArrayList<String> a, int maxIndex) {
        JFrame myFrame = new JFrame("My Glossary");
        myFrame.setSize(480, 620);
        TextArea outputWindow = new TextArea(20, 30);
        myFrame.getContentPane().add(outputWindow);
        myFrame.setVisible(true);
        Image titleIcon = new ImageIcon("tca_logo1.jpg").getImage();
        myFrame.setIconImage(titleIcon);
        outputWindow.append("There are " + a.size() + " words in the glossary\n");
        int len = a.size();
        if (maxIndex < 0 || maxIndex >= len) {
            maxIndex = len;
        }
        int i = 0;
        while (i < maxIndex) {
            String myWord = a.get(i);
            outputWindow.append(String.valueOf(myWord) + "\n");
            ++i;
        }
    }

    public static void printGlossarytoTextAreaTillTargetWord(ArrayList<String> a, String target, int maxIndex) {
        JFrame myFrame = new JFrame("My Glossary");
        myFrame.setSize(480, 620);
        TextArea outputWindow = new TextArea(20, 30);
        myFrame.getContentPane().add(outputWindow);
        myFrame.setVisible(true);
        Image titleIcon = new ImageIcon("tca_logo1.jpg").getImage();
        myFrame.setIconImage(titleIcon);
        outputWindow.append("There are " + a.size() + " words in the glossary and target is: " + target + "\n");
        int len = a.size();
        if (maxIndex < 0 || maxIndex >= len) {
            maxIndex = len;
        }
        int i = 0;
        while (i < maxIndex) {
            String myWord = a.get(i);
            outputWindow.append(String.valueOf(myWord) + "\n");
            if (myWord.equals(target)) break;
            ++i;
        }
    }

    public static void printPrimestoTextAreaTillTargetExceeded(ArrayList<Integer> a, int target, int maxIndex) {
        JFrame myFrame = new JFrame("My Primes");
        myFrame.setSize(480, 620);
        TextArea outputWindow = new TextArea(20, 30);
        myFrame.getContentPane().add(outputWindow);
        myFrame.setVisible(true);
        Image titleIcon = new ImageIcon("tca_logo1.jpg").getImage();
        myFrame.setIconImage(titleIcon);
        outputWindow.append("There are " + a.size() + " primes in the documentation and target is: " + target + "\n");
        int len = a.size();
        if (maxIndex < 0 || maxIndex >= len) {
            maxIndex = len;
        }
        int count = 0;
        int i = 0;
        while (i < maxIndex) {
            ++count;
            int myPrime = a.get(i);
            outputWindow.append(String.valueOf(myPrime) + "\n");
            if (myPrime >= target) break;
            ++i;
        }
        System.out.println("\nThere were " + count + " primes in this request");
        outputWindow.append("\nThere were " + count + " primes in this request");
    }

    public static void printPrimestoTextAreaWithinRange(ArrayList<Integer> a, int pLow, int pHigh) {
        int maxIndex = -1;
        int pLowValid = Math.min(pLow, pHigh);
        int pHighValid = Math.max(pLow, pHigh);
        pLow = pLowValid;
        pHigh = pHighValid;
        JFrame myFrame = new JFrame("My Primes");
        myFrame.setSize(480, 620);
        TextArea outputWindow = new TextArea(20, 30);
        myFrame.getContentPane().add(outputWindow);
        myFrame.setVisible(true);
        Image titleIcon = new ImageIcon("tca_logo1.jpg").getImage();
        myFrame.setIconImage(titleIcon);
        outputWindow.append("There are " + a.size() + " primes in the documentation\nand the requested range is: [" + pLow + ", " + pHigh + "]\n\n");
        int len = a.size();
        if (maxIndex < 0 || maxIndex >= len) {
            maxIndex = len;
        }
        int count = 0;
        int i = 0;
        while (i < maxIndex) {
            int myPrime = a.get(i);
            if (myPrime >= pLow && myPrime <= pHigh) {
                ++count;
                outputWindow.append(String.valueOf(myPrime) + "\n");
            }
            if (myPrime >= pHigh) break;
            ++i;
        }
        System.out.println("\nThere were " + count + " primes in this request");
        outputWindow.append("\nThere were " + count + " primes in this request");
    }

    public static ArrayList<String> getGlossary(String fname) {
        ArrayList<String> myList = new ArrayList<String>();
        String word = "";
        try {
            FileReader inFile = new FileReader(fname);
            BufferedReader inStream = new BufferedReader(inFile);
            while ((word = inStream.readLine()) != null) {
                myList.add(word.toLowerCase());
            }
            inStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return myList;
    }

    public static ArrayList<Integer> getPrimes(int ndx) {
        ArrayList<Object> allPrimes = new ArrayList();
        String fname = "10000primes.txt";
        allPrimes = TCAIO.readIntegerData(fname, ";");
        int len = allPrimes.size();
        ArrayList<Integer> myPrimes = new ArrayList();
        if (ndx > len) {
            ndx = len;
        }
        if (ndx >= 0) {
            int i = 0;
            while (i < ndx) {
                myPrimes.add((Integer)allPrimes.get(i));
                ++i;
            }
        } else {
            myPrimes = allPrimes;
        }
        return myPrimes;
    }

    public static boolean isInScrabbleDictionary(String w) {
        ArrayList<String> bank = TCADictionary.getGlossary("scrabble2.txt");
        return bank.contains(w);
    }
}

