/*
 * Decompiled with CFR 0.152.
 */
public class TCAComplex {
    private double real;
    private double imag;
    private double angle;
    private double absVal;
    private String name;
    private TCAComplex conjugate;
    private TCAFraction rp;
    private TCAFraction ip;

    public TCAComplex() {
        this.real = 0.0;
        this.imag = 0.0;
        this.rp = new TCAFraction(0.0);
        this.ip = new TCAFraction(0.0);
        this.absVal = 0.0;
        this.angle = 0.0;
        this.name = "origin";
        this.conjugate = this;
    }

    public TCAComplex(double a, double b) {
        this.real = a;
        this.imag = b;
        this.rp = new TCAFraction(a);
        this.ip = new TCAFraction(b);
        this.absVal = this.computeAbsVal();
        this.angle = this.computeAngle();
        this.name = "unknown";
        this.conjugate = this.findConjugate();
    }

    public TCAComplex(double a, double b, String n) {
        this(a, b);
        this.name = n;
        this.conjugate.name = String.valueOf(n) + "Conj";
    }

    public TCAComplex(TCAComplex z) {
        this(z.real, z.imag, z.name);
    }

    public TCAComplex multiply(TCAComplex z2) {
        double r = this.real * z2.real - this.imag * z2.imag;
        double im = this.real * z2.imag + this.imag * z2.real;
        TCAComplex prod = new TCAComplex(r, im);
        if (this.name != null && !this.name.equals("unknown") && z2.name != null && !z2.name.equals("unknown")) {
            prod.setName(String.valueOf(this.name) + "*" + z2.name);
        } else {
            prod.setName("unknown");
        }
        return prod;
    }

    public TCAComplex multiply(double f) {
        TCAComplex temp = this.multiply(new TCAComplex(f, 0.0));
        temp.name = f + "*" + this.name;
        return temp;
    }

    public TCAComplex add(TCAComplex z2) {
        double r = this.real + z2.real;
        double im = this.imag + z2.imag;
        String myName = String.valueOf(this.name) + "+" + z2.name;
        return new TCAComplex(r, im, myName);
    }

    public TCAComplex subtract(TCAComplex z2) {
        String origName = z2.name;
        z2 = z2.multiply(new TCAComplex(-1.0, 0.0));
        TCAComplex diff = this.add(z2);
        diff.setName(String.valueOf(this.name) + "-" + origName);
        return diff;
    }

    public TCAComplex findConjugate() {
        TCAComplex temp = new TCAComplex();
        temp.setReal(this.real);
        temp.setImag(-1.0 * this.imag);
        temp.setConjugate(this);
        temp.setAbsVal();
        temp.setAngle();
        temp.setName(String.valueOf(this.name) + "Conj");
        return temp;
    }

    public TCAComplex divide(TCAComplex z2) {
        if (z2.absVal > 0.0) {
            String resultName = String.valueOf(this.name) + "/" + z2.name;
            TCAComplex temp1 = this.multiply(z2.conjugate);
            TCAComplex temp2 = z2.multiply(z2.conjugate);
            this.rp = new TCAFraction(temp1.real, temp2.real);
            this.ip = new TCAFraction(temp1.imag, temp2.real);
            temp1 = temp1.multiply(1.0 / temp2.real);
            temp1.setName(resultName);
            return temp1;
        }
        return null;
    }

    public TCAComplex square(TCAComplex z2) {
        return z2.multiply(z2);
    }

    public TCAComplex square() {
        return this.multiply(this);
    }

    public double computeAngle() {
        double ang = Math.atan2(this.imag, this.real);
        return ang;
    }

    public double computeAbsVal() {
        double zabs = Math.sqrt(this.real * this.real + Math.pow(this.imag, 2.0));
        return zabs;
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getAbsVal() {
        return this.absVal;
    }

    public TCAComplex getConjugate() {
        return this.conjugate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setReal(double rVal) {
        this.real = rVal;
        this.rp = new TCAFraction(rVal);
        this.absVal = this.computeAbsVal();
        this.angle = this.computeAngle();
    }

    public void setImag(double iVal) {
        this.imag = iVal;
        this.ip = new TCAFraction(iVal);
        this.absVal = this.computeAbsVal();
        this.angle = this.computeAngle();
    }

    public void setConjugate(TCAComplex c) {
        this.conjugate = c;
    }

    private void setAbsVal() {
        this.absVal = this.computeAbsVal();
    }

    private void setAngle() {
        this.angle = this.computeAngle();
    }

    public boolean equals(TCAComplex z) {
        return TCAMath.aboutEqual(this.real, z.real) && TCAMath.aboutEqual(this.imag, z.imag);
    }

    public String toString() {
        String temp = "";
        temp = String.valueOf(temp) + this.real;
        temp = String.valueOf(temp) + " + " + this.imag + "i\n";
        return temp;
    }

    public void showFractionalForm() {
        System.out.println(String.valueOf(this.name) + " = (" + this.rp + ") + (" + this.ip + ")i\n");
    }

    public static void showFractionalForm(TCAComplex z) {
        System.out.println(String.valueOf(z.name) + " = (" + z.rp + ") + (" + z.ip + ")i\n");
    }

    public void summarize() {
        System.out.println(this.summary());
    }

    public static void summarize(TCAComplex z) {
        if (z != null) {
            System.out.println(z.summary());
            System.out.println();
        } else {
            System.out.println("The requested complex number could not be evaluated\n");
        }
    }

    public String summary() {
        String temp = "";
        temp = String.valueOf(temp) + "Name: " + this.name;
        temp = String.valueOf(temp) + "\nValue: " + this;
        temp = String.valueOf(temp) + "Fractional Form: (" + this.rp + ") + (" + this.ip + ")i";
        temp = String.valueOf(temp) + "\nConjugate: " + this.conjugate;
        temp = String.valueOf(temp) + "Absolute Value: " + this.absVal;
        temp = String.valueOf(temp) + "\nAngle (radians): " + this.angle;
        double angDegrees = this.angle * 180.0 / Math.PI;
        temp = String.valueOf(temp) + "\nAngle (degrees): " + angDegrees;
        temp = String.valueOf(temp) + "\nMemory Address: " + TCAIO.obtainAddress(this) + "\n";
        return temp;
    }
}

