/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class TCACharacterArray {
    private int seed;
    private Random rng;
    private String phrase;
    private int n;
    private int unicodeLow;
    private int unicodeHigh;
    private TCADoubleArray unicodes;

    public TCACharacterArray() {
        this.rng = new Random();
        this.seed = 0;
        this.n = 5;
        this.unicodeLow = 32;
        this.unicodeHigh = 136;
        short dp = 0;
        this.unicodes = new TCADoubleArray(this.n, this.rng, (double)this.unicodeLow, (double)this.unicodeHigh, dp);
        this.createPhraseFromUnicodes();
    }

    public TCACharacterArray(int numChars, int mySeed) {
        this.seed = mySeed;
        this.rng = new Random(this.seed);
        this.n = numChars;
        this.unicodeLow = 32;
        this.unicodeHigh = 136;
        short dp = 0;
        this.unicodes = new TCADoubleArray(this.n, this.rng, (double)this.unicodeLow, (double)this.unicodeHigh, dp);
        this.createPhraseFromUnicodes();
    }

    public TCACharacterArray(int n, int ul, int um) {
        this.rng = new Random();
        this.seed = 0;
        this.n = n;
        this.unicodeLow = ul;
        this.unicodeHigh = um;
        short dp = 0;
        this.unicodes = new TCADoubleArray(n, this.rng, (double)this.unicodeLow, (double)this.unicodeHigh, dp);
        this.createPhraseFromUnicodes();
    }

    public TCACharacterArray(int n, int ul, int um, boolean repeatsAllowed) {
        this.rng = new Random();
        this.seed = 0;
        this.n = n;
        this.unicodeLow = ul;
        this.unicodeHigh = um;
        int dp = 0;
        this.unicodes = new TCADoubleArray(n, this.rng, (double)this.unicodeLow, (double)this.unicodeHigh, dp, repeatsAllowed);
        this.createPhraseFromUnicodes();
    }

    public TCACharacterArray(TCADoubleArray a) {
        this.rng = new Random();
        this.seed = 0;
        this.n = a.getLength();
        this.unicodeLow = (int)a.getTruLo();
        this.unicodeHigh = (int)a.getTruHi();
        this.unicodes = new TCADoubleArray(a);
        this.createPhraseFromUnicodes();
    }

    public TCACharacterArray(String s) {
        this.rng = new Random();
        this.seed = 0;
        this.phrase = s;
        this.n = s.length();
        int[] temp = TCAStringManip.toIntArray(s);
        this.unicodes = new TCADoubleArray(temp);
        this.unicodeLow = (int)this.unicodes.getTruLo();
        this.unicodeHigh = (int)this.unicodes.getTruHi();
    }

    private void createPhraseFromUnicodes() {
        String temp = "";
        int i = 0;
        while (i < this.unicodes.getLength()) {
            temp = String.valueOf(temp) + (char)this.unicodes.getValue(i);
            ++i;
        }
        this.phrase = temp;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public TCADoubleArray getUnicodes() {
        return this.unicodes;
    }

    public int getN() {
        return this.n;
    }

    public String toString() {
        String temp = "";
        temp = String.valueOf(temp) + this.phrase + "\n";
        return temp;
    }

    public double averageUnicodeValue() {
        return this.unicodes.getMean();
    }

    public double[][] letterFrequencies() {
        return this.unicodes.findFrequencies();
    }

    public boolean equals(TCACharacterArray x) {
        boolean areEqual = false;
        if (this.phrase.equals(x.phrase)) {
            areEqual = true;
        }
        return areEqual;
    }
}

