/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;

public class TCACharMatrix
extends TCAMatrix {
    protected char[][] symbols;

    public TCACharMatrix() {
        this.symbols = null;
    }

    public TCACharMatrix(TCADoubleArray a) {
        super(a);
        this.createSymbols();
    }

    public TCACharMatrix(TCAMatrix m) {
        super(m);
        this.createSymbols();
    }

    public TCACharMatrix(double[][] a) {
        super(a);
        this.createSymbols();
    }

    public TCACharMatrix(int r, int c, String x) {
        int len = x.length();
        if (r * c != len) {
            System.out.println("A " + r + " by " + c + "TCAChar Matrix cannot contain " + len + " symbols");
            System.exit(0);
        }
        this.r = r;
        this.c = c;
        this.numEntries = r * c;
        this.symbols = new char[r][c];
        this.myMatrix = new double[r][c];
        int myR = 0;
        int myC = -1;
        int i = 0;
        while (i < len) {
            char ch;
            char u = ch = x.charAt(i);
            if (++myC < c) {
                this.symbols[myR][myC] = ch;
                this.myMatrix[myR][myC] = u;
            } else {
                myC = 0;
                this.symbols[++myR][myC] = ch;
                this.myMatrix[myR][myC] = u;
            }
            ++i;
        }
    }

    public TCACharMatrix(String x) {
        int len = x.length();
        int r = TCAMath.findFactorClosestToSquareRoot(len);
        int c = len / r;
        this.r = r;
        this.c = c;
        this.numEntries = r * c;
        this.symbols = new char[r][c];
        this.myMatrix = new double[r][c];
        int myR = 0;
        int myC = -1;
        int i = 0;
        while (i < len) {
            char ch;
            char u = ch = x.charAt(i);
            if (++myC < c) {
                this.symbols[myR][myC] = ch;
                this.myMatrix[myR][myC] = u;
            } else {
                myC = 0;
                this.symbols[++myR][myC] = ch;
                this.myMatrix[myR][myC] = u;
            }
            ++i;
        }
    }

    public TCACharMatrix(String x, char spaceReplacer) {
        int len = x.length();
        int r = TCAMath.findFactorClosestToSquareRoot(len);
        int c = len / r;
        this.r = r;
        this.c = c;
        this.numEntries = r * c;
        this.symbols = new char[r][c];
        this.myMatrix = new double[r][c];
        int myR = 0;
        int myC = -1;
        int i = 0;
        while (i < len) {
            char ch = x.charAt(i);
            char u = ch;
            if (u == ' ') {
                u = ch = spaceReplacer;
            }
            if (++myC < c) {
                this.symbols[myR][myC] = ch;
                this.myMatrix[myR][myC] = u;
            } else {
                myC = 0;
                this.symbols[++myR][myC] = ch;
                this.myMatrix[myR][myC] = u;
            }
            ++i;
        }
    }

    public TCACharMatrix(int ucL, int ucH) {
        int ucLow = ucL;
        int ucHigh = ucH;
        this.numEntries = ucHigh - ucLow + 1;
        int factor1 = TCAMath.findFactorClosestToSquareRoot(this.numEntries);
        int factor2 = this.numEntries / factor1;
        this.r = factor1;
        this.c = factor2;
        int uc = ucLow;
        this.myMatrix = new double[this.r][this.c];
        this.symbols = new char[this.r][this.c];
        int row = 0;
        while (row < this.r) {
            int colm = 0;
            while (colm < this.c) {
                this.myMatrix[row][colm] = uc;
                this.symbols[row][colm] = (char)uc;
                ++uc;
                ++colm;
            }
            ++row;
        }
    }

    public TCACharMatrix(int numRow, int numCol, ArrayList<Character> myChars, int seed) {
        this.r = numRow;
        this.c = numCol;
        this.numEntries = this.r * this.c;
        int numChars = myChars.size();
        this.myMatrix = new double[this.r][this.c];
        this.symbols = new char[this.r][this.c];
        Random rng = seed == 0 ? new Random() : new Random(seed);
        int row = 0;
        while (row < this.r) {
            int colm = 0;
            while (colm < this.c) {
                char randCH;
                int randX = TCAMath.getRandom(rng, 0, numChars - 1);
                char randUC = randCH = myChars.get(randX).charValue();
                this.myMatrix[row][colm] = randUC;
                this.symbols[row][colm] = randCH;
                ++colm;
            }
            ++row;
        }
    }

    public TCACharMatrix(int numRow, int numCol, String x, int seed) {
        ArrayList<Character> myChars = TCAStringManip.toArrayList(x);
        this.r = numRow;
        this.c = numCol;
        this.numEntries = this.r * this.c;
        int numChars = myChars.size();
        this.myMatrix = new double[this.r][this.c];
        this.symbols = new char[this.r][this.c];
        Random rng = seed == 0 ? new Random() : new Random(seed);
        int row = 0;
        while (row < this.r) {
            int colm = 0;
            while (colm < this.c) {
                char randCH;
                int randX = TCAMath.getRandom(rng, 0, numChars - 1);
                char randUC = randCH = myChars.get(randX).charValue();
                this.myMatrix[row][colm] = randUC;
                this.symbols[row][colm] = randCH;
                ++colm;
            }
            ++row;
        }
    }

    public TCACharMatrix(TCACharMatrix x) {
        super(x.myMatrix);
        this.symbols = x.symbols;
    }

    @Override
    public double getValue(int row, int colm) {
        return this.symbols[row][colm];
    }

    @Override
    public String toString() {
        String s = "";
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                s = String.valueOf(s) + this.symbols[i][j];
                ++j;
            }
            s = String.valueOf(s) + "\n";
            ++i;
        }
        return s;
    }

    public void set(int myR, int myC, char ch) {
        this.symbols[myR][myC] = ch;
    }

    @Override
    public TCACharMatrix transpose() {
        TCACharMatrix temp = new TCACharMatrix();
        TCAMatrix tm = new TCAMatrix(this);
        tm = super.transpose();
        temp.r = tm.r;
        temp.c = tm.c;
        temp.myMatrix = tm.getMyMatrix();
        temp.symbols = new char[temp.r][temp.c];
        temp.numEntries = temp.r * temp.c;
        int row = 0;
        while (row < temp.r) {
            int colm = 0;
            while (colm < temp.c) {
                temp.symbols[row][colm] = (char)tm.get(row, colm);
                ++colm;
            }
            ++row;
        }
        return temp;
    }

    public void set(Posn p, int v) {
        super.set(p.getRow(), p.getColm(), v);
        this.set(p.getRow(), p.getColm(), (char)v);
    }

    public void replaceValues(char c0, char cf) {
        super.replaceValues(c0, cf);
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                char myChar = this.symbols[i][j];
                if (myChar == c0) {
                    this.symbols[i][j] = cf;
                }
                ++j;
            }
            ++i;
        }
    }

    public void replaceValues(int x0, int xf) {
        super.replaceValues(x0, xf);
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                char myChar = this.symbols[i][j];
                if (myChar == (char)x0) {
                    this.symbols[i][j] = (char)xf;
                }
                ++j;
            }
            ++i;
        }
    }

    private void createSymbols() {
        this.symbols = new char[this.r][this.c];
        int row = 0;
        while (row < this.r) {
            int colm = 0;
            while (colm < this.c) {
                int uc = (int)this.myMatrix[row][colm];
                this.symbols[row][colm] = (char)uc;
                ++colm;
            }
            ++row;
        }
    }

    @Override
    public TCACharMatrix addBorder(char ch) {
        TCAMatrix temp = super.addBorder(ch);
        TCACharMatrix temp2 = new TCACharMatrix(temp);
        return temp2;
    }

    @Override
    public TCACharMatrix addBorder(int[] uc) {
        TCAMatrix temp = super.addBorder(uc);
        TCACharMatrix temp2 = new TCACharMatrix(temp);
        return temp2;
    }

    @Override
    public TCACharMatrix addBorder() {
        TCAMatrix temp = super.addBorder();
        TCACharMatrix temp2 = new TCACharMatrix(temp);
        return temp2;
    }

    @Override
    public TCACharMatrix addBorder(String x) {
        TCAMatrix temp = super.addBorder(x);
        TCACharMatrix temp2 = new TCACharMatrix(temp);
        return temp2;
    }

    public void printUnicodes() {
        String temp = super.toString();
        System.out.println(temp);
    }

    public void fill(char ch) {
        int i = 0;
        while (i < this.r) {
            int j = 0;
            while (j < this.c) {
                this.symbols[i][j] = ch;
                ++j;
            }
            ++i;
        }
    }

    public void scrollOutput(String myHeading) {
        String myCharMatrixInfo = this.toString();
        Color colr = Color.gray;
        TCAIO.scrollOutput(myHeading, myCharMatrixInfo, colr);
    }
}

