/*
 * Decompiled with CFR 0.152.
 */
public class SpiralSentence
extends TCACharMatrix {
    private String text;
    private boolean replaceSpaces;
    private int fillerUnicode;
    private int spaceReplacerUnicode;
    static final int RIGHT = 1;
    static final int DOWN = 2;
    static final int LEFT = 3;
    static final int UP = 4;
    private int dirn;

    public SpiralSentence() {
        this.replaceSpaces = true;
        this.text = TCAStringManip.makeString(65, 36);
        this.getSquareDimensions(this.text.length());
        this.numEntries = this.r * this.c;
        this.myMatrix = new double[this.r][this.c];
        this.symbols = new char[this.r][this.c];
        super.fill(-1.0);
        this.fillerUnicode = 219;
        this.spaceReplacerUnicode = 1;
        this.fill((char)this.fillerUnicode);
        this.createSpiral();
    }

    public SpiralSentence(String myText) {
        super(myText);
        this.replaceSpaces = true;
        this.text = myText;
        this.myMatrix = new double[this.r][this.c];
        this.symbols = new char[this.r][this.c];
        super.fill(-1.0);
        this.fillerUnicode = 219;
        this.spaceReplacerUnicode = 1;
        this.fill((char)this.fillerUnicode);
        this.createSpiral();
    }

    public SpiralSentence(String myText, char ch) {
        super(myText);
        this.replaceSpaces = true;
        this.text = myText;
        this.myMatrix = new double[this.r][this.c];
        this.symbols = new char[this.r][this.c];
        super.fill(-1.0);
        this.fillerUnicode = 219;
        this.spaceReplacerUnicode = ch;
        this.fill((char)this.fillerUnicode);
        this.createSpiral();
    }

    public SpiralSentence(String myText, int optimalOrSquareDim) {
        this.replaceSpaces = true;
        this.text = myText;
        if (optimalOrSquareDim > 0) {
            this.getOptimalDimensions(this.text.length());
        } else {
            this.getSquareDimensions(this.text.length());
        }
        this.numEntries = this.r * this.c;
        this.myMatrix = new double[this.r][this.c];
        this.symbols = new char[this.r][this.c];
        super.fill(-1.0);
        this.fillerUnicode = 219;
        this.spaceReplacerUnicode = 1;
        this.fill((char)this.fillerUnicode);
        this.createSpiral();
    }

    public SpiralSentence(String myText, boolean replaceSpaces) {
        super(myText);
        this.replaceSpaces = replaceSpaces;
        this.text = myText;
        this.myMatrix = new double[this.r][this.c];
        this.symbols = new char[this.r][this.c];
        super.fill(-1.0);
        this.fillerUnicode = 219;
        this.spaceReplacerUnicode = 1;
        this.fill((char)this.fillerUnicode);
        this.createSpiral();
    }

    public void createSpiral() {
        int len = this.text.length();
        int colm = 0;
        int row = 0;
        Posn p = new Posn(row, colm);
        int ltr = 1;
        this.dirn = 1;
        do {
            int ascii = this.text.charAt(ltr - 1);
            if (this.replaceSpaces && ascii == 32) {
                ascii = this.spaceReplacerUnicode;
            }
            this.set(p, ascii);
            if (ltr == len) break;
            p = this.upDate(this, p, ltr);
        } while (++ltr <= len);
        this.fillVacancies();
    }

    public String getText() {
        return this.text;
    }

    public void setFillerUnicode(int uc) {
        this.replaceValues(this.fillerUnicode, uc);
        this.fillerUnicode = uc;
        System.out.println("In the setter method...");
    }

    public void setSpaceReplacer(int sr) {
        this.replaceValues(this.spaceReplacerUnicode, sr);
        System.out.println("In the space replacer method...");
        this.spaceReplacerUnicode = sr;
    }

    public void setFillerUnicode(char uc) {
        this.fillerUnicode = uc;
        this.createSpiral();
    }

    public void setSpaceReplacer(char sr) {
        this.spaceReplacerUnicode = sr;
        this.createSpiral();
    }

    private void getOptimalDimensions(int x) {
        double sroot = Math.sqrt(x);
        int truncatedRoot = (int)Math.round(sroot);
        if (TCAMath.aboutEqual(truncatedRoot, sroot)) {
            this.r = this.c = truncatedRoot;
        } else if (TCAMath.isPrime(x)) {
            this.r = truncatedRoot;
            this.c = truncatedRoot + 1;
        }
    }

    private void getSquareDimensions(int x) {
        int side;
        int ps = (int)TCAMath.findFirstPerfectSquareLargerThan(x);
        this.r = this.c = (side = (int)Math.sqrt(ps));
    }

    public Posn upDate(TCACharMatrix mySpiral, Posn p, int ltrCount) {
        boolean valid;
        Posn test = new Posn(0, 0);
        do {
            switch (this.dirn) {
                case 1: {
                    test.set(p.getRow(), p.getColm() + 1);
                    break;
                }
                case 2: {
                    test.set(p.getRow() + 1, p.getColm());
                    break;
                }
                case 3: {
                    test.set(p.getRow(), p.getColm() - 1);
                    break;
                }
                case 4: {
                    test.set(p.getRow() - 1, p.getColm());
                }
            }
            boolean bl = valid = mySpiral.validPosn(test) && mySpiral.get(test) < 0.0;
            if (valid) continue;
            ++this.dirn;
            if (this.dirn <= 4) continue;
            this.dirn = 1;
        } while (!valid);
        return test;
    }

    @Override
    public String summary() {
        String temp = super.summary();
        temp = String.valueOf(temp) + "\nText = " + this.text;
        temp = String.valueOf(temp) + "\nLength of text = " + this.text.length();
        temp = String.valueOf(temp) + "\nFiller Character = " + (char)this.fillerUnicode;
        if (this.replaceSpaces) {
            temp = String.valueOf(temp) + "\nSpace Replacement Character = " + (char)this.spaceReplacerUnicode;
        }
        return temp;
    }

    public void fillVacancies() {
        super.replaceValues(-1, this.fillerUnicode);
    }
}

