/*
 * Decompiled with CFR 0.152.
 */
import info.gridworld.actor.Actor;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.util.Random;

public class Spelunker
extends MadScientist
implements Claustrophobia {
    public int turnCount;
    public int turnThreshold;

    public Spelunker(Random myRNG) {
        super(myRNG);
        this.turnCount = 0;
        this.turnThreshold = 7;
    }

    public Spelunker(Random myRNG, int turnTh) {
        super(myRNG);
        this.turnCount = 0;
        this.turnThreshold = turnTh;
    }

    public Spelunker(GeologistHulk g) {
        super(g.getRNG());
        this.setDirection(g.getDirection());
        this.angerLevel = 0;
        this.calmingSteps = 20;
        this.computeColor(this.angerLevel);
        this.stepCount = 0;
        this.isInCorner = false;
        this.turnCount = 0;
        this.turnThreshold = g.turnThreshold;
    }

    @Override
    public void act() {
        if (super.canMove()) {
            this.move();
        } else {
            this.turn();
        }
    }

    @Override
    public void turn() {
        super.turn();
        ++this.turnCount;
        this.expressAnxiety(this.turnCount);
    }

    @Override
    public void move() {
        super.move();
        this.turnCount = 0;
    }

    @Override
    public void expressAnxiety(int tightness) {
        Grid<Actor> myGrid = this.getGrid();
        Location myLocn = this.getLocation();
        DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tBruce turnCount: " + this.turnCount + "/" + this.turnThreshold + "\n";
        System.out.println("turnCount = " + this.turnCount + "/" + this.turnThreshold);
        if (this.turnCount >= this.turnThreshold) {
            GeologistHulk myHulk = new GeologistHulk(this);
            this.removeSelfFromGrid();
            myHulk.putSelfInGrid(myGrid, myLocn);
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tEnter the Hulk!\n";
        }
    }

    public int getTurnCount() {
        return this.turnCount;
    }

    public void setTurnCount(int x) {
        this.turnCount = x;
    }
}

