/*
 * Decompiled with CFR 0.152.
 */
import info.gridworld.actor.Actor;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;

public class Spawner
extends FreeElasticAgent
implements SuperPowers {
    public Spawner() {
        this.setColor(Color.PINK);
        this.shouldShowPath = false;
    }

    public Spawner(Random myRNG) {
        this();
        this.setRNG(myRNG);
        this.initializeDirection();
    }

    public Spawner(Random myRNG, boolean showPathStatus) {
        this(myRNG);
        this.shouldShowPath = showPathStatus;
        this.initializeDirection();
    }

    @Override
    public void act() {
        DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "Step Count: " + ++DirtDauberDriver.driverCount + " -- H: " + DirtDauberDriver.humanCount + ", S: " + DirtDauberDriver.statueCount + "\n";
        DirtDauberDriver.humanLog = String.valueOf(DirtDauberDriver.humanLog) + DirtDauberDriver.driverCount + "," + DirtDauberDriver.humanCount + "\n";
        DirtDauberDriver.statueLog = String.valueOf(DirtDauberDriver.statueLog) + DirtDauberDriver.driverCount + "," + DirtDauberDriver.statueCount + "\n";
        if (super.canMove()) {
            this.move();
        } else {
            super.turn();
        }
    }

    @Override
    public void move() {
        super.move();
        this.moveWithPowers();
    }

    @Override
    public void moveWithPowers() {
        Actor myTarget = this.getInlineNeighbor();
        this.affectNeighbor(myTarget);
    }

    @Override
    public Actor getInlineNeighbor() {
        Location myLocn = this.getLocation();
        int myDirn = this.getDirection();
        Grid<Actor> gr = this.getGrid();
        Location next = myLocn.getAdjacentLocation(myDirn);
        Actor myInlineNeighbor = gr.get(next);
        return myInlineNeighbor;
    }

    @Override
    public ArrayList<Actor> getAllNeighbors() {
        Location myLocn = this.getLocation();
        Grid<Actor> gr = this.getGrid();
        ArrayList<Actor> myNeighbors = gr.getNeighbors(myLocn);
        return myNeighbors;
    }

    @Override
    public void affectNeighbor(Actor a) {
        if (a instanceof Portal) {
            Grid<Actor> myGrid = this.getGrid();
            ++DirtDauberDriver.humanCount;
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tSpawner released a Human\n";
            System.out.println("hit a portal, release a Human");
            Location myLocn = this.getLocation();
            ArrayList<Location> emptySpots = myGrid.getEmptyAdjacentLocations(myLocn);
            int numSpots = emptySpots.size();
            Location birthPlace = null;
            if (numSpots > 0) {
                birthPlace = emptySpots.get(0);
            }
            if (birthPlace != null) {
                Human h = new Human(this.getRNG());
                this.colorizeHuman(h);
                h.putSelfInGrid(myGrid, birthPlace);
            }
        }
    }

    @Override
    public void affectNeighbors(ArrayList<Actor> a) {
    }

    public void colorizeHuman(Human h) {
        int spinner = TCAMath.getRandom(this.getRNG(), 1, 4);
        switch (spinner) {
            case 1: {
                h.setColor(new Color(244, 195, 160));
                break;
            }
            case 2: {
                h.setColor(new Color(193, 80, 41));
                break;
            }
            case 3: {
                h.setColor(new Color(101, 57, 1));
                break;
            }
            case 4: {
                h.setColor(new Color(220, 219, 119));
            }
        }
    }
}

