/*
 * Decompiled with CFR 0.152.
 */
import info.gridworld.actor.Actor;
import info.gridworld.actor.Rock;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;

public class MadScientist
extends Human
implements SuperPowers {
    protected int angerLevel;
    protected boolean isInCorner;
    private Location previousCorner;
    protected int stepCount;
    private int redTint;
    private int greenTint;
    private int blueTint;
    protected int calmingSteps;

    public MadScientist(Random myRNG) {
        super(myRNG);
        this.angerLevel = 0;
        this.calmingSteps = 20;
        this.computeColor(this.angerLevel);
        this.stepCount = 0;
        this.isInCorner = false;
    }

    public MadScientist(Hulk h) {
        super(h.getRNG());
        this.setDirection(h.getDirection());
        this.angerLevel = 0;
        this.calmingSteps = 20;
        this.computeColor(this.angerLevel);
        this.stepCount = 0;
        this.isInCorner = false;
    }

    @Override
    public void act() {
        DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tScientist anger = " + this.angerLevel + "\n";
        DirtDauberDriver.angerLog = String.valueOf(DirtDauberDriver.angerLog) + DirtDauberDriver.driverCount + "," + this.angerLevel + "\n";
        if (super.canMove()) {
            this.move();
        } else {
            super.turn();
        }
    }

    @Override
    public void move() {
        super.move();
        ++this.stepCount;
        if (this.stepCount % this.calmingSteps == 0 && this.angerLevel > 0) {
            --this.angerLevel;
            this.computeColor(this.angerLevel);
            System.out.println("Walked off some anger..." + this.angerLevel);
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tScientist walking off anger: " + this.angerLevel + "\n";
        }
        this.moveWithPowers();
    }

    @Override
    public void turn() {
        super.turn();
        Location myLocn = this.getLocation();
        Grid<Actor> myGrid = this.getGrid();
        if (this.reportCorner(myGrid, myLocn) > -1) {
            --this.angerLevel;
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tScientist turning in corner; anger/anxiety: " + this.angerLevel + "\n";
            System.out.println("Turn turn turn: " + this.angerLevel);
            this.computeColor(this.angerLevel);
            this.isInCorner = true;
        }
    }

    @Override
    public void moveWithPowers() {
        ArrayList<Actor> myNeighbors = this.getAllNeighbors();
        this.affectNeighbors(myNeighbors);
        Grid<Actor> myGrid = this.getGrid();
        Location myLocn = this.getLocation();
        if (this.angerLevel >= 5) {
            Hulk myHulk = new Hulk(this);
            this.removeSelfFromGrid();
            myHulk.putSelfInGrid(myGrid, myLocn);
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tEnter the Hulk!\n";
        }
        if (this.reportCorner(myGrid, myLocn) > -1) {
            --this.angerLevel;
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tScientist cooling in corner; anger/anxiety: " + this.angerLevel + "\n";
            System.out.println("Deep cleansing breaths in the corner: " + this.angerLevel);
            this.computeColor(this.angerLevel);
            this.isInCorner = true;
        } else if (this.isInCorner) {
            System.out.println("---escaping corner...");
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tScientist escaped corner, anger/anxiety = : " + this.angerLevel + "\n";
            this.isInCorner = false;
            Rock myRock = new Rock();
            myRock.putSelfInGrid(myGrid, this.previousCorner);
        }
    }

    public int reportCorner(Grid<Actor> g, Location myLocn) {
        int cornerNum = -1;
        Location NW_CORNER = new Location(0, 0);
        Location NE_CORNER = new Location(0, g.getNumCols() - 1);
        Location SE_CORNER = new Location(g.getNumRows() - 1, g.getNumCols() - 1);
        Location SW_CORNER = new Location(g.getNumRows() - 1, 0);
        if (myLocn.equals(NW_CORNER)) {
            cornerNum = 0;
            this.previousCorner = NW_CORNER;
        } else if (myLocn.equals(NE_CORNER)) {
            cornerNum = 1;
            this.previousCorner = NE_CORNER;
        } else if (myLocn.equals(SE_CORNER)) {
            cornerNum = 2;
            this.previousCorner = SE_CORNER;
        } else if (myLocn.equals(SW_CORNER)) {
            cornerNum = 3;
            this.previousCorner = SW_CORNER;
        }
        return cornerNum;
    }

    @Override
    public Actor getInlineNeighbor() {
        Location myLocn = this.getLocation();
        int myDirn = this.getDirection();
        Grid<Actor> gr = this.getGrid();
        Location next = myLocn.getAdjacentLocation(myDirn);
        Actor myInlineNeighbor = gr.get(next);
        return myInlineNeighbor;
    }

    @Override
    public ArrayList<Actor> getAllNeighbors() {
        Location myLocn = this.getLocation();
        Grid<Actor> gr = this.getGrid();
        ArrayList<Actor> myNeighbors = gr.getNeighbors(myLocn);
        return myNeighbors;
    }

    @Override
    public void affectNeighbor(Actor a) {
    }

    @Override
    public void affectNeighbors(ArrayList<Actor> a) {
        for (Actor x : a) {
            if (x instanceof WhiteWitch) {
                ++this.angerLevel;
                this.stepCount = 0;
                if (this.angerLevel > 5) {
                    this.angerLevel = 5;
                }
                System.out.println("You wouldn't like me when I'm angry..." + this.angerLevel);
                DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tScientist angered by witch: " + this.angerLevel + "\n";
                this.computeColor(this.angerLevel);
            }
            if (!(x instanceof Portal) || this.angerLevel >= 0) continue;
            this.angerLevel = 0;
            this.computeColor(this.angerLevel);
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tScientist negative anger zeroed by portal; anger/anxiety: " + this.angerLevel + "\n";
            System.out.println("Mellowed Scientist hit cloning booth: anger reset to zero");
        }
    }

    public int getAngerLevel() {
        return this.angerLevel;
    }

    public void setAngerLevel(int x) {
        this.angerLevel = x;
        if (this.angerLevel > 5) {
            this.angerLevel = 5;
        }
        this.computeColor(this.angerLevel);
    }

    protected void computeColor(int aL) {
        switch (aL) {
            case 5: {
                this.redTint = 255;
                this.greenTint = 55;
                this.blueTint = 55;
                break;
            }
            case 4: {
                this.redTint = 255;
                this.greenTint = 75;
                this.blueTint = 75;
                break;
            }
            case 3: {
                this.redTint = 255;
                this.greenTint = 100;
                this.blueTint = 100;
                break;
            }
            case 2: {
                this.redTint = 255;
                this.greenTint = 125;
                this.blueTint = 125;
                break;
            }
            case 1: {
                this.redTint = 255;
                this.greenTint = 165;
                this.blueTint = 165;
                break;
            }
            case 0: {
                this.redTint = 255;
                this.greenTint = 195;
                this.blueTint = 185;
                break;
            }
            default: {
                this.redTint = 255;
                this.greenTint = 195;
                this.blueTint = 185;
            }
        }
        this.setColor(new Color(this.redTint, this.greenTint, this.blueTint));
    }
}

