/*
 * Decompiled with CFR 0.152.
 */
import info.gridworld.actor.Actor;
import info.gridworld.actor.Rock;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;

public class Hulk
extends FreeElasticAgent
implements SuperPowers {
    protected int angerLevel;
    private int redTint;
    private int greenTint;
    private int blueTint;
    protected int maxAnger;

    public Hulk() {
        this.angerLevel = 5;
        this.computeColor(this.angerLevel);
        this.greenTint = 150;
        this.redTint = 100;
        this.blueTint = 100;
        this.shouldShowPath = false;
        this.maxAnger = 5;
    }

    public Hulk(Random myRNG) {
        this();
        this.setRNG(myRNG);
        this.initializeDirection();
        this.angerLevel = 5;
        this.maxAnger = 5;
        this.computeColor(this.angerLevel);
    }

    public Hulk(Random myRNG, boolean showPathStatus) {
        this(myRNG);
        this.shouldShowPath = showPathStatus;
        this.initializeDirection();
        this.angerLevel = 5;
        this.maxAnger = 5;
        this.computeColor(this.angerLevel);
    }

    public Hulk(MadScientist ms) {
        this.setRNG(ms.getRNG());
        this.setDirection(ms.getDirection());
        this.angerLevel = 5;
        this.maxAnger = 5;
        this.computeColor(this.angerLevel);
    }

    protected void computeColor(int aL) {
        switch (aL) {
            case 5: {
                this.redTint = 100;
                this.greenTint = 150;
                this.blueTint = 100;
                break;
            }
            case 4: {
                this.redTint = 120;
                this.greenTint = 140;
                this.blueTint = 110;
                break;
            }
            case 3: {
                this.redTint = 140;
                this.greenTint = 130;
                this.blueTint = 120;
                break;
            }
            case 2: {
                this.redTint = 160;
                this.greenTint = 120;
                this.blueTint = 130;
                break;
            }
            case 0: 
            case 1: {
                this.redTint = 180;
                this.greenTint = 110;
                this.blueTint = 140;
                break;
            }
            default: {
                this.redTint = 180;
                this.greenTint = 110;
                this.blueTint = 140;
            }
        }
        if (this.angerLevel > 5) {
            this.redTint = 100;
            this.greenTint = 150;
            this.blueTint = 100;
        }
        this.setColor(new Color(this.redTint, this.greenTint, this.blueTint));
    }

    @Override
    public void act() {
        DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk anger = " + this.angerLevel + "\n";
        DirtDauberDriver.angerLog = String.valueOf(DirtDauberDriver.angerLog) + DirtDauberDriver.driverCount + "," + this.angerLevel + "\n";
        if (super.canMove()) {
            this.move();
        } else {
            super.turn();
        }
    }

    @Override
    public void move() {
        super.move();
        this.moveWithPowers();
    }

    @Override
    public void moveWithPowers() {
        Actor myTarget = this.getInlineNeighbor();
        this.affectNeighbor(myTarget);
        ArrayList<Actor> myNeighbors = this.getAllNeighbors();
        this.affectNeighbors(myNeighbors);
        if (this.angerLevel <= 0) {
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk exits: " + this.angerLevel + "\n";
            Grid<Actor> myGrid = this.getGrid();
            MadScientist albert = new MadScientist(this);
            Location loc = this.getLocation();
            this.removeSelfFromGrid();
            albert.putSelfInGrid(myGrid, loc);
        }
    }

    @Override
    public Actor getInlineNeighbor() {
        Location myLocn = this.getLocation();
        int myDirn = this.getDirection();
        Grid<Actor> gr = this.getGrid();
        Location next = myLocn.getAdjacentLocation(myDirn);
        Actor myInlineNeighbor = gr.get(next);
        return myInlineNeighbor;
    }

    @Override
    public ArrayList<Actor> getAllNeighbors() {
        Location myLocn = this.getLocation();
        Grid<Actor> gr = this.getGrid();
        ArrayList<Actor> myNeighbors = gr.getNeighbors(myLocn);
        return myNeighbors;
    }

    @Override
    public void affectNeighbor(Actor a) {
        if (a instanceof Statue || a instanceof Rock) {
            a.removeSelfFromGrid();
            --this.angerLevel;
            if (a instanceof Statue) {
                --DirtDauberDriver.statueCount;
                DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk smashes statue: " + this.angerLevel + "\n";
            } else {
                DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk smashes rock neighbor; anger/anxiety: " + this.angerLevel + "\n";
                --DirtDauberDriver.rockCount;
            }
            System.out.println("hulk smash! + angerLevel = " + this.angerLevel);
            this.computeColor(this.angerLevel);
        }
    }

    @Override
    public void affectNeighbors(ArrayList<Actor> a) {
        for (Actor x : a) {
            if (x instanceof WhiteWitch) {
                ++this.angerLevel;
                if (this.angerLevel > 5) {
                    this.angerLevel = 5;
                }
                DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk angered by witch: " + this.angerLevel + "\n";
                System.out.println("You're making me angry..." + this.angerLevel);
                this.computeColor(this.angerLevel);
                continue;
            }
            if (!(x instanceof Spawner)) continue;
            --this.angerLevel;
            if (this.angerLevel < 1) {
                this.angerLevel = 1;
            }
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk calmed by Spawner: " + this.angerLevel + "\n";
            System.out.println("You are calming me..." + this.angerLevel);
            this.computeColor(this.angerLevel);
        }
    }

    public int getAngerLevel() {
        return this.angerLevel;
    }

    public void setAngerLevel(int x) {
        if (x < 0) {
            x = 0;
        }
        if (x > this.maxAnger) {
            x = this.maxAnger;
        }
        this.angerLevel = x;
        this.computeColor(this.angerLevel);
    }
}

