/*
 * Decompiled with CFR 0.152.
 */
import info.gridworld.actor.Actor;
import info.gridworld.actor.Rock;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.util.ArrayList;

public class GeologistHulk
extends Hulk
implements Claustrophobia {
    public int turnCount;
    public int turnThreshold;

    public GeologistHulk(Spelunker spelunker) {
        super(spelunker);
        this.turnCount = spelunker.turnCount;
        this.turnThreshold = spelunker.turnThreshold;
        this.angerLevel = 7;
        this.maxAnger = 10;
    }

    @Override
    public void moveWithPowers() {
        Actor myTarget = this.getInlineNeighbor();
        this.affectNeighbor(myTarget);
        ArrayList<Actor> myNeighbors = this.getAllNeighbors();
        this.affectNeighbors(myNeighbors);
        if (this.angerLevel <= 0) {
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk exits; anger/anxiety: " + this.angerLevel + "\n";
            Grid<Actor> myGrid = this.getGrid();
            Spelunker al = new Spelunker(this);
            Location loc = this.getLocation();
            this.removeSelfFromGrid();
            al.putSelfInGrid(myGrid, loc);
        }
    }

    @Override
    public void affectNeighbors(ArrayList<Actor> a) {
        int numRockNeighbors = 0;
        for (Actor x : a) {
            if (!(x instanceof Rock)) continue;
            ++numRockNeighbors;
        }
        System.out.println(String.valueOf(numRockNeighbors) + " numRockNeighbors now");
        if (numRockNeighbors >= 4) {
            if ((double)this.angerLevel >= 0.5 * (double)this.maxAnger) {
                DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk overcrowded by " + numRockNeighbors + " rocks!; anger/anxiety: " + this.angerLevel + "\n";
                DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk smash all rock neighbors!!!!; anger/anxiety: " + this.angerLevel + "\n";
                for (Actor n : a) {
                    if (!(n instanceof Rock)) continue;
                    n.removeSelfFromGrid();
                    --DirtDauberDriver.rockCount;
                    --this.angerLevel;
                    DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tBAMM!!; anger/anxiety: " + this.angerLevel + "\n";
                    this.computeColor(this.angerLevel);
                }
            } else {
                int randomRock;
                Actor myActor = null;
                while (!((myActor = a.get(randomRock = TCAMath.getRandom(this.getRNG(), 0, a.size() - 1))) instanceof Rock)) {
                }
                myActor.removeSelfFromGrid();
                --this.angerLevel;
                DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk smash single random rock neighbor!; anger/anxiety: " + this.angerLevel + "\n";
                --DirtDauberDriver.rockCount;
                this.computeColor(this.angerLevel);
            }
        }
        if (!this.canMove()) {
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk can't move?!; anger/anxiety: " + this.angerLevel + "\n";
        }
    }

    @Override
    public boolean canMove() {
        Grid<Actor> gr = this.getGrid();
        if (gr == null) {
            return false;
        }
        Location loc = this.getLocation();
        Location next = loc.getAdjacentLocation(this.getDirection());
        if (!gr.isValid(next)) {
            return false;
        }
        Actor neighbor = gr.get(next);
        if (neighbor instanceof Rock) {
            --this.angerLevel;
            neighbor.removeSelfFromGrid();
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk smash lineofsight rock; anger/anxiety: " + this.angerLevel + "\n";
        }
        if (neighbor instanceof DirtDauber) {
            this.angerLevel = this.maxAnger;
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk hates Dave!! ARGH!!!!; anger/anxiety: " + this.angerLevel + "\n";
            this.computeColor(this.angerLevel);
        }
        return neighbor == null || neighbor instanceof Rock;
    }

    @Override
    public void act() {
        if (super.canMove()) {
            this.move();
        } else {
            this.turn();
        }
        DirtDauberDriver.angerLogH = String.valueOf(DirtDauberDriver.angerLogH) + DirtDauberDriver.driverCount + "," + this.angerLevel + "\n";
    }

    @Override
    public void turn() {
        super.turn();
        ++this.turnCount;
        this.expressAnxiety(this.turnCount);
    }

    @Override
    public void move() {
        super.move();
        this.turnCount = 0;
    }

    @Override
    public void expressAnxiety(int tightness) {
        DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk turnCount: " + this.turnCount + "/" + this.turnThreshold + "\n";
        System.out.println("turnCount = " + this.turnCount + "/" + this.turnThreshold);
        if (this.turnCount >= this.turnThreshold) {
            DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "\tHulk feels trapped like rat!: " + this.turnCount + "/" + this.turnThreshold + "\n";
            ArrayList<Actor> myNeighbors = this.getAllNeighbors();
            this.affectNeighbors(myNeighbors);
        }
    }

    public int getTurnCount() {
        return this.turnCount;
    }
}

