/*
 * Decompiled with CFR 0.152.
 */
import info.gridworld.actor.Actor;
import info.gridworld.actor.Flower;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;

public abstract class FreeElasticAgent
extends FreeAgent
implements Elasticity {
    @Override
    public void act() {
        super.act();
    }

    @Override
    public void move() {
        Grid<Actor> gr = this.getGrid();
        if (gr == null) {
            return;
        }
        Location loc = this.getLocation();
        Location next = loc.getAdjacentLocation(this.getDirection());
        int corner = this.reportCorner(this.getGrid(), next);
        int wall = this.reportWall(this.getGrid(), next);
        if (corner > -1) {
            this.escapeCorner(this.getGrid(), corner);
        } else if (wall > -1) {
            this.bounceOffWall(this.getGrid(), wall);
        }
        if (gr.isValid(next)) {
            this.moveTo(next);
        } else {
            this.removeSelfFromGrid();
        }
        if (this.shouldShowPath) {
            Flower flower = new Flower(this.getColor());
            flower.putSelfInGrid(gr, loc);
        }
    }

    @Override
    public int reportWall(Grid<Actor> g, Location myLocn) {
        int wallNum = -1;
        if (myLocn.getRow() == 0) {
            wallNum = 0;
        } else if (myLocn.getCol() == g.getNumCols() - 1) {
            wallNum = 1;
        } else if (myLocn.getRow() == g.getNumRows() - 1) {
            wallNum = 2;
        } else if (myLocn.getCol() == 0) {
            wallNum = 3;
        }
        return wallNum;
    }

    @Override
    public int reportCorner(Grid<Actor> g, Location myLocn) {
        int cornerNum = -1;
        Location NW_CORNER = new Location(0, 0);
        Location NE_CORNER = new Location(0, g.getNumCols() - 1);
        Location SE_CORNER = new Location(g.getNumRows() - 1, g.getNumCols() - 1);
        Location SW_CORNER = new Location(g.getNumRows() - 1, 0);
        if (myLocn.equals(NW_CORNER)) {
            cornerNum = 0;
        } else if (myLocn.equals(NE_CORNER)) {
            cornerNum = 1;
        } else if (myLocn.equals(SE_CORNER)) {
            cornerNum = 2;
        } else if (myLocn.equals(SW_CORNER)) {
            cornerNum = 3;
        }
        return cornerNum;
    }

    @Override
    public void bounceOffWall(Grid<Actor> g, int w) {
        int myDirn = -1;
        switch (w) {
            case 0: {
                myDirn = TCAMath.getRandom(this.getRNG(), 90, 270);
                break;
            }
            case 1: {
                myDirn = TCAMath.getRandom(this.getRNG(), 180, 359);
                break;
            }
            case 2: {
                myDirn = TCAMath.getRandom(this.getRNG(), -90, 90);
                break;
            }
            case 3: {
                myDirn = TCAMath.getRandom(this.getRNG(), 0, 180);
            }
        }
        this.setDirection(myDirn);
    }

    @Override
    public void escapeCorner(Grid<Actor> g, int c) {
        int myDirn = -1;
        switch (c) {
            case 0: {
                myDirn = TCAMath.getRandom(this.getRNG(), 90, 180);
                break;
            }
            case 1: {
                myDirn = TCAMath.getRandom(this.getRNG(), 180, 270);
                break;
            }
            case 2: {
                myDirn = TCAMath.getRandom(this.getRNG(), 270, 360);
                break;
            }
            case 3: {
                myDirn = TCAMath.getRandom(this.getRNG(), 0, 90);
            }
        }
        this.setDirection(myDirn);
    }
}

