/*
 * Decompiled with CFR 0.152.
 */
import info.gridworld.actor.Actor;
import info.gridworld.actor.Flower;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.util.Random;

public abstract class FreeAgent
extends Actor {
    private Random rng;
    protected boolean shouldShowPath;

    @Override
    public void act() {
        if (this.canMove()) {
            this.move();
        } else {
            this.turn();
        }
    }

    public void move() {
        Grid<Actor> gr = this.getGrid();
        if (gr == null) {
            return;
        }
        Location loc = this.getLocation();
        Location next = loc.getAdjacentLocation(this.getDirection());
        if (gr.isValid(next)) {
            this.moveTo(next);
        } else {
            this.removeSelfFromGrid();
        }
        if (this.shouldShowPath) {
            Flower flower = new Flower(this.getColor());
            flower.putSelfInGrid(gr, loc);
        }
    }

    public boolean canMove() {
        Grid<Actor> gr = this.getGrid();
        if (gr == null) {
            return false;
        }
        Location loc = this.getLocation();
        Location next = loc.getAdjacentLocation(this.getDirection());
        if (!gr.isValid(next)) {
            return false;
        }
        Actor neighbor = gr.get(next);
        return neighbor == null || neighbor instanceof Flower;
    }

    public void turn() {
        int dirn = this.generateRandomDirection();
        this.setDirection(this.getDirection() + dirn);
    }

    private int generateRandomDirection() {
        int myDirn = TCAMath.getRandom(this.rng, 0, 360);
        return myDirn;
    }

    public void setRNG(Random myRNG) {
        this.rng = myRNG;
    }

    public Random getRNG() {
        return this.rng;
    }

    protected void initializeDirection() {
        int newDirection = TCAMath.getRandom(this.getRNG(), 0, 360);
        this.setDirection(newDirection);
    }
}

