/*
 * Decompiled with CFR 0.152.
 */
import info.gridworld.actor.Actor;
import info.gridworld.actor.Rock;
import info.gridworld.grid.Grid;
import info.gridworld.grid.Location;
import java.awt.Color;
import java.util.Random;

public class DirtDauber
extends FreeElasticAgent
implements Sentinel {
    public int stepCount;
    public int frequency;

    public DirtDauber() {
        this.shouldShowPath = true;
        this.setColor(Color.ORANGE);
        this.stepCount = 0;
        this.frequency = 5;
    }

    public DirtDauber(Random myRNG) {
        this();
        this.setRNG(myRNG);
        this.initializeDirection();
    }

    public DirtDauber(Random myRNG, int f) {
        this();
        this.setRNG(myRNG);
        this.initializeDirection();
        this.frequency = f;
        if (this.frequency == 0) {
            this.shouldShowPath = false;
        }
    }

    @Override
    public void act() {
        if (super.canMove()) {
            this.move();
        } else {
            super.turn();
        }
        this.watchDriver();
    }

    @Override
    public void move() {
        ++this.stepCount;
        Grid<Actor> gr = this.getGrid();
        if (gr == null) {
            return;
        }
        Location loc = this.getLocation();
        Location next = loc.getAdjacentLocation(this.getDirection());
        int corner = this.reportCorner(this.getGrid(), next);
        int wall = this.reportWall(this.getGrid(), next);
        if (corner > -1) {
            this.escapeCorner(this.getGrid(), corner);
        } else if (wall > -1) {
            this.bounceOffWall(this.getGrid(), wall);
        }
        if (gr.isValid(next)) {
            this.moveTo(next);
        } else {
            this.removeSelfFromGrid();
        }
        if (this.shouldShowPath && this.stepCount % this.frequency == 0) {
            Rock r = new Rock(Color.GRAY);
            ++DirtDauberDriver.rockCount;
            r.putSelfInGrid(gr, loc);
        }
    }

    public void setFrequency(int x) {
        this.frequency = x;
        this.shouldShowPath = this.frequency != 0;
    }

    @Override
    public void watchDriver() {
        DirtDauberDriver.runningDialog = String.valueOf(DirtDauberDriver.runningDialog) + "Step Count: " + ++DirtDauberDriver.driverCount + ", rCount: " + DirtDauberDriver.rockCount + "\n";
        DirtDauberDriver.humanLog = String.valueOf(DirtDauberDriver.humanLog) + DirtDauberDriver.driverCount + "," + DirtDauberDriver.humanCount + "\n";
        DirtDauberDriver.statueLog = String.valueOf(DirtDauberDriver.statueLog) + DirtDauberDriver.driverCount + "," + DirtDauberDriver.statueCount + "\n";
        DirtDauberDriver.rockLog = String.valueOf(DirtDauberDriver.rockLog) + DirtDauberDriver.driverCount + ", " + DirtDauberDriver.rockCount + "\n";
    }

    @Override
    public int getDriverCount() {
        return DirtDauberDriver.driverCount;
    }
}

